/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.legacy.charts;

import org.pentaho.plugin.jfreereport.reportcharts.ChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.MultiPlotChartExpression;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.extensions.legacy.charts.LegacyChartType;

public class LegacyChartPreProcessor
extends AbstractReportPreProcessor {
    public MasterReport performPreProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        this.processSection((Section)definition, flowController.getDataSchema(), (AbstractReportDefinition)definition);
        return definition;
    }

    public SubReport performPreProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        this.processSection((Section)definition, flowController.getDataSchema(), (AbstractReportDefinition)definition);
        return definition;
    }

    private void processSection(Section section, DataSchema dataSchema, AbstractReportDefinition reportDefinition) throws ReportProcessingException {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Expression maybeChartExpression;
            Element element = section.getElement(i);
            if (element instanceof SubReport) continue;
            if (element instanceof Section) {
                this.processSection((Section)element, dataSchema, reportDefinition);
                continue;
            }
            Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
            if (!(attribute instanceof LegacyChartType) || !((maybeChartExpression = element.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value")) instanceof ChartExpression)) continue;
            ChartExpression chartExpression = (ChartExpression)maybeChartExpression;
            Object primaryChartExpression = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/legacy/charting/1.0", "primary-dataset-expression");
            if (primaryChartExpression instanceof Expression) {
                Expression datasetExpression = (Expression)primaryChartExpression;
                Expression datasetExpressionInstance = datasetExpression.getInstance();
                String name = AutoGeneratorUtility.generateUniqueExpressionName((DataSchema)dataSchema, (String)"::legacy-charts::primary-dataset::{0}", (AbstractReportDefinition)reportDefinition);
                datasetExpressionInstance.setName(name);
                chartExpression.setDataSource(name);
                reportDefinition.addExpression(datasetExpressionInstance);
            }
            if (!(chartExpression instanceof MultiPlotChartExpression)) continue;
            MultiPlotChartExpression multiPlotChartExpression = (MultiPlotChartExpression)chartExpression;
            Object secondaryDataSourceExpression = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/legacy/charting/1.0", "secondary-dataset-expression");
            if (!(secondaryDataSourceExpression instanceof Expression)) continue;
            Expression datasetExpression = (Expression)secondaryDataSourceExpression;
            Expression datasetExpressionInstance = datasetExpression.getInstance();
            String name = AutoGeneratorUtility.generateUniqueExpressionName((DataSchema)dataSchema, (String)"::legacy-charts::secondary-dataset::{0}", (AbstractReportDefinition)reportDefinition);
            datasetExpressionInstance.setName(name);
            multiPlotChartExpression.setSecondaryDataSet(name);
            reportDefinition.addExpression(datasetExpressionInstance);
        }
    }
}

