/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.AbstractCollectorFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class IntervalXYSeriesCollector
extends AbstractCollectorFunction {
    private ArrayList<String> xMinValueColumns = new ArrayList();
    private ArrayList<String> yMinValueColumns = new ArrayList();
    private ArrayList<String> xMaxValueColumns = new ArrayList();
    private ArrayList<String> yMaxValueColumns = new ArrayList();

    @Override
    protected Dataset createNewDataset() {
        return new XYIntervalSeriesCollection();
    }

    public void setXMinValueColumn(int index, String field) {
        if (this.xMinValueColumns.size() == index) {
            this.xMinValueColumns.add(field);
        } else {
            this.xMinValueColumns.set(index, field);
        }
    }

    public String getXMinValueColumn(int index) {
        return this.xMinValueColumns.get(index);
    }

    public int getXMinValueColumnCount() {
        return this.xMinValueColumns.size();
    }

    public String[] getXMinValueColumn() {
        return this.xMinValueColumns.toArray(new String[this.xMinValueColumns.size()]);
    }

    public void setXMinValueColumn(String[] fields) {
        this.xMinValueColumns.clear();
        this.xMinValueColumns.addAll(Arrays.asList(fields));
    }

    public void setYMinValueColumn(int index, String field) {
        if (this.yMinValueColumns.size() == index) {
            this.yMinValueColumns.add(field);
        } else {
            this.yMinValueColumns.set(index, field);
        }
    }

    public String getYMinValueColumn(int index) {
        return this.yMinValueColumns.get(index);
    }

    public int getYMinValueColumnCount() {
        return this.yMinValueColumns.size();
    }

    public String[] getYMinValueColumn() {
        return this.yMinValueColumns.toArray(new String[this.yMinValueColumns.size()]);
    }

    public void setYMinValueColumn(String[] fields) {
        this.yMinValueColumns.clear();
        this.yMinValueColumns.addAll(Arrays.asList(fields));
    }

    public void setYMaxValueColumn(int index, String field) {
        if (this.xMaxValueColumns.size() == index) {
            this.xMaxValueColumns.add(field);
        } else {
            this.xMaxValueColumns.set(index, field);
        }
    }

    public String getXMaxValueColumn(int index) {
        return this.xMaxValueColumns.get(index);
    }

    public int getXMaxValueColumnCount() {
        return this.xMaxValueColumns.size();
    }

    public String[] getXMaxValueColumn() {
        return this.xMaxValueColumns.toArray(new String[this.xMaxValueColumns.size()]);
    }

    public void setXMaxValueColumn(String[] fields) {
        this.xMaxValueColumns.clear();
        this.xMaxValueColumns.addAll(Arrays.asList(fields));
    }

    public String getYMaxValueColumn(int index) {
        return this.yMaxValueColumns.get(index);
    }

    public int getYMaxValueColumnCount() {
        return this.yMaxValueColumns.size();
    }

    public String[] getYMaxValueColumn() {
        return this.yMaxValueColumns.toArray(new String[this.yMaxValueColumns.size()]);
    }

    public void setYMaxValueColumn(String[] fields) {
        this.yMaxValueColumns.clear();
        this.yMaxValueColumns.addAll(Arrays.asList(fields));
    }

    @Override
    public Expression getInstance() {
        IntervalXYSeriesCollector expression = (IntervalXYSeriesCollector)super.getInstance();
        expression.xMinValueColumns = (ArrayList)this.xMinValueColumns.clone();
        expression.yMinValueColumns = (ArrayList)this.yMinValueColumns.clone();
        expression.xMaxValueColumns = (ArrayList)this.xMaxValueColumns.clone();
        expression.yMaxValueColumns = (ArrayList)this.yMaxValueColumns.clone();
        return expression;
    }

    @Override
    protected void buildDataset() {
        XYIntervalSeriesCollection xyIntervalxySeriesDataset = (XYIntervalSeriesCollection)this.getDataSet();
        int maxIndex = Math.min(this.yMaxValueColumns.size(), Math.min(this.xMinValueColumns.size(), Math.min(this.yMinValueColumns.size(), this.xMaxValueColumns.size())));
        for (int i = 0; i < maxIndex; ++i) {
            XYIntervalSeries xyIntervalSeries;
            Number yMaxValue;
            Comparable seriesName = this.querySeriesValue(i);
            Object xValueObject = this.getDataRow().get(this.xMinValueColumns.get(i));
            Object yValueObject = this.getDataRow().get(this.yMinValueColumns.get(i));
            Object xMaxValueObject = this.getDataRow().get(this.xMaxValueColumns.get(i));
            Object yMaxValueObject = this.getDataRow().get(this.yMaxValueColumns.get(i));
            Number xValue = xValueObject instanceof Number ? (Number)((Number)xValueObject) : (Number)null;
            Number yValue = yValueObject instanceof Number ? (Number)((Number)yValueObject) : (Number)null;
            Number xMaxValue = xMaxValueObject instanceof Number ? (Number)((Number)xMaxValueObject) : (Number)null;
            Number number = yMaxValue = yMaxValueObject instanceof Number ? (Number)((Number)yMaxValueObject) : (Number)null;
            if (xValue == null || yValue == null || xMaxValue == null || yMaxValue == null) continue;
            int index = xyIntervalxySeriesDataset.indexOf(seriesName);
            if (index == -1) {
                xyIntervalSeries = new XYIntervalSeries(seriesName);
                xyIntervalxySeriesDataset.addSeries(xyIntervalSeries);
            } else {
                xyIntervalSeries = xyIntervalxySeriesDataset.getSeries(index);
            }
            xyIntervalSeries.add(xValue.doubleValue(), xValue.doubleValue(), xMaxValue.doubleValue(), yValue.doubleValue(), yValue.doubleValue(), yMaxValue.doubleValue());
        }
    }
}

