/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.urls.XYZURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.GenericExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.WrapperExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class FormulaXYZURLGenerator
implements XYZURLGenerator {
    private FormulaExpression formulaExpression;
    private ExpressionRuntime runtime;
    private static final String[] ADDITIONAL_COLUMN_KEYS = new String[]{"chart::x-value", "chart::y-value", "chart::z-value", "chart::series-index", "chart::series-key", "chart::series-count", "chart::item-index", "chart::item-count"};

    public FormulaXYZURLGenerator(ExpressionRuntime runtime, String formula) {
        this.runtime = new GenericExpressionRuntime(runtime);
        this.formulaExpression = new FormulaExpression();
        this.formulaExpression.setFormula(formula);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateURL(XYDataset dataset, int series, int item) {
        if (dataset instanceof XYZDataset) {
            return this.generateURL((XYZDataset)dataset, series, item);
        }
        try {
            Object[] values = new Object[]{dataset.getX(series, item), dataset.getY(series, item), null, IntegerCache.getInteger((int)series), dataset.getSeriesKey(series), IntegerCache.getInteger((int)dataset.getSeriesCount()), IntegerCache.getInteger((int)item), IntegerCache.getInteger((int)dataset.getItemCount(series))};
            this.formulaExpression.setRuntime((ExpressionRuntime)new WrapperExpressionRuntime((DataRow)new StaticDataRow(ADDITIONAL_COLUMN_KEYS, values), this.runtime));
            Object o = this.formulaExpression.getValue();
            if (o == null) {
                String string = null;
                return string;
            }
            String string = String.valueOf(o);
            return string;
        }
        finally {
            this.formulaExpression.setRuntime(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateURL(XYZDataset dataset, int series, int item) {
        try {
            Object[] values = new Object[]{dataset.getX(series, item), dataset.getY(series, item), dataset.getZ(series, item), IntegerCache.getInteger((int)series), dataset.getSeriesKey(series), IntegerCache.getInteger((int)dataset.getSeriesCount()), IntegerCache.getInteger((int)item), IntegerCache.getInteger((int)dataset.getItemCount(series))};
            this.formulaExpression.setRuntime((ExpressionRuntime)new WrapperExpressionRuntime((DataRow)new StaticDataRow(ADDITIONAL_COLUMN_KEYS, values), this.runtime));
            Object o = this.formulaExpression.getValue();
            if (o == null) {
                String string = null;
                return string;
            }
            String string = String.valueOf(o);
            return string;
        }
        finally {
            this.formulaExpression.setRuntime(null);
        }
    }
}

