/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel.transientimpl;

import java.util.Map;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.transientimpl.TransactionalIndex;
import org.netbeans.mdr.storagemodel.transientimpl.TransientMultivaluedOrderedIndex;

public abstract class CompensatingTransaction {
    protected Object key;
    protected Object oldValue;

    public CompensatingTransaction(Object key, Object oldValue) {
        this.key = key;
        this.oldValue = oldValue;
    }

    public abstract void perform(Object var1) throws StorageException;

    public static class AddCTx
    extends CompensatingTransaction {
        public AddCTx(Object key, Object oldValue) {
            super(key, oldValue);
        }

        public void perform(Object target) throws StorageException {
            ((TransactionalIndex)target).removeNoTx(this.key, this.oldValue);
        }
    }

    public static class RemoveCTx
    extends CompensatingTransaction {
        public RemoveCTx(Object key, Object oldValue) {
            super(key, oldValue);
        }

        public void perform(Object target) throws StorageException {
            ((TransactionalIndex)target).addNoTx(this.key, this.oldValue);
        }
    }

    public static class AddOrderedCTx
    extends AddCTx {
        int index;

        public AddOrderedCTx(Object key, Object value, int index) {
            super(key, value);
            this.index = index;
        }

        public void perform(Object target) throws StorageException {
            ((TransientMultivaluedOrderedIndex)target).removeNoTx(this.key, this.oldValue, this.index);
        }
    }

    public static class RemoveOrderedCTx
    extends RemoveCTx {
        int index;

        public RemoveOrderedCTx(Object key, Object value, int index) {
            super(key, value);
            this.index = index;
        }

        public void perform(Object target) throws StorageException {
            ((TransientMultivaluedOrderedIndex)target).addNoTx(this.key, this.oldValue, this.index);
        }
    }

    public static class CreateIndexCTx
    extends CompensatingTransaction {
        public CreateIndexCTx(Object key, Object value) {
            super(key, value);
        }

        public void perform(Object target) {
            ((Map)target).remove(this.key);
        }
    }

    public static class DropIndexCTx
    extends CompensatingTransaction {
        public DropIndexCTx(Object key, Object value) {
            super(key, value);
        }

        public void perform(Object target) {
            ((Map)target).put(this.key, this.oldValue);
        }
    }
}

