/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;

public class BtreeIterator
implements Iterator {
    protected Btree btree;
    protected SearchResult current;
    protected BtreePageSource pageSource;
    protected int modCount;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BtreeIterator(Btree btree) {
        try {
            try {
                this.btree = btree;
                this.pageSource = btree.pageSource;
                btree.beginRead();
                this.modCount = btree.modCount;
                this.current = btree.getFirst();
                if (this.current.entryNum >= 0) {
                    --this.current.entryNum;
                }
            }
            catch (StorageException e) {
                throw new RuntimeStorageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            btree.endRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            btree.endRead();
            return;
        }
    }

    public boolean hasNext() {
        block5: {
            this.btree.beginRead();
            this.checkModCount();
            if (BtreePage.hasNext(null, this.current)) break block5;
            this.pageSource.unpinPage(this.current.page);
            this.current.page = null;
            Object var2_1 = null;
            this.btree.endRead();
            return false;
        }
        try {
            Object var2_2 = null;
            this.btree.endRead();
            return true;
        }
        catch (StorageException e) {
            try {
                throw new RuntimeStorageException(e);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.btree.endRead();
                throw throwable;
            }
        }
    }

    public Object next() throws NoSuchElementException {
        block7: {
            if (this.current.page == null) {
                throw new NoSuchElementException();
            }
            this.btree.beginRead();
            this.checkModCount();
            BtreePage oldPage = this.current.page;
            BtreePage.getNext(null, this.current);
            if (this.current.page != oldPage) {
                this.pageSource.unpinPage(oldPage);
            }
            if (!this.current.matched) break block7;
            Object object = this.getCurrentItem();
            Object var3_3 = null;
            this.btree.endRead();
            return object;
        }
        try {
            try {
                throw new NoSuchElementException();
            }
            catch (StorageException e) {
                throw new RuntimeStorageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.btree.endRead();
            throw throwable;
        }
    }

    Object getCurrentItem() throws StorageException {
        return this.btree.dataInfo.fromBuffer(this.current.page.getData(this.current.entryNum));
    }

    void checkModCount() {
        if (this.btree.modCount > this.modCount) {
            throw new ConcurrentModificationException("Index " + this.btree.getName() + " has been modified since iterator was created.");
        }
    }

    protected void finalize() {
        if (this.current.page != null) {
            this.pageSource.unpinPage(this.current.page);
            this.current.page = null;
        }
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

