/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.reader;

import java.util.Map;
import net.minidev.json.JSONObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.jsoninput.JsonInputData;

public class RowOutputConverter {
    private final LogChannelInterface log;

    public RowOutputConverter(LogChannelInterface log) {
        this.log = log;
    }

    private Object getValue(ValueMetaInterface targetMeta, ValueMetaInterface strConvertMeta, Object value) throws KettleValueException {
        block3: {
            if (targetMeta.isNumeric()) {
                try {
                    return targetMeta.getNativeDataType(value);
                }
                catch (KettleValueException e) {
                    if (!this.log.isDebug()) break block3;
                    this.log.logDebug(e.getLocalizedMessage(), new Object[]{e});
                }
            }
        }
        String strValue = this.getStringValue(value);
        return targetMeta.convertDataFromString(strValue, strConvertMeta, null, null, targetMeta.getTrimType());
    }

    private String getStringValue(Object jo) {
        String nodevalue = null;
        if (jo != null) {
            if (jo instanceof Map) {
                Map asStrMap = (Map)jo;
                nodevalue = JSONObject.toJSONString((Map)asStrMap);
            } else {
                nodevalue = jo.toString();
            }
        }
        return nodevalue;
    }

    public Object[] getRow(Object[] baseOutputRow, Object[] rawPartRow, JsonInputData data) throws KettleException {
        if (rawPartRow == null) {
            return null;
        }
        for (int i = 0; i < rawPartRow.length; ++i) {
            Object val;
            int outIdx = data.totalpreviousfields + i;
            rawPartRow[i] = val = this.getValue(data.outputRowMeta.getValueMeta(outIdx), data.convertRowMeta.getValueMeta(outIdx), rawPartRow[i]);
            if (val != null || !data.repeatedFields.get(i) || data.previousRow == null) continue;
            rawPartRow[i] = data.previousRow[outIdx];
        }
        data.previousRow = RowDataUtil.addRowData((Object[])baseOutputRow, (int)data.totalpreviousfields, (Object[])rawPartRow);
        return data.previousRow;
    }
}

