/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.steps.jsoninput.json.Configuration;
import org.pentaho.di.trans.steps.jsoninput.json.node.ArrayNode;
import org.pentaho.di.trans.steps.jsoninput.json.node.Node;
import org.pentaho.di.trans.steps.jsoninput.json.node.ObjectNode;
import org.pentaho.di.trans.steps.jsoninput.json.node.ValueNode;

public class JsonSampler {
    private int start = 0;
    private Configuration configuration;
    private JsonFactory jsonFactory = new MappingJsonFactory();

    public JsonSampler(Configuration configuration) {
        this.configuration = configuration;
    }

    public JsonSampler() {
        this.configuration = new Configuration();
    }

    private Node sample(JsonParser jsonParser, Tree tree) throws IOException {
        jsonParser.enable(JsonParser.Feature.ALLOW_COMMENTS);
        Node node = null;
        while (jsonParser.nextToken() != null) {
            if (jsonParser.currentToken() == JsonToken.START_ARRAY) {
                node = new ArrayNode(null);
                this.sampleArray(jsonParser, (ArrayNode)node);
            }
            if (jsonParser.currentToken() == JsonToken.START_OBJECT) {
                node = new ObjectNode(null);
                this.sampleObject(jsonParser, (ObjectNode)node);
            }
            if (this.start <= this.configuration.getLines()) continue;
        }
        if (node != null && this.configuration.isDedupe()) {
            node.dedupe();
        }
        this.convertToSwtTree(node, null, tree);
        return node;
    }

    private void convertToSwtTree(Node node, TreeItem treeItem, Tree tree) {
        TreeItem item;
        TreeItem treeItem2 = item = Objects.isNull(treeItem) ? new TreeItem(tree, 0) : new TreeItem(treeItem, 0);
        if (Objects.nonNull(node)) {
            item.setData("Key", (Object)node.getKey());
            item.setData("Type", (Object)node.getType());
            if ("Object".equals(node.getType())) {
                this.processObject(node, tree, item);
            } else if ("Array".equals(node.getType())) {
                this.processArray(node, tree, item);
            } else {
                this.processValues(node, item);
            }
        }
    }

    private void processValues(Node node, TreeItem item) {
        Object value = ((ValueNode)node).getValue();
        if (Objects.nonNull(value) && value instanceof String) {
            item.setText(node.getKey() + ": \"" + value + "\"");
        } else {
            item.setText(node.getKey() + ": " + value);
        }
    }

    private void processArray(Node node, Tree tree, TreeItem item) {
        item.setText(node.getKey() + " : [");
        for (Node child : node.getChildren()) {
            this.convertToSwtTree(child, item, tree);
        }
    }

    private void processObject(Node node, Tree tree, TreeItem item) {
        item.setText(Objects.isNull(node.getKey()) ? "{" : node.getKey() + " : {");
        for (Node child : node.getChildren()) {
            this.convertToSwtTree(child, item, tree);
        }
    }

    public Node sample(InputStream inputStream, Tree tree) throws IOException {
        try (JsonParser jsonParser = this.jsonFactory.createParser(inputStream);){
            Node node = this.sample(jsonParser, tree);
            return node;
        }
    }

    public Node sample(String file, Tree tree) throws IOException, KettleFileException {
        return this.sample(KettleVFS.getInputStream((String)file), tree);
    }

    private void sampleArray(JsonParser jsonParser, ArrayNode arrayNode) throws IOException {
        ++this.start;
        if (this.start > this.configuration.getLines()) {
            return;
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            if (this.start > this.configuration.getLines()) {
                return;
            }
            Node node = this.getValue(jsonParser, null);
            arrayNode.addChild(node);
            if (node instanceof ObjectNode) {
                this.sampleObject(jsonParser, (ObjectNode)node);
            }
            if (!(node instanceof ArrayNode)) continue;
            this.sampleArray(jsonParser, (ArrayNode)node);
        }
    }

    private void sampleObject(JsonParser jsonParser, ObjectNode objectNode) throws IOException {
        ++this.start;
        if (this.start > this.configuration.getLines()) {
            return;
        }
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            if (this.start > this.configuration.getLines()) {
                return;
            }
            if (jsonParser.currentToken() != JsonToken.FIELD_NAME) continue;
            String name = jsonParser.getCurrentName();
            jsonParser.nextToken();
            Node node = this.getValue(jsonParser, name);
            if (node instanceof ObjectNode) {
                this.sampleObject(jsonParser, (ObjectNode)node);
            }
            if (node instanceof ArrayNode) {
                this.sampleArray(jsonParser, (ArrayNode)node);
            }
            objectNode.addValue(node);
        }
    }

    private Node getValue(JsonParser jsonParser, String key) {
        try {
            switch (jsonParser.currentToken()) {
                case START_OBJECT: {
                    return new ObjectNode(key);
                }
                case START_ARRAY: {
                    return new ArrayNode(key);
                }
                case VALUE_STRING: {
                    return new ValueNode<String>(key, jsonParser.getValueAsString());
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return new ValueNode<Boolean>(key, jsonParser.getValueAsBoolean());
                }
                case VALUE_NULL: {
                    return new ValueNode<Object>(key, null);
                }
                case VALUE_NUMBER_FLOAT: {
                    return new ValueNode<Double>(key, jsonParser.getValueAsDouble());
                }
                case VALUE_NUMBER_INT: {
                    return new ValueNode<BigInteger>(key, jsonParser.getBigIntegerValue());
                }
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void selectByPath(String path, TreeItem node) {
        List<String> expressions = this.getExpressions(path);
        if (!expressions.isEmpty()) {
            String expression = expressions.remove(0);
            while (StringUtils.isNotBlank((String)expression)) {
                if ("$".equals(expression)) {
                    expression = JsonSampler.stepOne(node, expressions);
                    continue;
                }
                if (".".equals(expression)) {
                    expression = this.stepTwo(node, expressions);
                    continue;
                }
                if ("..".equals(expression)) {
                    expression = this.stepThree(node, expressions);
                    continue;
                }
                if ("[*]".equals(expression) && !expressions.isEmpty()) {
                    expression = JsonSampler.stepFour(node, expressions);
                    continue;
                }
                expression = JsonSampler.stepFive(expressions);
            }
        }
    }

    private static String stepFive(List<String> expressions) {
        String expression = expressions.isEmpty() ? null : expressions.remove(0);
        return expression;
    }

    private static String stepFour(TreeItem node, List<String> expressions) {
        TreeItem item = node.getItem(0);
        item.setChecked(true);
        return expressions.remove(0);
    }

    private String stepThree(TreeItem node, List<String> expressions) {
        String expression = expressions.remove(0);
        TreeItem item = this.findAny(node, expression);
        if (Objects.nonNull(item)) {
            item.setChecked(true);
        }
        return expression;
    }

    private String stepTwo(TreeItem node, List<String> expressions) {
        String expression = expressions.remove(0);
        TreeItem item = this.findChild(node, expression);
        if (Objects.nonNull(item)) {
            item.setChecked(true);
        }
        return expression;
    }

    private static String stepOne(TreeItem node, List<String> expressions) {
        String expression = expressions.remove(0);
        if (".".equals(expression)) {
            node.setChecked(true);
        }
        return expression;
    }

    private List<String> getExpressions(String path) {
        Matcher matcher = Pattern.compile("\\w+|\\[[\\s\\S]*?]|\\$|\\.\\.|\\.").matcher(path);
        ArrayList<String> expressions = new ArrayList<String>();
        while (matcher.find()) {
            expressions.add(matcher.group());
        }
        return expressions;
    }

    private TreeItem findAny(TreeItem node, String value) {
        if (Objects.nonNull(node.getItems()) && node.getItems().length > 0) {
            for (int i = 0; i < node.getItems().length; ++i) {
                TreeItem found;
                if (value.equals(node.getItem(i).getData("Key"))) {
                    return node.getItem(i);
                }
                if (node.getItem(i).getItems().length <= 0 || !Objects.nonNull(found = this.findAny(node.getItem(i), value))) continue;
                return found;
            }
        }
        return null;
    }

    private TreeItem findChild(TreeItem node, String value) {
        if (Objects.nonNull(node.getItems()) && node.getItems().length > 0) {
            for (int i = 0; i < node.getItems().length; ++i) {
                if (!value.equals(node.getItem(i).getData("Key"))) continue;
                return node.getItem(i);
            }
        }
        return null;
    }

    public List<String> getChecked(Tree tree) {
        TreeItem[] topItems;
        ArrayList<String> checked = new ArrayList<String>();
        for (TreeItem item : topItems = tree.getItems()) {
            String path;
            if (item.getChecked() && StringUtils.isNotBlank((String)(path = this.getPath(item)))) {
                checked.add(path);
            }
            this.addChecked(checked, item);
        }
        return checked;
    }

    private void addChecked(List<String> checked, TreeItem treeItem) {
        TreeItem[] items;
        for (TreeItem item : items = treeItem.getItems()) {
            String path;
            if (item.getChecked() && StringUtils.isNotBlank((String)(path = this.getPath(item)))) {
                checked.add(path);
            }
            this.addChecked(checked, item);
        }
    }

    private String getPath(TreeItem item) {
        if (!this.hasCheckedChildren(item)) {
            String data = this.generatePath(item);
            Object key = item.getData("Key");
            if (Objects.isNull(key)) {
                key = Objects.nonNull(item.getParent()) ? item.getParent().getData("Key") : "root";
            }
            return key + ":" + data + ":" + item.getData("Type");
        }
        return null;
    }

    private String generatePath(TreeItem item) {
        StringBuilder path = new StringBuilder((String)this.getNodePath(item));
        TreeItem parent = item.getParentItem();
        while (Objects.nonNull(parent)) {
            if (parent.getChecked()) {
                path.insert(0, this.getNodePath(parent));
            }
            parent = parent.getParentItem();
        }
        return "$" + path;
    }

    private Object getNodePath(TreeItem item) {
        Object key = item.getData("Key");
        key = Objects.isNull(key) ? (Objects.nonNull(item.getParentItem()) && item.getParentItem().getText().contains("[") ? (item.getParentItem().getChecked() ? "[*]" : "..[*]") : "") : (Objects.nonNull(item.getParentItem()) && item.getParentItem().getChecked() ? "." + key : ".." + key);
        return key;
    }

    private boolean hasCheckedChildren(TreeItem item) {
        if (Objects.nonNull(item.getItems()) && item.getItems().length > 0) {
            for (int i = 0; i < item.getItems().length; ++i) {
                TreeItem child = item.getItems()[i];
                if (child.getChecked()) {
                    return true;
                }
                if (!Objects.nonNull(child.getItems()) || child.getItems().length <= 0 || !this.hasCheckedChildren(child)) continue;
                return true;
            }
        }
        return false;
    }
}

