/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model;

import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metaverse.api.model.DbcResourceInfo;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class JdbcResourceInfo
extends DbcResourceInfo
implements IExternalResourceInfo {
    public static final String JDBC = "JDBC";

    public JdbcResourceInfo() {
    }

    @Override
    public String getType() {
        return JDBC;
    }

    public JdbcResourceInfo(DatabaseMeta databaseMeta) {
        super(databaseMeta);
        if ("Native".equals(databaseMeta.getAccessTypeDesc())) {
            this.setServer(databaseMeta.environmentSubstitute(databaseMeta.getHostname()));
            String portString = databaseMeta.environmentSubstitute(databaseMeta.getDatabasePortNumberString());
            if (portString != null) {
                try {
                    this.setPort(Integer.valueOf(portString));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        } else {
            throw new IllegalArgumentException("DatabaseMeta is not JDBC, it is " + databaseMeta.getAccessTypeDesc());
        }
        this.setUsername(databaseMeta.environmentSubstitute(databaseMeta.getUsername()));
        this.setPassword(databaseMeta.environmentSubstitute(databaseMeta.getPassword()));
        this.setDatabaseName(databaseMeta.environmentSubstitute(databaseMeta.getDatabaseName()));
    }

    public JdbcResourceInfo(String server, String databaseName, Integer port, String username, String password) {
        this.server = server;
        this.databaseName = databaseName;
        this.port = port;
        this.username = username;
        this.password = password;
    }
}

