/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.metaverse.api.model.BaseDatabaseResourceInfo;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public abstract class DbcResourceInfo
extends BaseDatabaseResourceInfo
implements IExternalResourceInfo {
    public static final String JSON_PROPERTY_PORT = "port";
    public static final String JSON_PROPERTY_SERVER = "server";
    public static final String JSON_PROPERTY_USERNAME = "username";
    public static final String JSON_PROPERTY_PASSWORD = "password";
    public static final String JSON_PROPERTY_DATABASE_NAME = "databaseName";
    protected Integer port;
    protected String server;
    protected String username;
    protected String password;
    protected String databaseName;

    protected DbcResourceInfo() {
    }

    protected DbcResourceInfo(DatabaseMeta databaseMeta) {
        super(databaseMeta);
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonProperty(value="server")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)password);
    }

    @JsonProperty(value="password")
    protected String getEncryptedPassword() {
        return "Encrypted " + Encr.encryptPassword((String)this.password);
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public void cleanupSensitiveData() {
        this.password = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DbcResourceInfo that = (DbcResourceInfo)o;
        return Objects.equals(this.port, that.port) && Objects.equals(this.server, that.server) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.databaseName, that.databaseName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.port, this.server, this.username, this.password, this.databaseName);
    }
}

