/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.mongodbinput.models;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.di.ui.trans.steps.mongodbinput.MongoDbInputDialog;
import org.pentaho.di.ui.trans.steps.mongodbinput.models.MongoDocumentField;
import org.pentaho.di.ui.trans.steps.mongodbinput.models.MongoTag;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.NamedReadPreference;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.MongoWrapperUtil;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractModelList;

public class MongoDbModel
extends XulEventSourceAdapter {
    private String hostname;
    private String port;
    private String dbName;
    private Vector<String> dbNames = new Vector();
    private String collection;
    private Vector<String> collections = new Vector();
    private String fieldsQuery;
    private String authenticationDatabaseName;
    private String authenticationUser;
    private String authenticationPassword;
    private String jsonQuery;
    private boolean m_aggPipeline = false;
    private boolean m_useAllReplicaSetMembers = false;
    private String m_connectTimeout = "";
    private String m_socketTimeout = "";
    private boolean m_kerberos = false;
    private String m_readPreference = NamedReadPreference.PRIMARY.getName();
    private static final String AUTO_GENERATED_PARAMETER = "AUTO.GENERATED.PARAMETER";
    private AbstractModelList<MongoDocumentField> fields = new AbstractModelList();
    private AbstractModelList<MongoTag> tags = new AbstractModelList();
    private MongoDbInputMeta mongo;
    private LogChannel log;

    public MongoDbModel(MongoDbInputMeta mongo) {
        this.mongo = mongo;
        this.log = new LogChannel((Object)this.mongo);
        this.initialize(this.mongo);
    }

    public boolean validate() {
        boolean valid = false;
        valid = !StringUtil.isEmpty((String)this.hostname) && !StringUtil.isEmpty((String)this.dbName) && !StringUtil.isEmpty((String)this.collection) && this.fields.size() > 0;
        this.firePropertyChange("validate", null, valid);
        return valid;
    }

    public String getHostnames() {
        return this.hostname;
    }

    public void setHostnames(String hostname) {
        String prevVal = this.hostname;
        this.hostname = hostname;
        this.firePropertyChange("hostnames", prevVal, hostname);
        this.validate();
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        String prevVal = this.port;
        this.port = port;
        this.firePropertyChange("port", prevVal, port);
        this.validate();
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        String prevVal = this.dbName;
        this.dbName = dbName;
        this.firePropertyChange("database", prevVal, dbName == null ? "" : dbName);
    }

    public Collection<String> getDbNames() {
        return this.dbNames;
    }

    public void setDbNames(Vector<String> dbs) {
        Vector<String> prevVal = this.dbNames;
        this.dbNames = dbs;
        if (!Const.isEmpty((String)this.dbName) && !this.dbNames.contains(this.dbName)) {
            this.dbNames.add(this.dbName);
        }
        this.firePropertyChange("database", prevVal, dbs);
    }

    public String getFieldsName() {
        return this.fieldsQuery;
    }

    public void setFieldsName(String fields) {
        String prevVal = this.fieldsQuery;
        this.fieldsQuery = fields;
        this.firePropertyChange("fieldsQuery", prevVal, fields);
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        String prevVal = this.collection;
        this.collection = collection;
        this.firePropertyChange("collection", prevVal, collection == null ? "" : collection);
    }

    public Collection<String> getCollections() {
        return this.collections;
    }

    public void setCollections(Vector<String> collections) {
        Vector<String> prevVal = this.collections;
        this.collections = collections;
        if (!Const.isEmpty((String)this.collection) && !collections.contains(this.collection)) {
            collections.add(this.collection);
        }
        this.firePropertyChange("collection", prevVal, collections);
    }

    public String getAuthenticationDatabaseName() {
        return this.authenticationDatabaseName;
    }

    public void setAuthenticationDatabaseName(String authenticationDatabaseName) {
        String prevVal = this.authenticationDatabaseName;
        this.authenticationDatabaseName = authenticationDatabaseName;
        this.firePropertyChange("authenticationDatabaseName", prevVal, authenticationDatabaseName);
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        String prevVal = this.authenticationUser;
        this.authenticationUser = authenticationUser;
        this.firePropertyChange("authenticationUser", prevVal, authenticationUser);
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        String prevVal = this.authenticationPassword;
        this.authenticationPassword = authenticationPassword;
        this.firePropertyChange("authenticationPassword", prevVal, authenticationPassword);
    }

    public String getJsonQuery() {
        return this.jsonQuery;
    }

    @Bindable
    public void setJsonQuery(String jsonQuery) {
        String prevVal = this.jsonQuery;
        this.jsonQuery = jsonQuery;
        this.firePropertyChange("jsonQuery", prevVal, jsonQuery);
    }

    public void setQueryIsPipeline(boolean q) {
        Boolean prevVal = new Boolean(this.m_aggPipeline);
        this.m_aggPipeline = q;
        this.firePropertyChange("m_aggPipeline", prevVal, new Boolean(q));
    }

    public boolean getQueryIsPipeline() {
        return this.m_aggPipeline;
    }

    public void setUseAllReplicaMembers(boolean u) {
        Boolean prevVal = new Boolean(this.m_useAllReplicaSetMembers);
        this.m_useAllReplicaSetMembers = u;
        this.firePropertyChange("m_useAllReplicaSetMembers", prevVal, new Boolean(u));
    }

    public void setUseKerberosAuthentication(boolean k) {
        Boolean prevVal = new Boolean(this.m_kerberos);
        this.m_kerberos = k;
        this.firePropertyChange("m_kerberos", prevVal, new Boolean(k));
    }

    public boolean getUseKerberosAuthentication() {
        return this.m_kerberos;
    }

    public boolean getUseAllReplicaMembers() {
        return this.m_useAllReplicaSetMembers;
    }

    public void setConnectTimeout(String to) {
        String prevVal = this.m_connectTimeout;
        this.m_connectTimeout = to;
        this.firePropertyChange("connectTimeout", prevVal, to);
    }

    public String getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setSocketTimeout(String so) {
        String prevVal = this.m_socketTimeout;
        this.m_socketTimeout = so;
        this.firePropertyChange("socketTimeout", prevVal, so);
    }

    public String getSocketTimeout() {
        return this.m_socketTimeout;
    }

    public void setReadPreference(String preference) {
        String prevVal = this.m_readPreference;
        this.m_readPreference = Const.isEmpty((String)preference) ? NamedReadPreference.PRIMARY.getName() : preference;
        this.firePropertyChange("readPreference", prevVal, preference);
    }

    public String getReadPreference() {
        return this.m_readPreference;
    }

    public AbstractModelList<MongoDocumentField> getFields() {
        return this.fields;
    }

    public void save() {
        this.saveMeta(this.mongo);
        ArrayList variablesUsed = new ArrayList();
        StringUtil.getUsedVariables((String)this.mongo.getJsonQuery(), variablesUsed, (boolean)true);
        TransMeta trans = this.mongo.getParentStepMeta().getParentTransMeta();
        for (String variable : variablesUsed) {
            try {
                trans.addParameterDefinition(StringUtil.getVariableName((String)variable), "", AUTO_GENERATED_PARAMETER);
            }
            catch (DuplicateParamException e) {
                this.log.logBasic("Failed attempt to add duplicate variable ".concat(variable));
            }
        }
        String[] parametersAdded = trans.listParameters();
        NamedParamsDefault params = new NamedParamsDefault();
        String description = null;
        for (String parameter : parametersAdded) {
            try {
                description = trans.getParameterDescription(parameter);
                if (description.equalsIgnoreCase(AUTO_GENERATED_PARAMETER)) {
                    if (!variablesUsed.contains(parameter)) continue;
                    params.addParameterDefinition(parameter, trans.getParameterDefault(parameter), description);
                    continue;
                }
                params.addParameterDefinition(parameter, trans.getParameterDefault(parameter), description);
            }
            catch (Exception e) {
                this.log.logError("Can not locate parameter " + parameter + ".", (Throwable)e);
            }
        }
        trans.eraseParameters();
        for (String key : params.listParameters()) {
            try {
                trans.addParameterDefinition(key, params.getParameterDefault(key), params.getParameterDescription(key));
            }
            catch (Exception e) {
                this.log.logError("Cannot add parameter " + key + ".", (Throwable)e);
            }
        }
        trans.activateParameters();
    }

    public void saveMeta(MongoDbInputMeta meta) {
        meta.setOutputJson(false);
        meta.setJsonQuery(this.jsonQuery);
        meta.setAuthenticationDatabaseName(this.authenticationDatabaseName);
        meta.setAuthenticationPassword(this.authenticationPassword);
        meta.setAuthenticationUser(this.authenticationUser);
        meta.setCollection(this.collection);
        meta.setConnectTimeout(this.m_connectTimeout);
        meta.setDbName(this.dbName);
        meta.setFieldsName(this.fieldsQuery);
        meta.setHostnames(this.hostname);
        meta.setPort(this.port);
        meta.setQueryIsPipeline(this.m_aggPipeline);
        meta.setReadPreference(this.m_readPreference);
        meta.setSocketTimeout(this.m_socketTimeout);
        meta.setMongoFields(MongoDocumentField.convertFromList(this.getFields()));
        meta.setUseKerberosAuthentication(this.m_kerberos);
        meta.setUseAllReplicaSetMembers(this.m_useAllReplicaSetMembers);
        meta.setReadPrefTagSets(MongoTag.convertFromList(this.tags));
    }

    private void initialize(MongoDbInputMeta m) {
        this.setJsonQuery(m.getJsonQuery());
        this.setAuthenticationDatabaseName(m.getAuthenticationDatabaseName());
        this.setAuthenticationPassword(m.getAuthenticationPassword());
        this.setAuthenticationUser(m.getAuthenticationUser());
        this.setCollection(m.getCollection());
        this.setCollections(new Vector<String>());
        this.setDbName(m.getDbName());
        this.setDbNames(new Vector<String>());
        this.setFieldsName(m.getFieldsName());
        this.setHostnames(m.getHostnames());
        this.setPort(m.getPort());
        this.setQueryIsPipeline(m.getQueryIsPipeline());
        this.setReadPreference(m.getReadPreference());
        this.setConnectTimeout(m.getConnectTimeout());
        this.setSocketTimeout(m.getSocketTimeout());
        MongoDocumentField.convertList(m.getMongoFields(), this.getFields());
        this.setUseAllReplicaMembers(m.getUseAllReplicaSetMembers());
        this.setUseKerberosAuthentication(m.getUseKerberosAuthentication());
        MongoTag.convertList(m.getReadPrefTagSets(), this.getTags());
    }

    public AbstractModelList<MongoTag> getTags() {
        return this.tags;
    }

    public void clear() {
        MongoDbInputMeta m = new MongoDbInputMeta();
        m.setReadPreference(NamedReadPreference.PRIMARY.getName());
        this.initialize(m);
    }

    public Collection<String> getPossibleReadPreferences() {
        return NamedReadPreference.getPreferenceNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getDatabaseNamesFromMongo() throws Exception {
        Vector<String> dbs = new Vector<String>();
        if (Const.isEmpty((String)this.hostname)) {
            this.log.logBasic("Fetching database names aborted. Missing hostname.");
            return dbs;
        }
        MongoDbInputMeta meta = new MongoDbInputMeta();
        TransMeta transMeta = new TransMeta();
        this.saveMeta(meta);
        try {
            MongoClientWrapper wrapper = MongoWrapperUtil.createMongoClientWrapper(meta, (VariableSpace)transMeta, (LogChannelInterface)this.log);
            List dbNames = null;
            try {
                dbNames = wrapper.getDatabaseNames();
            }
            finally {
                wrapper.dispose();
            }
            for (String s : dbNames) {
                dbs.add(s);
            }
            return dbs;
        }
        catch (Exception e) {
            this.log.logError("Unexpected error retrieving database names from MongoDb. Check your connection details.", new Object[]{meta});
            throw new MongoDbException("Unexpected error retrieving database names from MongoDb. Check your connection details.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getCollectionNamesFromMongo() throws MongoDbException {
        Vector<String> newCollections = new Vector<String>();
        if (Const.isEmpty((String)this.dbName) || Const.isEmpty((String)this.hostname)) {
            this.log.logBasic("Fetching collection names aborted. Missing database name or hostname.");
            return newCollections;
        }
        MongoDbInputMeta meta = new MongoDbInputMeta();
        this.saveMeta(meta);
        try {
            MongoClientWrapper wrapper = MongoWrapperUtil.createMongoClientWrapper(meta, (VariableSpace)new TransMeta(), (LogChannelInterface)this.log);
            Set collections = new HashSet();
            try {
                collections = wrapper.getCollectionsNames(this.dbName);
            }
            finally {
                wrapper.dispose();
            }
            for (String c : collections) {
                newCollections.add(c);
            }
            return newCollections;
        }
        catch (Exception e) {
            this.log.logError("Unexpected error retrieving collection names from MongoDb. Check that your database name is valid.", new Object[]{meta});
            throw new MongoDbException("Unexpected error retrieving collection names from MongoDb. Check that your database name is valid.", (Throwable)e);
        }
    }

    public void getFieldsFromMongo(int mergeStrategy) throws MongoDbException {
        int samples = 100;
        MongoDbInputMeta meta = new MongoDbInputMeta();
        if (samples > 0) {
            try {
                this.saveMeta(meta);
                boolean result = MongoDbInputDialog.discoverFields(meta, (VariableSpace)new TransMeta(), samples);
                if (!result) {
                    this.log.logBasic("No fields were returned from MongoDb. Check your query, and/or connection details.");
                    throw new MongoDbException("No fields were returned from MongoDb. Check your query, and/or connection details.");
                }
                switch (mergeStrategy) {
                    case 0: {
                        MongoDocumentField.trimList(meta.getMongoFields(), this.getFields());
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.getFields().removeAll(this.getFields());
                    }
                }
                MongoDocumentField.convertList(meta.getMongoFields(), this.getFields());
            }
            catch (KettleException e) {
                this.log.logError("Unexpected error retrieving fields from MongoDb. Check your connection details.", new Object[]{meta});
                throw new MongoDbException("Unexpected error retrieving fields from MongoDb. Check your connection details.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTagsFromMongo(int mergeStrategy) throws MongoDbException {
        if (Const.isEmpty((String)this.hostname)) {
            this.log.logBasic("Fetching tags aborted. Missing hostname.");
            return;
        }
        MongoDbInputMeta meta = new MongoDbInputMeta();
        this.saveMeta(meta);
        try {
            ArrayList<String> repSetTags = new ArrayList();
            MongoClientWrapper wrapper = MongoWrapperUtil.createMongoClientWrapper(meta, (VariableSpace)new TransMeta(), (LogChannelInterface)this.log);
            try {
                repSetTags = wrapper.getAllTags();
            }
            finally {
                wrapper.dispose();
            }
            switch (mergeStrategy) {
                case 0: {
                    MongoTag.trimList(repSetTags, this.getTags());
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.getTags().removeAll(this.getTags());
                }
            }
            MongoTag.convertList(repSetTags, this.getTags());
        }
        catch (Exception e) {
            this.log.logError("Unexpected error retrieving tags from MongoDb. Check connection details.", (Throwable)e);
            throw new MongoDbException("Unexpected error retrieving tags from MongoDb. Check your connection details.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> testSelectedTags() throws MongoDbException {
        ArrayList<String> tagSets = null;
        if (Const.isEmpty((String)this.hostname)) {
            this.log.logBasic("Testing tags aborted. Missing hostname.");
            return tagSets;
        }
        if (this.tags.isEmpty()) {
            this.log.logBasic("No tags available for testing.");
            return tagSets;
        }
        ArrayList<DBObject> mongoTagSets = new ArrayList<DBObject>();
        List<String> setsToTest = MongoTag.convertFromList(this.tags);
        for (String tagSet : setsToTest) {
            try {
                DBObject set = (DBObject)JSON.parse((String)tagSet);
                if (set == null) continue;
                mongoTagSets.add(set);
            }
            catch (Exception e) {
                this.log.logError("Error parsing MongoDb tag sets.", (Throwable)e);
                throw new MongoDbException("Error parsing MongoDb tag sets. Check your tag set names and try again.", (Throwable)e);
            }
        }
        if (mongoTagSets.isEmpty()) {
            this.log.logBasic("Could not parse tags for testing.");
            return tagSets;
        }
        MongoDbInputMeta meta = new MongoDbInputMeta();
        this.saveMeta(meta);
        try {
            MongoClientWrapper wrapper = MongoWrapperUtil.createMongoClientWrapper(meta, (VariableSpace)new TransMeta(), (LogChannelInterface)this.log);
            List result = new ArrayList();
            try {
                result = wrapper.getReplicaSetMembersThatSatisfyTagSets(mongoTagSets);
            }
            finally {
                wrapper.dispose();
            }
            if (result.size() == 0) {
                this.log.logBasic("No replica set members match tag sets.");
                return tagSets;
            }
            tagSets = new ArrayList<String>();
            for (String dbObject : result) {
                tagSets.add(dbObject);
            }
        }
        catch (Exception e) {
            this.log.logError("Unexpected error evaluating tag sets against replica members.", (Throwable)e);
            throw new MongoDbException("Unexpected error evaluating tag sets against replica members.", (Throwable)e);
        }
        return tagSets;
    }
}

