/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodboutput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutput;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputData;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputDialog;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="MongoDbOutput", image="MongoDB.svg", name="MongoDB output", description="Writes to a Mongo DB collection", documentationUrl="Products/MongoDB_Output", categoryDescription="Big Data")
@InjectionSupported(localizationPrefix="MongoDbOutput.Injection.", groups={"FIELDS", "INDEXES"})
public class MongoDbOutputMeta
extends MongoDbMeta
implements StepMetaInterface {
    private static Class<?> PKG = MongoDbOutputMeta.class;
    @Injection(name="TRUNCATE")
    protected boolean m_truncate;
    @Injection(name="UPDATE")
    protected boolean m_update;
    @Injection(name="UPSERT")
    protected boolean m_upsert;
    @Injection(name="MULTI")
    protected boolean m_multi;
    @Injection(name="MODIFIER_UPDATE")
    protected boolean m_modifierUpdate;
    @Injection(name="BATCH_INSERT_SIZE")
    protected String m_batchInsertSize = "100";
    @InjectionDeep
    protected List<MongoField> m_mongoFields;
    @InjectionDeep
    protected List<MongoIndex> m_mongoIndexes;
    public static final int RETRIES = 5;
    public static final int RETRY_DELAY = 10;
    @Injection(name="RETRY_NUMBER")
    private String m_writeRetries = "5";
    @Injection(name="RETRY_DELAY")
    private String m_writeRetryDelay = "10";

    public void setDefault() {
        this.setHostnames("localhost");
        this.setPort("27017");
        this.setCollection("");
        this.setDbName("");
        this.setAuthenticationMechanism("");
        this.setUseConnectionString(true);
        this.m_upsert = false;
        this.m_modifierUpdate = false;
        this.m_truncate = false;
        this.m_batchInsertSize = "100";
        this.setWriteConcern("");
        this.setWTimeout("");
        this.setJournal(false);
    }

    public void setMongoFields(List<MongoField> mongoFields) {
        this.m_mongoFields = mongoFields;
    }

    public List<MongoField> getMongoFields() {
        return this.m_mongoFields;
    }

    public void setMongoIndexes(List<MongoIndex> mongoIndexes) {
        this.m_mongoIndexes = mongoIndexes;
    }

    public List<MongoIndex> getMongoIndexes() {
        return this.m_mongoIndexes;
    }

    public void setWriteRetries(String r) {
        this.m_writeRetries = r;
    }

    public String getWriteRetries() {
        return this.m_writeRetries;
    }

    public void setWriteRetryDelay(String d) {
        this.m_writeRetryDelay = d;
    }

    public String getWriteRetryDelay() {
        return this.m_writeRetryDelay;
    }

    public void setUpdate(boolean update) {
        this.m_update = update;
    }

    public boolean getUpdate() {
        return this.m_update;
    }

    public void setUpsert(boolean upsert) {
        this.m_upsert = upsert;
    }

    public boolean getUpsert() {
        return this.m_upsert;
    }

    public void setMulti(boolean multi) {
        this.m_multi = multi;
    }

    public boolean getMulti() {
        return this.m_multi;
    }

    public void setModifierUpdate(boolean u) {
        this.m_modifierUpdate = u;
    }

    public boolean getModifierUpdate() {
        return this.m_modifierUpdate;
    }

    public void setTruncate(boolean truncate) {
        this.m_truncate = truncate;
    }

    public boolean getTruncate() {
        return this.m_truncate;
    }

    public String getBatchInsertSize() {
        return this.m_batchInsertSize;
    }

    public void setBatchInsertSize(String size) {
        this.m_batchInsertSize = size;
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NotReceivingFieldsFromPreviousSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ReceivingFields", (Object[])new Object[]{prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ReceivingInfo", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new MongoDbOutput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new MongoDbOutputData();
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_connection_string", (boolean)this.isUseConnectionString()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_legacy_options", (boolean)this.isUseLegacyOptions()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection_string", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getConnectionString())));
        if (!Const.isEmpty((String)this.getHostnames())) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_host", (String)this.getHostnames()));
        }
        if (!Const.isEmpty((String)this.getPort())) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_port", (String)this.getPort()));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_all_replica_members", (boolean)this.getUseAllReplicaSetMembers()));
        if (!Const.isEmpty((String)this.getAuthenticationDatabaseName())) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_auth_database", (String)this.getAuthenticationDatabaseName()));
        }
        if (!Const.isEmpty((String)this.getAuthenticationUser())) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_user", (String)this.getAuthenticationUser()));
        }
        if (!Const.isEmpty((String)this.getAuthenticationPassword())) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getAuthenticationPassword())));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_mech", (String)this.getAuthenticationMechanism()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_kerberos", (boolean)this.getUseKerberosAuthentication()));
        if (!Const.isEmpty((String)this.getDbName())) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_db", (String)this.getDbName()));
        }
        if (!Const.isEmpty((String)this.getCollection())) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_collection", (String)this.getCollection()));
        }
        if (!Const.isEmpty((String)this.m_batchInsertSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"batch_insert_size", (String)this.m_batchInsertSize));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"connect_timeout", (String)this.getConnectTimeout()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"socket_timeout", (String)this.getSocketTimeout()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_ssl_socket_factory", (boolean)this.isUseSSLSocketFactory()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_preference", (String)this.getReadPreference()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"write_concern", (String)this.getWriteConcern()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"w_timeout", (String)this.getWTimeout()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"journaled_writes", (boolean)this.getJournal()));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"truncate", (boolean)this.m_truncate));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"update", (boolean)this.m_update));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"upsert", (boolean)this.m_upsert));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"multi", (boolean)this.m_multi));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"modifier_update", (boolean)this.m_modifierUpdate));
        retval.append("    ").append(XMLHandler.addTagValue((String)"write_retries", (String)this.m_writeRetries));
        retval.append("    ").append(XMLHandler.addTagValue((String)"write_retry_delay", (String)this.m_writeRetryDelay));
        if (this.m_mongoFields != null && this.m_mongoFields.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"mongo_fields"));
            for (MongoField field : this.m_mongoFields) {
                retval.append("\n      ").append(XMLHandler.openTag((String)"mongo_field"));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"incoming_field_name", (String)field.m_incomingFieldName));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"mongo_doc_path", (String)field.m_mongoDocPath));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"use_incoming_field_name_as_mongo_field_name", (boolean)field.m_useIncomingFieldNameAsMongoFieldName));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"update_match_field", (boolean)field.m_updateMatchField));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"modifier_update_operation", (String)field.m_modifierUpdateOperation));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"modifier_policy", (String)field.m_modifierOperationApplyPolicy));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"json_field", (boolean)field.m_JSON));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"allow_null", (boolean)field.insertNull));
                retval.append("\n      ").append(XMLHandler.closeTag((String)"mongo_field"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"mongo_fields"));
        }
        if (this.m_mongoIndexes != null && this.m_mongoIndexes.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"mongo_indexes"));
            for (MongoIndex index : this.m_mongoIndexes) {
                retval.append("\n      ").append(XMLHandler.openTag((String)"mongo_index"));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"path_to_fields", (String)index.m_pathToFields));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"drop", (boolean)index.m_drop));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"unique", (boolean)index.m_unique));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"sparse", (boolean)index.m_sparse));
                retval.append("\n      ").append(XMLHandler.closeTag((String)"mongo_index"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"mongo_indexes"));
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        Node fieldNode;
        int i;
        int nrfields;
        Node fields;
        String writeRetryDelay;
        String useConnectionString = XMLHandler.getTagValue((Node)stepnode, (String)"use_connection_string");
        String useLegacyOptions = XMLHandler.getTagValue((Node)stepnode, (String)"use_legacy_options");
        if (!Utils.isEmpty((CharSequence)useConnectionString) && useConnectionString.equalsIgnoreCase("Y")) {
            this.setUseConnectionString(true);
        } else if (!Utils.isEmpty((CharSequence)useLegacyOptions) && useLegacyOptions.equalsIgnoreCase("Y")) {
            this.setUseLegacyOptions(true);
        } else {
            this.setUseLegacyOptions(true);
        }
        this.setConnectionString(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"connection_string")));
        this.setHostnames(XMLHandler.getTagValue((Node)stepnode, (String)"mongo_host"));
        this.setPort(XMLHandler.getTagValue((Node)stepnode, (String)"mongo_port"));
        this.setAuthenticationDatabaseName(XMLHandler.getTagValue((Node)stepnode, (String)"mongo_auth_database"));
        this.setAuthenticationUser(XMLHandler.getTagValue((Node)stepnode, (String)"mongo_user"));
        this.setAuthenticationPassword(XMLHandler.getTagValue((Node)stepnode, (String)"mongo_password"));
        if (!Const.isEmpty((String)this.getAuthenticationPassword())) {
            this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)this.getAuthenticationPassword()));
        }
        this.setAuthenticationMechanism(XMLHandler.getTagValue((Node)stepnode, (String)"auth_mech"));
        this.setUseKerberosAuthentication("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"auth_kerberos")));
        this.setDbName(XMLHandler.getTagValue((Node)stepnode, (String)"mongo_db"));
        this.setCollection(XMLHandler.getTagValue((Node)stepnode, (String)"mongo_collection"));
        this.m_batchInsertSize = XMLHandler.getTagValue((Node)stepnode, (String)"batch_insert_size");
        this.setConnectTimeout(XMLHandler.getTagValue((Node)stepnode, (String)"connect_timeout"));
        this.setSocketTimeout(XMLHandler.getTagValue((Node)stepnode, (String)"socket_timeout"));
        String useSSLSocketFactory = XMLHandler.getTagValue((Node)stepnode, (String)"use_ssl_socket_factory");
        if (!Utils.isEmpty((CharSequence)useSSLSocketFactory)) {
            this.setUseSSLSocketFactory(useSSLSocketFactory.equalsIgnoreCase("Y"));
        }
        this.setReadPreference(XMLHandler.getTagValue((Node)stepnode, (String)"read_preference"));
        this.setWriteConcern(XMLHandler.getTagValue((Node)stepnode, (String)"write_concern"));
        this.setWTimeout(XMLHandler.getTagValue((Node)stepnode, (String)"w_timeout"));
        String journaled = XMLHandler.getTagValue((Node)stepnode, (String)"journaled_writes");
        if (!Const.isEmpty((String)journaled)) {
            this.setJournal(journaled.equalsIgnoreCase("Y"));
        }
        this.m_truncate = XMLHandler.getTagValue((Node)stepnode, (String)"truncate").equalsIgnoreCase("Y");
        String update = XMLHandler.getTagValue((Node)stepnode, (String)"update");
        if (!Const.isEmpty((String)update)) {
            this.m_update = update.equalsIgnoreCase("Y");
        }
        this.m_upsert = XMLHandler.getTagValue((Node)stepnode, (String)"upsert").equalsIgnoreCase("Y");
        this.m_multi = XMLHandler.getTagValue((Node)stepnode, (String)"multi").equalsIgnoreCase("Y");
        this.m_modifierUpdate = XMLHandler.getTagValue((Node)stepnode, (String)"modifier_update").equalsIgnoreCase("Y");
        if (this.m_upsert || this.m_multi) {
            this.m_update = true;
        }
        this.setUseAllReplicaSetMembers("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_all_replica_members")));
        String writeRetries = XMLHandler.getTagValue((Node)stepnode, (String)"write_retries");
        if (!Const.isEmpty((String)writeRetries)) {
            this.m_writeRetries = writeRetries;
        }
        if (!Const.isEmpty((String)(writeRetryDelay = XMLHandler.getTagValue((Node)stepnode, (String)"write_retry_delay")))) {
            this.m_writeRetryDelay = writeRetryDelay;
        }
        if ((fields = XMLHandler.getSubNode((Node)stepnode, (String)"mongo_fields")) != null && XMLHandler.countNodes((Node)fields, (String)"mongo_field") > 0) {
            nrfields = XMLHandler.countNodes((Node)fields, (String)"mongo_field");
            this.m_mongoFields = new ArrayList<MongoField>();
            for (i = 0; i < nrfields; ++i) {
                String jsonField;
                fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"mongo_field", (int)i);
                MongoField newField = new MongoField();
                newField.m_incomingFieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"incoming_field_name");
                newField.m_mongoDocPath = XMLHandler.getTagValue((Node)fieldNode, (String)"mongo_doc_path");
                newField.m_useIncomingFieldNameAsMongoFieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"use_incoming_field_name_as_mongo_field_name").equalsIgnoreCase("Y");
                newField.m_updateMatchField = XMLHandler.getTagValue((Node)fieldNode, (String)"update_match_field").equalsIgnoreCase("Y");
                newField.m_modifierUpdateOperation = XMLHandler.getTagValue((Node)fieldNode, (String)"modifier_update_operation");
                String policy = XMLHandler.getTagValue((Node)fieldNode, (String)"modifier_policy");
                if (!Const.isEmpty((String)policy)) {
                    newField.m_modifierOperationApplyPolicy = policy;
                }
                if (!Const.isEmpty((String)(jsonField = XMLHandler.getTagValue((Node)fieldNode, (String)"json_field")))) {
                    newField.m_JSON = jsonField.equalsIgnoreCase("Y");
                }
                String allowNull = XMLHandler.getTagValue((Node)fieldNode, (String)"allow_null");
                newField.insertNull = "Y".equalsIgnoreCase(allowNull);
                this.m_mongoFields.add(newField);
            }
        }
        if ((fields = XMLHandler.getSubNode((Node)stepnode, (String)"mongo_indexes")) != null && XMLHandler.countNodes((Node)fields, (String)"mongo_index") > 0) {
            nrfields = XMLHandler.countNodes((Node)fields, (String)"mongo_index");
            this.m_mongoIndexes = new ArrayList<MongoIndex>();
            for (i = 0; i < nrfields; ++i) {
                fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"mongo_index", (int)i);
                MongoIndex newIndex = new MongoIndex();
                newIndex.m_pathToFields = XMLHandler.getTagValue((Node)fieldNode, (String)"path_to_fields");
                newIndex.m_drop = XMLHandler.getTagValue((Node)fieldNode, (String)"drop").equalsIgnoreCase("Y");
                newIndex.m_unique = XMLHandler.getTagValue((Node)fieldNode, (String)"unique").equalsIgnoreCase("Y");
                newIndex.m_sparse = XMLHandler.getTagValue((Node)fieldNode, (String)"sparse").equalsIgnoreCase("Y");
                this.m_mongoIndexes.add(newIndex);
            }
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        int i;
        String writeRetryDelay;
        this.setUseConnectionString(rep.getStepAttributeBoolean(id_step, 0, "use_connection_string"));
        this.setUseLegacyOptions(rep.getStepAttributeBoolean(id_step, 0, "use_legacy_options"));
        this.setConnectionString(Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "connection_string")));
        this.setHostnames(rep.getStepAttributeString(id_step, 0, "mongo_host"));
        this.setPort(rep.getStepAttributeString(id_step, 0, "mongo_port"));
        this.setUseAllReplicaSetMembers(rep.getStepAttributeBoolean(id_step, 0, "use_all_replica_members"));
        this.setAuthenticationDatabaseName(rep.getStepAttributeString(id_step, 0, "mongo_auth_database"));
        this.setAuthenticationUser(rep.getStepAttributeString(id_step, 0, "mongo_user"));
        this.setAuthenticationPassword(rep.getStepAttributeString(id_step, 0, "mongo_password"));
        if (!Const.isEmpty((String)this.getAuthenticationPassword())) {
            this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)this.getAuthenticationPassword()));
        }
        this.setAuthenticationMechanism(rep.getStepAttributeString(id_step, "auth_mech"));
        this.setUseKerberosAuthentication(rep.getStepAttributeBoolean(id_step, "auth_kerberos"));
        this.setDbName(rep.getStepAttributeString(id_step, 0, "mongo_db"));
        this.setCollection(rep.getStepAttributeString(id_step, 0, "mongo_collection"));
        this.m_batchInsertSize = rep.getStepAttributeString(id_step, 0, "batch_insert_size");
        this.setConnectTimeout(rep.getStepAttributeString(id_step, "connect_timeout"));
        this.setSocketTimeout(rep.getStepAttributeString(id_step, "socket_timeout"));
        this.setUseSSLSocketFactory(rep.getStepAttributeBoolean(id_step, 0, "use_ssl_socket_factory", false));
        this.setReadPreference(rep.getStepAttributeString(id_step, "read_preference"));
        this.setWriteConcern(rep.getStepAttributeString(id_step, "write_concern"));
        this.setWTimeout(rep.getStepAttributeString(id_step, "w_timeout"));
        this.setJournal(rep.getStepAttributeBoolean(id_step, 0, "journaled_writes"));
        this.m_truncate = rep.getStepAttributeBoolean(id_step, 0, "truncate");
        this.m_update = rep.getStepAttributeBoolean(id_step, 0, "update");
        this.m_upsert = rep.getStepAttributeBoolean(id_step, 0, "upsert");
        this.m_multi = rep.getStepAttributeBoolean(id_step, 0, "multi");
        this.m_modifierUpdate = rep.getStepAttributeBoolean(id_step, 0, "modifier_update");
        if (this.m_upsert || this.m_multi) {
            this.m_update = true;
        }
        int nrfields = rep.countNrStepAttributes(id_step, "incoming_field_name");
        String writeRetries = rep.getStepAttributeString(id_step, "write_retries");
        if (!Const.isEmpty((String)writeRetries)) {
            this.m_writeRetries = writeRetries;
        }
        if (!Const.isEmpty((String)(writeRetryDelay = rep.getStepAttributeString(id_step, "write_retry_delay")))) {
            this.m_writeRetryDelay = writeRetryDelay;
        }
        if (nrfields > 0) {
            this.m_mongoFields = new ArrayList<MongoField>();
            for (i = 0; i < nrfields; ++i) {
                MongoField newField = new MongoField();
                newField.m_incomingFieldName = rep.getStepAttributeString(id_step, i, "incoming_field_name");
                newField.m_mongoDocPath = rep.getStepAttributeString(id_step, i, "mongo_doc_path");
                newField.m_useIncomingFieldNameAsMongoFieldName = rep.getStepAttributeBoolean(id_step, i, "use_incoming_field_name_as_mongo_field_name");
                newField.m_updateMatchField = rep.getStepAttributeBoolean(id_step, i, "update_match_field");
                newField.m_modifierUpdateOperation = rep.getStepAttributeString(id_step, i, "modifier_update_operation");
                String policy = rep.getStepAttributeString(id_step, i, "modifier_policy");
                if (!Const.isEmpty((String)policy)) {
                    newField.m_modifierOperationApplyPolicy = policy;
                }
                newField.m_JSON = rep.getStepAttributeBoolean(id_step, i, "json_field");
                newField.insertNull = rep.getStepAttributeBoolean(id_step, i, "allow_null");
                this.m_mongoFields.add(newField);
            }
        }
        if ((nrfields = rep.countNrStepAttributes(id_step, "path_to_fields")) > 0) {
            this.m_mongoIndexes = new ArrayList<MongoIndex>();
            for (i = 0; i < nrfields; ++i) {
                MongoIndex newIndex = new MongoIndex();
                newIndex.m_pathToFields = rep.getStepAttributeString(id_step, i, "path_to_fields");
                newIndex.m_drop = rep.getStepAttributeBoolean(id_step, i, "drop");
                newIndex.m_unique = rep.getStepAttributeBoolean(id_step, i, "unique");
                newIndex.m_sparse = rep.getStepAttributeBoolean(id_step, i, "sparse");
                this.m_mongoIndexes.add(newIndex);
            }
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        int i;
        rep.saveStepAttribute(id_transformation, id_step, "use_connection_string", this.isUseConnectionString());
        rep.saveStepAttribute(id_transformation, id_step, "use_legacy_options", this.isUseLegacyOptions());
        rep.saveStepAttribute(id_transformation, id_step, "connection_string", Encr.encryptPasswordIfNotUsingVariables((String)this.getConnectionString()));
        if (!Const.isEmpty((String)this.getHostnames())) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_host", this.getHostnames());
        }
        if (!Const.isEmpty((String)this.getPort())) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_port", this.getPort());
        }
        rep.saveStepAttribute(id_transformation, id_step, "use_all_replica_members", this.getUseAllReplicaSetMembers());
        if (!Const.isEmpty((String)this.getAuthenticationDatabaseName())) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_auth_database", this.getAuthenticationDatabaseName());
        }
        if (!Const.isEmpty((String)this.getAuthenticationUser())) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_user", this.getAuthenticationUser());
        }
        if (!Const.isEmpty((String)this.getAuthenticationPassword())) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_password", Encr.encryptPasswordIfNotUsingVariables((String)this.getAuthenticationPassword()));
        }
        rep.saveStepAttribute(id_transformation, id_step, "auth_mech", this.getAuthenticationMechanism());
        rep.saveStepAttribute(id_transformation, id_step, "auth_kerberos", this.getUseKerberosAuthentication());
        if (!Const.isEmpty((String)this.getDbName())) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_db", this.getDbName());
        }
        if (!Const.isEmpty((String)this.getCollection())) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_collection", this.getCollection());
        }
        if (!Const.isEmpty((String)this.m_batchInsertSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "batch_insert_size", this.m_batchInsertSize);
        }
        rep.saveStepAttribute(id_transformation, id_step, "connect_timeout", this.getConnectTimeout());
        rep.saveStepAttribute(id_transformation, id_step, "socket_timeout", this.getSocketTimeout());
        rep.saveStepAttribute(id_transformation, id_step, "use_ssl_socket_factory", this.isUseSSLSocketFactory());
        rep.saveStepAttribute(id_transformation, id_step, "read_preference", this.getReadPreference());
        rep.saveStepAttribute(id_transformation, id_step, "write_concern", this.getWriteConcern());
        rep.saveStepAttribute(id_transformation, id_step, "w_timeout", this.getWTimeout());
        rep.saveStepAttribute(id_transformation, id_step, "journaled_writes", this.getJournal());
        rep.saveStepAttribute(id_transformation, id_step, 0, "truncate", this.m_truncate);
        rep.saveStepAttribute(id_transformation, id_step, 0, "update", this.m_update);
        rep.saveStepAttribute(id_transformation, id_step, 0, "upsert", this.m_upsert);
        rep.saveStepAttribute(id_transformation, id_step, 0, "multi", this.m_multi);
        rep.saveStepAttribute(id_transformation, id_step, 0, "modifier_update", this.m_modifierUpdate);
        rep.saveStepAttribute(id_transformation, id_step, 0, "write_retries", this.m_writeRetries);
        rep.saveStepAttribute(id_transformation, id_step, 0, "write_retry_delay", this.m_writeRetryDelay);
        if (this.m_mongoFields != null && this.m_mongoFields.size() > 0) {
            for (i = 0; i < this.m_mongoFields.size(); ++i) {
                MongoField field = this.m_mongoFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "incoming_field_name", field.m_incomingFieldName);
                rep.saveStepAttribute(id_transformation, id_step, i, "mongo_doc_path", field.m_mongoDocPath);
                rep.saveStepAttribute(id_transformation, id_step, i, "use_incoming_field_name_as_mongo_field_name", field.m_useIncomingFieldNameAsMongoFieldName);
                rep.saveStepAttribute(id_transformation, id_step, i, "update_match_field", field.m_updateMatchField);
                rep.saveStepAttribute(id_transformation, id_step, i, "modifier_update_operation", field.m_modifierUpdateOperation);
                rep.saveStepAttribute(id_transformation, id_step, i, "modifier_policy", field.m_modifierOperationApplyPolicy);
                rep.saveStepAttribute(id_transformation, id_step, i, "json_field", field.m_JSON);
                rep.saveStepAttribute(id_transformation, id_step, i, "allow_null", field.insertNull);
            }
        }
        if (this.m_mongoIndexes != null && this.m_mongoIndexes.size() > 0) {
            for (i = 0; i < this.m_mongoIndexes.size(); ++i) {
                MongoIndex mongoIndex = this.m_mongoIndexes.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "path_to_fields", mongoIndex.m_pathToFields);
                rep.saveStepAttribute(id_transformation, id_step, i, "drop", mongoIndex.m_drop);
                rep.saveStepAttribute(id_transformation, id_step, i, "unique", mongoIndex.m_unique);
                rep.saveStepAttribute(id_transformation, id_step, i, "sparse", mongoIndex.m_sparse);
            }
        }
    }

    public String getDialogClassName() {
        return MongoDbOutputDialog.class.getCanonicalName();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static class MongoIndex {
        @Injection(name="INDEX_FIELD", group="INDEXES")
        public String m_pathToFields = "";
        @Injection(name="DROP", group="INDEXES")
        public boolean m_drop;
        @Injection(name="UNIQUE", group="INDEXES")
        public boolean m_unique;
        @Injection(name="SPARSE", group="INDEXES")
        public boolean m_sparse;

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_pathToFields + " (unique = " + new Boolean(this.m_unique).toString() + " sparse = " + new Boolean(this.m_sparse).toString() + ")");
            return buff.toString();
        }
    }

    public static class MongoField {
        @Injection(name="INCOMING_FIELD_NAME", group="FIELDS")
        public String m_incomingFieldName = "";
        String environUpdatedFieldName = "";
        @Injection(name="MONGO_DOCUMENT_PATH", group="FIELDS")
        public String m_mongoDocPath = "";
        String environUpdateMongoDocPath = "";
        protected List<String> m_pathList;
        protected List<String> m_tempPathList;
        @Injection(name="INCOMING_AS_MONGO", group="FIELDS")
        public boolean m_useIncomingFieldNameAsMongoFieldName;
        @Injection(name="UPDATE_MATCH_FIELD", group="FIELDS")
        public boolean m_updateMatchField;
        @Injection(name="MODIFIER_OPERATION", group="FIELDS")
        public String m_modifierUpdateOperation = "N/A";
        String environUpdateModifierOperation = "";
        @Injection(name="MODIFIER_POLICY", group="FIELDS")
        public String m_modifierOperationApplyPolicy = "Insert&Update";
        @Injection(name="INSERT_NULL", group="FIELDS")
        public boolean insertNull = false;
        @Injection(name="JSON", group="FIELDS")
        public boolean m_JSON = false;

        public MongoField copy() {
            MongoField newF = new MongoField();
            newF.m_incomingFieldName = this.m_incomingFieldName;
            newF.environUpdatedFieldName = this.environUpdatedFieldName;
            newF.m_mongoDocPath = this.m_mongoDocPath;
            newF.environUpdateMongoDocPath = this.environUpdateMongoDocPath;
            newF.m_useIncomingFieldNameAsMongoFieldName = this.m_useIncomingFieldNameAsMongoFieldName;
            newF.m_updateMatchField = this.m_updateMatchField;
            newF.m_modifierUpdateOperation = this.m_modifierUpdateOperation;
            newF.environUpdateModifierOperation = this.environUpdateModifierOperation;
            newF.m_modifierOperationApplyPolicy = this.m_modifierOperationApplyPolicy;
            newF.m_JSON = this.m_JSON;
            newF.insertNull = this.insertNull;
            return newF;
        }

        public void init(VariableSpace vars) {
            this.init(vars, true);
        }

        public void init(VariableSpace vars, boolean updateFromEnv) {
            if (updateFromEnv) {
                this.environUpdatedFieldName = vars.environmentSubstitute(this.m_incomingFieldName);
                this.environUpdateMongoDocPath = vars.environmentSubstitute(this.m_mongoDocPath, true);
                this.environUpdateModifierOperation = vars.environmentSubstitute(this.m_modifierUpdateOperation);
            }
            this.m_pathList = new ArrayList<String>();
            if (!Const.isEmpty((String)this.environUpdateMongoDocPath)) {
                String[] parts;
                for (String p : parts = this.environUpdateMongoDocPath.split("\\.")) {
                    this.m_pathList.add(p);
                }
            }
            this.m_tempPathList = new ArrayList<String>(this.m_pathList);
        }

        public void reset() {
            if (this.m_tempPathList != null && this.m_tempPathList.size() > 0) {
                this.m_tempPathList.clear();
            }
            if (this.m_tempPathList != null) {
                this.m_tempPathList.addAll(this.m_pathList);
            }
        }
    }
}

