/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbResourceInfo;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ConnectionExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.mongo.wrapper.field.MongoField;

public class MongoDbInputStepAnalyzer
extends ConnectionExternalResourceStepAnalyzer<MongoDbInputMeta> {
    public static final String COLLECTION = "collection";
    public static final String AGG_PIPELINE = "isAggPipeline";
    public static final String FIELDS_EXPRESSION = "fieldsExpression";
    public static final String READ_PREF = "readPreference";
    public static final String TAG_SETS = "tagSets";
    public static final String OUTPUT_JSON = "outputJson";
    public static final String JSON_PATH = "jsonPath";
    public static final String MINMAX_RANGE = "minMaxArrayRange";
    public static final String OCCUR_RATIO = "occurRatio";
    public static final String INDEXED_VALS = "indexedValues";
    public static final String DISPARATE_TYPES = "disparateTypes";

    protected void customAnalyze(MongoDbInputMeta meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        this.getConnectionAnalyzer().setMetaverseBuilder(this.getMetaverseBuilder());
        super.customAnalyze((BaseStepMeta)meta, node);
        node.setProperty(OUTPUT_JSON, (Object)meta.getOutputJson());
        node.setProperty(COLLECTION, (Object)meta.getCollection());
        if (!meta.getOutputJson()) {
            node.setProperty("query", (Object)meta.getJsonQuery());
            node.setProperty(AGG_PIPELINE, (Object)meta.getQueryIsPipeline());
            node.setProperty("executeEachRow", (Object)meta.getExecuteForEachIncomingRow());
            node.setProperty(FIELDS_EXPRESSION, (Object)meta.getFieldsName());
            node.setProperty(READ_PREF, (Object)meta.getReadPreference());
            List<String> tagSets = meta.getReadPrefTagSets();
            if (tagSets != null) {
                node.setProperty(TAG_SETS, (Object)tagSets.toString());
            }
        }
    }

    protected IMetaverseNode createOutputFieldNode(IAnalysisContext context, ValueMetaInterface fieldMeta, String targetStepName, String nodeType) {
        IMetaverseNode mongoFieldNode = super.createOutputFieldNode(context, fieldMeta, targetStepName, nodeType);
        List<MongoField> mongoFields = ((MongoDbInputMeta)this.baseStepMeta).getMongoFields();
        if (mongoFields != null) {
            for (MongoField mongoField : mongoFields) {
                if (!fieldMeta.getName().equals(mongoField.getName())) continue;
                mongoFieldNode.setProperty(JSON_PATH, (Object)mongoField.m_fieldPath);
                mongoFieldNode.setProperty(MINMAX_RANGE, (Object)mongoField.m_arrayIndexInfo);
                mongoFieldNode.setProperty(OCCUR_RATIO, (Object)mongoField.m_occurenceFraction);
                mongoFieldNode.setProperty(INDEXED_VALS, mongoField.m_indexedVals);
                mongoFieldNode.setProperty(DISPARATE_TYPES, (Object)mongoField.m_disparateTypes);
                break;
            }
        }
        return mongoFieldNode;
    }

    protected Set<StepField> getUsedFields(MongoDbInputMeta meta) {
        return null;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(MongoDbInputMeta.class);
        return supportedSteps;
    }

    protected IMetaverseNode createTableNode(IExternalResourceInfo resource) throws MetaverseAnalyzerException {
        MongoDbResourceInfo resourceInfo = (MongoDbResourceInfo)resource;
        MetaverseComponentDescriptor componentDescriptor = new MetaverseComponentDescriptor(resourceInfo.getCollection(), "MongoDB Collection", this.getConnectionNode(), this.getDescriptor().getContext());
        IMetaverseNode node = this.createNodeFromDescriptor((IComponentDescriptor)componentDescriptor);
        node.setProperty("namespace", (Object)componentDescriptor.getNamespace().getNamespaceId());
        node.setProperty(COLLECTION, (Object)resourceInfo.getCollection());
        node.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DEFAULT);
        return node;
    }

    public String getResourceInputNodeType() {
        return "Database Column";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected IClonableStepAnalyzer newInstance() {
        return new MongoDbInputStepAnalyzer();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void setBaseStepMeta(MongoDbInputMeta meta) {
        this.baseStepMeta = meta;
    }

    protected void setRootNode(IMetaverseNode node) {
        this.rootNode = node;
    }

    protected void setParentTransMeta(TransMeta tm) {
        this.parentTransMeta = tm;
    }

    protected void setParentStepMeta(StepMeta sm) {
        this.parentStepMeta = sm;
    }
}

