/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.geom;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictDimension;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictPoint;
import org.pentaho.reporting.libraries.base.util.FloatDimension;

public strictfp class StrictGeomUtility {
    public static final long MAX_AUTO = StrictGeomUtility.toInternalValue(8.796093022208E12);
    private static final double CORRECTION_FACTOR = 100000.0;

    private StrictGeomUtility() {
    }

    public static StrictDimension createDimension(double w, double h) {
        return new StrictDimension(StrictGeomUtility.toInternalValue(w), StrictGeomUtility.toInternalValue(h));
    }

    public static StrictPoint createPoint(double x, double y) {
        return new StrictPoint(StrictGeomUtility.toInternalValue(x), StrictGeomUtility.toInternalValue(y));
    }

    public static StrictBounds createBounds(double x, double y, double width, double height) {
        return new StrictBounds(StrictGeomUtility.toInternalValue(x), StrictGeomUtility.toInternalValue(y), StrictGeomUtility.toInternalValue(width), StrictGeomUtility.toInternalValue(height));
    }

    public static Dimension2D createAWTDimension(long width, long height) {
        return new FloatDimension((float)((double)width / 100000.0), (float)((double)height / 100000.0));
    }

    public static Rectangle2D createAWTRectangle(long x, long y, long width, long height) {
        return new Rectangle2D.Double((double)x / 100000.0, (double)y / 100000.0, (double)width / 100000.0, (double)height / 100000.0);
    }

    public static Rectangle2D createAWTRectangle(StrictBounds bounds) {
        return StrictGeomUtility.createAWTRectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public static long toInternalValue(double value) {
        long rounded = StrictMath.round(value * 10000.0);
        return StrictMath.round((double)rounded * 100000.0 / 10000.0);
    }

    public static double toExternalValue(long value) {
        return (double)value / 100000.0;
    }

    public static double toFontMetricsValue(long value) {
        return (double)(value * 1000L) / 100000.0;
    }

    public static long fromFontMetricsValue(long value) {
        double rawValue = (double)value / 1000.0;
        return StrictGeomUtility.toInternalValue(rawValue);
    }

    public static long multiply(long x, long y) {
        if (x < y) {
            return (long)((double)x * ((double)y / 100000.0));
        }
        return (long)((double)y * ((double)x / 100000.0));
    }
}

