/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabProcessorFunction;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.crosstab.DummyCrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabOtherAxisHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabRowAxisHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class BeginCrosstabHandler
implements AdvanceHandler {
    public static final BeginCrosstabHandler HANDLER = new BeginCrosstabHandler();

    private BeginCrosstabHandler() {
    }

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.enterGroup();
        CrosstabSpecification cs = this.findCrosstabSpecification(next);
        DefaultFlowController controller = next.getFlowController().startCrosstabMode(cs);
        next.setFlowController(controller);
        next.fireReportEvent();
        next.enterPresentationGroup();
        return next;
    }

    private CrosstabSpecification findCrosstabSpecification(ProcessState next) throws ReportProcessingException {
        StructureFunction[] functions = next.getLayoutProcess().getCollectionFunctions();
        for (int i = 0; i < functions.length; ++i) {
            StructureFunction function = functions[i];
            if (!(function instanceof CrosstabProcessorFunction)) continue;
            CrosstabSpecification cs = (CrosstabSpecification)function.getValue();
            if (cs == null) {
                return new DummyCrosstabSpecification(next.getProcessKey());
            }
            return cs;
        }
        throw new ReportProcessingException("Failed to locate crosstab-spec, cannot continue.");
    }

    @Override
    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        CrosstabGroup group = (CrosstabGroup)next.getReport().getGroup(next.getCurrentGroupIndex());
        GroupBody body = group.getBody();
        if (body instanceof CrosstabRowGroupBody) {
            next.setAdvanceHandler(BeginCrosstabRowAxisHandler.HANDLER);
        } else if (body instanceof CrosstabOtherGroupBody) {
            next.setAdvanceHandler(BeginCrosstabOtherAxisHandler.HANDLER);
        } else {
            throw new IllegalStateException("This report is totally messed up!");
        }
        return next;
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    @Override
    public int getEventCode() {
        return 0x110008;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

