/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.FunctionsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.IncludeReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.elements.ElementFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.StyleKeyFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ParserConfigReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ReportConfigReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ReportDescriptionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.StylesReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.TemplatesReadHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class ReportDefinitionReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String ELEMENT_FACTORY_KEY = "::element-factory";
    public static final String STYLE_FACTORY_KEY = "::stylekey-factory";
    public static final String CLASS_FACTORY_KEY = "::class-factory";
    public static final String DATASOURCE_FACTORY_KEY = "::datasource-factory";
    public static final String TEMPLATE_FACTORY_KEY = "::template-factory";
    private MasterReport report;

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) throws SAXException {
        super.init(rootHandler, uri, tagName);
        rootHandler.setHelperObject("property-expansion", (Object)Boolean.TRUE);
    }

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        MasterReport report;
        RootXmlReadHandler rootHandler = this.getRootHandler();
        Object maybeReport = rootHandler.getHelperObject("::Report");
        if (!(maybeReport instanceof MasterReport)) {
            report = new MasterReport();
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", rootHandler.getSource());
        } else {
            report = (MasterReport)maybeReport;
        }
        if (!ReportParserUtil.isIncluded(rootHandler)) {
            String value;
            String query = attrs.getValue(this.getUri(), "query");
            if (query != null) {
                report.setQuery(query);
            }
            if ((value = attrs.getValue(this.getUri(), "name")) != null) {
                report.setName(value);
            }
        }
        ElementFactoryCollector elementFactory = new ElementFactoryCollector();
        StyleKeyFactoryCollector styleKeyFactory = new StyleKeyFactoryCollector();
        ClassFactoryCollector classFactory = new ClassFactoryCollector();
        DataSourceCollector dataSourceFactory = new DataSourceCollector();
        TemplateCollector templateFactory = new TemplateCollector();
        classFactory.configure((Configuration)rootHandler.getParserConfiguration());
        dataSourceFactory.configure((Configuration)rootHandler.getParserConfiguration());
        templateFactory.configure((Configuration)rootHandler.getParserConfiguration());
        if (!(rootHandler.getHelperObject("::Legacy-Styles") instanceof HashMap)) {
            rootHandler.setHelperObject("::Legacy-Styles", new HashMap());
        }
        rootHandler.setHelperObject("::Report", (Object)report);
        rootHandler.setHelperObject(ELEMENT_FACTORY_KEY, (Object)elementFactory);
        rootHandler.setHelperObject(STYLE_FACTORY_KEY, (Object)styleKeyFactory);
        rootHandler.setHelperObject(CLASS_FACTORY_KEY, (Object)classFactory);
        rootHandler.setHelperObject(DATASOURCE_FACTORY_KEY, (Object)dataSourceFactory);
        rootHandler.setHelperObject(TEMPLATE_FACTORY_KEY, (Object)templateFactory);
        report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "file-format", "extended-xml");
        report.setCompatibilityLevel(ClassicEngineBoot.computeVersionId(3, 8, 0));
        this.report = report;
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("parser-config".equals(tagName)) {
            return new ParserConfigReadHandler();
        }
        if ("report-config".equals(tagName)) {
            return new ReportConfigReadHandler();
        }
        if ("styles".equals(tagName)) {
            return new StylesReadHandler();
        }
        if ("templates".equals(tagName)) {
            return new TemplatesReadHandler();
        }
        if ("report-description".equals(tagName)) {
            return new ReportDescriptionReadHandler();
        }
        if ("functions".equals(tagName)) {
            return new FunctionsReadHandler(this.report);
        }
        if ("include".equals(tagName)) {
            return new IncludeReadHandler();
        }
        return null;
    }

    public Object getObject() {
        return this.getRootHandler().getHelperObject("::Report");
    }
}

