/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates;

import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.filter.templates.Template;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateDescription;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class TemplateCollection
implements Serializable {
    private final HashMap templates = new HashMap();
    private Configuration config;

    public void addTemplate(TemplateDescription template) {
        if (template == null) {
            throw new NullPointerException();
        }
        this.templates.put(template.getName(), template);
        if (this.getConfig() != null) {
            template.configure(this.getConfig());
        }
    }

    public TemplateDescription getTemplate(String name) {
        TemplateDescription td = (TemplateDescription)this.templates.get(name);
        if (td != null) {
            return (TemplateDescription)td.getInstance();
        }
        return null;
    }

    public TemplateDescription getDescription(Template template) {
        if (template == null) {
            throw new NullPointerException("Template given must not be null.");
        }
        for (TemplateDescription td : this.templates.values()) {
            if (!td.getObjectClass().equals(template.getClass())) continue;
            return (TemplateDescription)td.getInstance();
        }
        return null;
    }

    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        if (this.config != null) {
            return;
        }
        this.config = config;
        for (TemplateDescription od : this.templates.values()) {
            od.configure(config);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateCollection)) {
            return false;
        }
        TemplateCollection templateCollection = (TemplateCollection)o;
        return this.templates.equals(templateCollection.templates);
    }

    public int hashCode() {
        return this.templates.hashCode();
    }

    public String[] getNames() {
        return this.templates.keySet().toArray(new String[this.templates.size()]);
    }
}

