/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class BundleWriterUtilities {
    private static final Log logger = LogFactory.getLog(BundleWriterUtilities.class);
    private static final String DATA_PREFIX = "org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.data-factory-handler.";
    private static final String ELEMENT_PREFIX = "org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.element-handler.";

    private BundleWriterUtilities() {
    }

    public static BundleDataFactoryWriterHandler lookupWriteHandler(DataFactory dataFactory) {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        String configKey = DATA_PREFIX + dataFactory.getClass().getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value != null) {
            BundleDataFactoryWriterHandler dataFactoryWriterHandler = (BundleDataFactoryWriterHandler)ObjectUtilities.loadAndInstantiate((String)value, dataFactory.getClass(), BundleDataFactoryWriterHandler.class);
            if (dataFactoryWriterHandler == null) {
                logger.warn((Object)("Specified data-source write handler implementation could not be loaded: " + value));
            }
            return dataFactoryWriterHandler;
        }
        logger.warn((Object)("No data-source write handler known for: " + value));
        return null;
    }

    public static BundleDataFactoryWriterHandler lookupWriteHandler(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        ElementType type = element.getElementType();
        if (type == null) {
            return null;
        }
        ElementMetaData metaData = type.getMetaData();
        String configKey = ELEMENT_PREFIX + metaData.getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value != null) {
            return (BundleDataFactoryWriterHandler)ObjectUtilities.loadAndInstantiate((String)value, metaData.getClass(), BundleDataFactoryWriterHandler.class);
        }
        return null;
    }
}

