/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.content;

import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data.DataDefinition;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.settings.BundleSettings;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ContentRootElementHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(ContentRootElementHandler.class);
    public static final String PRPT_SPEC_VERSION = "prpt-spec-version";
    private MasterReport report;

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) throws SAXException {
        super.init(rootHandler, uri, tagName);
        rootHandler.setHelperObject("property-expansion", (Object)Boolean.FALSE);
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        block6: {
            Object maybeReport = this.getRootHandler().getHelperObject("::Report");
            if (!(maybeReport instanceof MasterReport)) {
                this.report = new MasterReport();
                this.report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "file-format", "unified-fileformat");
                ResourceKey key = this.getRootHandler().getSource();
                if (key.getParent() != null) {
                    ResourceManager resourceManager = this.getRootHandler().getResourceManager();
                    try {
                        Resource bundleData = resourceManager.create(key.getParent(), null, DocumentBundle.class);
                        DocumentBundle documentBundle = (DocumentBundle)bundleData.getResource();
                        this.report.setBundle(documentBundle);
                        DocumentMetaData metaData = documentBundle.getMetaData();
                        int versionMajorRaw = this.getBundleAttribute(metaData, "prpt-spec.version.major");
                        int versionMinorRaw = this.getBundleAttribute(metaData, "prpt-spec.version.minor");
                        int versionPatchRaw = this.getBundleAttribute(metaData, "prpt-spec.version.patch");
                        if (versionMajorRaw == -1 || versionMinorRaw == -1 || versionPatchRaw == -1 || versionMajorRaw == 0 && versionMinorRaw == 0 && versionPatchRaw == 0) {
                            this.getRootHandler().setHelperObject(PRPT_SPEC_VERSION, (Object)ClassicEngineBoot.computeVersionId(3, 8, 0));
                            break block6;
                        }
                        this.validateVersionNumbers(versionMajorRaw, versionMinorRaw, versionPatchRaw);
                        this.getRootHandler().setHelperObject(PRPT_SPEC_VERSION, (Object)ClassicEngineBoot.computeVersionId(versionMajorRaw, versionMinorRaw, versionPatchRaw));
                    }
                    catch (ResourceException e) {
                        this.getRootHandler().warning(new SAXParseException("Unable to load the bundle. Bundle data may be unavailable.", this.getLocator()));
                    }
                }
            } else {
                this.report = (MasterReport)maybeReport;
            }
        }
    }

    private void validateVersionNumbers(int prptVersionMajorRaw, int prptVersionMinorRaw, int prptVersionPatchRaw) throws ParseException {
        ClassicEngineBoot.VersionValidity v = ClassicEngineBoot.isValidVersion(prptVersionMajorRaw, prptVersionMinorRaw, prptVersionPatchRaw);
        if (v == ClassicEngineBoot.VersionValidity.INVALID_RELEASE) {
            throw new ParseException(String.format("The report file you are trying to load was created with Pentaho Reporting %d.%d but you are trying to run it with Pentaho Reporting %s. Please update your reporting installation to match the report designer that was used to create this file.", prptVersionMajorRaw, prptVersionMinorRaw, ClassicEngineInfo.getInstance().getVersion()));
        }
        if (v == ClassicEngineBoot.VersionValidity.INVALID_PATCH) {
            logger.warn((Object)String.format("The report file you are trying to load was created with Pentaho Reporting %d.%d.%d but you are trying to run it with Pentaho Reporting %s. Your reporting engine version may not have all features or bug-fixes required to display this report properly.", prptVersionMajorRaw, prptVersionMinorRaw, prptVersionPatchRaw, ClassicEngineInfo.getInstance().getVersion()));
        }
    }

    private int getBundleAttribute(DocumentMetaData metaData, String name) {
        Object raw = metaData.getBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", name);
        if (raw == null) {
            return -1;
        }
        try {
            return Integer.parseInt(String.valueOf(raw));
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!"http://reporting.pentaho.org/namespaces/engine/classic/bundle/content/1.0".equals(uri)) {
            return null;
        }
        if ("settings".equals(tagName)) {
            String fallbackFile;
            String primaryFile = atts.getValue(this.getUri(), "ref");
            if (primaryFile == null) {
                throw new ParseException("Required attribute 'ref' is not specified", this.getLocator());
            }
            if (!this.parseSettings(primaryFile) && (fallbackFile = atts.getValue(this.getUri(), "local-copy")) != null && !this.parseSettings(fallbackFile)) {
                throw new ParseException("Parsing the specified local-copy failed", this.getLocator());
            }
            return new IgnoreAnyChildReadHandler();
        }
        if ("data-definition".equals(tagName)) {
            String fallbackFile;
            String primaryFile = atts.getValue(this.getUri(), "ref");
            if (primaryFile == null) {
                throw new ParseException("Required attribute 'ref' is not specified", this.getLocator());
            }
            if (!this.parseDataDefinition(primaryFile) && (fallbackFile = atts.getValue(this.getUri(), "local-copy")) != null && !this.parseDataDefinition(fallbackFile)) {
                throw new ParseException("Parsing the specified local-copy failed", this.getLocator());
            }
            return new IgnoreAnyChildReadHandler();
        }
        if ("styles".equals(tagName)) {
            String fallbackFile;
            String primaryFile = atts.getValue(this.getUri(), "ref");
            if (primaryFile == null) {
                throw new ParseException("Required attribute 'ref' is not specified", this.getLocator());
            }
            if (!this.parseStyles(primaryFile) && (fallbackFile = atts.getValue(this.getUri(), "local-copy")) != null && !this.parseStyles(fallbackFile)) {
                throw new ParseException("Parsing the specified local-copy failed", this.getLocator());
            }
            return new IgnoreAnyChildReadHandler();
        }
        if ("layout".equals(tagName)) {
            String fallbackFile;
            String primaryFile = atts.getValue(this.getUri(), "ref");
            if (primaryFile == null) {
                throw new ParseException("Required attribute 'ref' is not specified", this.getLocator());
            }
            if (!this.parseLayout(primaryFile) && (fallbackFile = atts.getValue(this.getUri(), "local-copy")) != null && !this.parseLayout(fallbackFile)) {
                throw new ParseException("Parsing the specified local-copy failed", this.getLocator());
            }
            return new IgnoreAnyChildReadHandler();
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.parseLocalFiles();
        Integer definedCompatLevel = this.report.getCompatibilityLevel();
        if (!(definedCompatLevel instanceof Integer)) {
            Object specRaw = this.getRootHandler().getHelperObject(PRPT_SPEC_VERSION);
            Integer x = ClassicEngineBoot.computeVersionId(999, 999, 999);
            if (specRaw instanceof Integer && !x.equals(specRaw)) {
                this.report.setCompatibilityLevel((Integer)specRaw);
            } else {
                this.report.setCompatibilityLevel(x);
            }
        }
    }

    private void parseLocalFiles() throws ParseException {
        this.parseSettings("settings.xml");
        this.parseDataDefinition("datadefinition.xml");
        this.parseDataSchema();
        this.parseStyles("styles.xml");
        this.parseLayout("layout.xml");
    }

    private boolean parseLayout(String layout) throws ParseException {
        try {
            Map parameters = this.deriveParseParameters();
            parameters.put(new FactoryParameterKey("::Report"), this.report);
            parameters.put(new FactoryParameterKey("::Include-parser"), ReportParserUtil.INCLUDE_PARSING_VALUE);
            MasterReport report = (MasterReport)this.performExternalParsing(layout, MasterReport.class, parameters);
            return report == this.report;
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)("Unable to parse the parameter for this bundle from file: " + layout));
            return false;
        }
    }

    private boolean parseStyles(String stylefile) throws ParseException {
        try {
            Map parameters = this.deriveParseParameters();
            parameters.put(new FactoryParameterKey("::Report"), this.report);
            parameters.put(new FactoryParameterKey("::Include-parser"), ReportParserUtil.INCLUDE_PARSING_VALUE);
            MasterReport report = (MasterReport)this.performExternalParsing(stylefile, MasterReport.class, parameters);
            return report == this.report;
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)("Unable to parse the parameter for this bundle from file: " + stylefile));
            return false;
        }
    }

    private boolean parseDataDefinition(String parameterFile) throws ParseException {
        try {
            Expression[] expressions;
            ReportParameterDefinition definition;
            Map parameters = this.deriveParseParameters();
            parameters.put(new FactoryParameterKey("::Report"), null);
            DataDefinition dataDefinition = (DataDefinition)this.performExternalParsing(parameterFile, DataDefinition.class, parameters);
            this.report.setQuery(dataDefinition.getQuery());
            this.report.setQueryLimit(dataDefinition.getQueryLimit());
            this.report.setQueryTimeout(dataDefinition.getQueryTimeout());
            DataFactory dataFactory = dataDefinition.getDataFactory();
            if (dataFactory != null) {
                this.report.setDataFactory(dataFactory);
            }
            if ((definition = dataDefinition.getParameterDefinition()) != null) {
                this.report.setParameterDefinition(definition);
            }
            if ((expressions = dataDefinition.getExpressions()) != null) {
                for (int i = 0; i < expressions.length; ++i) {
                    Expression expression = expressions[i];
                    this.report.addExpression(expression);
                }
            }
            return true;
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)("Unable to parse the parameter for this bundle from file: " + parameterFile));
            return false;
        }
        catch (ReportDataFactoryException e) {
            logger.warn((Object)("Unable to parse the parameter for this bundle from file: " + parameterFile));
            return false;
        }
    }

    private boolean parseSettings(String settingsFile) throws ParseException {
        try {
            Map parameters = this.deriveParseParameters();
            parameters.put(new FactoryParameterKey("::Report"), null);
            BundleSettings settings = (BundleSettings)this.performExternalParsing(settingsFile, BundleSettings.class, parameters);
            Configuration configuration = settings.getConfiguration();
            Enumeration configProperties = configuration.getConfigProperties();
            while (configProperties.hasMoreElements()) {
                String key = (String)configProperties.nextElement();
                String value = configuration.getConfigProperty(key);
                if (value == null) continue;
                this.report.getReportConfiguration().setConfigProperty(key, value);
            }
            return true;
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)("Unable to parse the settingsFile for this bundle from file: " + settingsFile));
            return false;
        }
    }

    private boolean parseDataSchema() throws ParseException {
        try {
            Map parameters = this.deriveParseParameters();
            parameters.put(new FactoryParameterKey("::Report"), null);
            DataSchemaDefinition metaData = (DataSchemaDefinition)this.performExternalParsing("dataschema.xml", DataSchemaDefinition.class, parameters);
            this.report.setDataSchemaDefinition(metaData);
            return true;
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)"Unable to parse the dataschema for this bundle.");
            return false;
        }
    }

    public Object getObject() throws SAXException {
        return this.report;
    }
}

