/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import org.apache.poi.ss.usermodel.Font;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public final class HSSFFontWrapper {
    public static final int FONT_FACTOR = 20;
    private final String fontName;
    private final short colorIndex;
    private final int fontHeight;
    private final boolean bold;
    private final boolean italic;
    private final boolean underline;
    private final boolean strikethrough;
    private int hashCode;

    public HSSFFontWrapper(StyleSheet contentStyle, short colorIndex) {
        if (colorIndex < 0) {
            throw new IllegalArgumentException("Negative color index is not allowed");
        }
        this.fontName = this.normalizeFontName((String)contentStyle.getStyleProperty(TextStyleKeys.FONT));
        this.fontHeight = contentStyle.getIntStyleProperty(TextStyleKeys.FONTSIZE, 0);
        this.bold = contentStyle.getBooleanStyleProperty(TextStyleKeys.BOLD);
        this.italic = contentStyle.getBooleanStyleProperty(TextStyleKeys.ITALIC);
        this.underline = contentStyle.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
        this.strikethrough = contentStyle.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
        this.colorIndex = colorIndex;
    }

    public HSSFFontWrapper(String fontName, short fontSize, boolean bold, boolean italic, boolean underline, boolean strikethrough, short colorIndex) {
        if (fontName == null) {
            throw new NullPointerException("FontDefinition is null");
        }
        if (colorIndex < 0) {
            throw new IllegalArgumentException("Negative color index is not allowed");
        }
        this.fontName = this.normalizeFontName(fontName);
        this.fontHeight = fontSize;
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.strikethrough = strikethrough;
        this.colorIndex = colorIndex;
    }

    private String normalizeFontName(String fontName) {
        if ("SansSerif".equalsIgnoreCase(fontName) || "Dialog".equalsIgnoreCase(fontName)) {
            return "Arial";
        }
        if ("Monospace".equalsIgnoreCase(fontName)) {
            return "Courier New";
        }
        if ("Serif".equalsIgnoreCase(fontName)) {
            return "Times New Roman";
        }
        return fontName;
    }

    public HSSFFontWrapper(Font font) {
        if (font == null) {
            throw new NullPointerException("Font is null");
        }
        if (font.getColor() < 0) {
            throw new IllegalArgumentException("Negative color index is not allowed");
        }
        this.fontName = this.normalizeFontName(font.getFontName());
        this.fontHeight = font.getFontHeightInPoints();
        this.bold = font.getBold();
        this.italic = font.getItalic();
        this.underline = font.getUnderline() != 0;
        this.strikethrough = font.getStrikeout();
        this.colorIndex = font.getColor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HSSFFontWrapper)) {
            return false;
        }
        HSSFFontWrapper wrapper = (HSSFFontWrapper)o;
        if (this.bold != wrapper.bold) {
            return false;
        }
        if (this.underline != wrapper.underline) {
            return false;
        }
        if (this.strikethrough != wrapper.strikethrough) {
            return false;
        }
        if (this.colorIndex != wrapper.colorIndex) {
            return false;
        }
        if (this.fontHeight != wrapper.fontHeight) {
            return false;
        }
        if (this.italic != wrapper.italic) {
            return false;
        }
        return this.fontName.equals(wrapper.fontName);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.fontName.hashCode();
            result = 29 * result + this.colorIndex;
            result = 29 * result + this.fontHeight;
            result = 29 * result + (this.bold ? 1 : 0);
            result = 29 * result + (this.italic ? 1 : 0);
            result = 29 * result + (this.underline ? 1 : 0);
            this.hashCode = result = 29 * result + (this.strikethrough ? 1 : 0);
        }
        return this.hashCode;
    }

    public String toString() {
        return "HSSFFontWrapper{fontName='" + this.fontName + '\'' + ", colorIndex=" + this.colorIndex + ", fontHeight=" + this.fontHeight + ", bold=" + this.bold + ", italic=" + this.italic + ", underline=" + this.underline + ", strikethrough=" + this.strikethrough + ", hashCode=" + this.hashCode + '}';
    }

    public boolean isBold() {
        return this.bold;
    }

    public short getColorIndex() {
        return this.colorIndex;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isUnderline() {
        return this.underline;
    }
}

