/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.itext;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfDocumentSettings;
import com.lowagie.text.rtf.parser.RtfImportMappings;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.text.RtfNewPage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.itext.PatchRtfDocument;

public class PatchRtfWriter2
extends DocWriter {
    private PatchRtfDocument rtfDoc = null;

    protected PatchRtfWriter2(Document doc, OutputStream os) {
        super(doc, os);
        doc.addDocListener((DocListener)this);
        this.rtfDoc = new PatchRtfDocument();
    }

    public static PatchRtfWriter2 getInstance(Document doc, OutputStream os) {
        return new PatchRtfWriter2(doc, os);
    }

    public void setHeader(HeaderFooter hf) {
        this.rtfDoc.getDocumentHeader().setHeader(hf);
    }

    public void resetHeader() {
        this.rtfDoc.getDocumentHeader().setHeader(null);
    }

    public void setFooter(HeaderFooter hf) {
        this.rtfDoc.getDocumentHeader().setFooter(hf);
    }

    public void resetFooter() {
        this.rtfDoc.getDocumentHeader().setFooter(null);
    }

    public void setPageCount(int i) {
    }

    public void resetPageCount() {
    }

    public void clearTextWrap() {
    }

    public void open() {
        super.open();
        this.rtfDoc.open();
    }

    public void close() {
        if (this.open) {
            this.rtfDoc.writeDocument((OutputStream)this.os);
            super.close();
            this.rtfDoc = new PatchRtfDocument();
        }
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        RtfBasicElement[] rtfElements = this.rtfDoc.getMapper().mapElement(element);
        if (rtfElements.length != 0) {
            for (int i = 0; i < rtfElements.length; ++i) {
                if (rtfElements[i] == null) continue;
                this.rtfDoc.add(rtfElements[i]);
            }
            return true;
        }
        return false;
    }

    public boolean newPage() {
        this.rtfDoc.add((RtfBasicElement)new RtfNewPage((RtfDocument)this.rtfDoc));
        return true;
    }

    public boolean setMargins(float left, float right, float top, float bottom) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginLeft((int)((double)left * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginRight((int)((double)right * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginTop((int)((double)top * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginBottom((int)((double)bottom * 20.0));
        return true;
    }

    public boolean setPageSize(Rectangle rect) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setPageSize(rect);
        return true;
    }

    public void setAutogenerateTOCEntries(boolean autogenerate) {
        this.rtfDoc.setAutogenerateTOCEntries(autogenerate);
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.rtfDoc.getDocumentSettings();
    }

    public void importRtfDocument(FileInputStream documentSource) throws IOException, DocumentException {
        this.importRtfDocument(documentSource, null);
    }

    public void importRtfDocument(InputStream documentSource, EventListener[] events) throws IOException, DocumentException {
        if (!this.open) {
            throw new DocumentException("The document must be open to import RTF documents.");
        }
        RtfParser rtfImport = new RtfParser(this.document);
        if (events != null) {
            for (int idx = 0; idx < events.length; ++idx) {
                rtfImport.addListener(events[idx]);
            }
        }
        rtfImport.importRtfDocument(documentSource, (RtfDocument)this.rtfDoc);
    }

    public void importRtfFragment(InputStream documentSource, RtfImportMappings mappings) throws IOException, DocumentException {
        this.importRtfFragment(documentSource, mappings, null);
    }

    public void importRtfFragment(InputStream documentSource, RtfImportMappings mappings, EventListener[] events) throws IOException, DocumentException {
        if (!this.open) {
            throw new DocumentException("The document must be open to import RTF fragments.");
        }
        RtfParser rtfImport = new RtfParser(this.document);
        if (events != null) {
            for (int idx = 0; idx < events.length; ++idx) {
                rtfImport.addListener(events[idx]);
            }
        }
        rtfImport.importRtfFragment(documentSource, (RtfDocument)this.rtfDoc, mappings);
    }

    public void importRtfDocumentIntoElement(Element elem, FileInputStream documentSource) throws IOException, DocumentException {
        this.importRtfDocumentIntoElement(elem, documentSource, null);
    }

    public void importRtfDocumentIntoElement(Element elem, FileInputStream documentSource, EventListener[] events) throws IOException, DocumentException {
        RtfParser rtfImport = new RtfParser(this.document);
        if (events != null) {
            for (int idx = 0; idx < events.length; ++idx) {
                rtfImport.addListener(events[idx]);
            }
        }
        rtfImport.importRtfDocumentIntoElement(elem, (InputStream)documentSource, (RtfDocument)this.rtfDoc);
    }
}

