/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SlimSheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriteException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.ContentUrlReWriteService;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultHtmlContentGenerator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultStyleBuilderFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.GlobalStyleManager;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTagHelper;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.InlineStyleManager;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleManager;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.WriterService;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.MemoryStringReader;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public abstract class AbstractHtmlPrinter {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    protected static final String[] XHTML_HEADER = new String[]{"<!DOCTYPE html", "     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"", "     \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"};
    protected static final StyleBuilder.CSSKeys[] EMPTY_CELL_ATTRNAMES = new StyleBuilder.CSSKeys[]{StyleBuilder.CSSKeys.FONT_SIZE};
    protected static final String[] EMPTY_CELL_ATTRVALS = new String[]{"1pt"};
    private static final String GENERATOR = ClassicEngineInfo.getInstance().getName() + " version " + ClassicEngineInfo.getInstance().getVersion();
    private DefaultStyleBuilderFactory styleBuilderFactory;
    private DefaultHtmlContentGenerator contentGenerator;
    private Configuration configuration;
    private ContentItem styleFile;
    private String styleFileUrl;
    private HtmlTagHelper tagHelper;
    private boolean allowRawLinkTargets;

    public AbstractHtmlPrinter(ResourceManager resourceManager) {
        if (resourceManager == null) {
            throw new NullPointerException("A resource-manager must be given.");
        }
        this.contentGenerator = new DefaultHtmlContentGenerator(resourceManager);
    }

    protected void initialize(Configuration configuration) {
        this.configuration = configuration;
        this.contentGenerator.setCopyExternalImages("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.CopyExternalImages")));
        this.allowRawLinkTargets = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllowRawLinkTargets"));
        this.styleBuilderFactory = new DefaultStyleBuilderFactory();
        this.styleBuilderFactory.configure(ClassicEngineBoot.getInstance().getGlobalConfig());
        this.tagHelper = new HtmlTagHelper(configuration, this.styleBuilderFactory);
    }

    public boolean isAllowRawLinkTargets() {
        return this.allowRawLinkTargets;
    }

    public StyleManager getStyleManager() {
        return this.tagHelper.getStyleManager();
    }

    public void setStyleManager(StyleManager styleManager) {
        this.tagHelper.setStyleManager(styleManager);
    }

    public HtmlTagHelper getTagHelper() {
        return this.tagHelper;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setDataWriter(ContentLocation dataLocation, NameGenerator dataNameGenerator) {
        this.contentGenerator.setDataWriter(dataLocation, dataNameGenerator, this.getContentReWriteService());
    }

    protected abstract ContentUrlReWriteService getContentReWriteService();

    public StyleBuilder getStyleBuilder() {
        return this.tagHelper.getStyleBuilder();
    }

    public DefaultStyleBuilderFactory getStyleBuilderFactory() {
        return this.styleBuilderFactory;
    }

    public DefaultHtmlContentGenerator getContentGenerator() {
        return this.contentGenerator;
    }

    protected ResourceManager getResourceManager() {
        return this.contentGenerator.getResourceManager();
    }

    protected boolean isProportionalColumnWidths() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ProportionalColumnWidths", "false"));
    }

    protected void writeColumnDeclaration(SlimSheetLayout sheetLayout, XmlWriter xmlWriter) throws IOException {
        double colWidth;
        int width;
        int col;
        double totalWidth;
        String unit;
        StyleBuilder styleBuilder = this.getStyleBuilder();
        DefaultStyleBuilderFactory styleBuilderFactory = this.getStyleBuilderFactory();
        if (sheetLayout == null) {
            throw new NullPointerException();
        }
        int colCount = sheetLayout.getColumnCount();
        int fullWidth = (int)StrictGeomUtility.toExternalValue(sheetLayout.getMaxWidth());
        String[] colWidths = new String[colCount];
        boolean proportionalColumnWidths = this.isProportionalColumnWidths();
        NumberFormat pointConverter = styleBuilder.getPointConverter();
        if (proportionalColumnWidths) {
            unit = "%";
            totalWidth = 0.0;
            for (col = 0; col < colCount; ++col) {
                width = (int)StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(col, col + 1));
                colWidth = styleBuilderFactory.fixLengthForSafari(Math.max(1.0, (double)width * 100.0 / (double)fullWidth));
                if (col == colCount - 1) {
                    colWidths[col] = pointConverter.format(100.0 - totalWidth);
                    continue;
                }
                totalWidth += colWidth;
                colWidths[col] = pointConverter.format(colWidth);
            }
        } else {
            unit = "pt";
            totalWidth = 0.0;
            for (col = 0; col < colCount; ++col) {
                width = (int)StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(col, col + 1));
                colWidth = styleBuilderFactory.fixLengthForSafari(Math.max(1, width));
                if (col == colCount - 1) {
                    colWidths[col] = pointConverter.format((double)fullWidth - totalWidth);
                    continue;
                }
                totalWidth += colWidth;
                colWidths[col] = pointConverter.format(colWidth);
            }
        }
        for (int col2 = 0; col2 < colCount; ++col2) {
            styleBuilder.clear();
            styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, colWidths[col2], unit);
            xmlWriter.writeTag(null, "col", "style", styleBuilder.toString(), true);
        }
    }

    protected void writeCompleteHeader(XmlWriter docWriter, String sheetName, ReportAttributeMap attributes, String styleSheetUrl, StyleManager inlineStyleSheet) throws IOException {
        Configuration configuration = this.getConfiguration();
        String encoding = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
        docWriter.writeXmlDeclaration(encoding);
        for (int i = 0; i < XHTML_HEADER.length; ++i) {
            docWriter.writeText(XHTML_HEADER[i]);
            docWriter.writeNewLine();
        }
        docWriter.writeTag(XHTML_NAMESPACE, "html", false);
        docWriter.writeTag(XHTML_NAMESPACE, "head", false);
        String title = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Title");
        if (title != null) {
            docWriter.writeTag(XHTML_NAMESPACE, "title", false);
            docWriter.writeTextNormalized(title, false);
            docWriter.writeCloseTag();
        } else if (sheetName != null) {
            docWriter.writeTag(XHTML_NAMESPACE, "title", false);
            docWriter.writeTextNormalized(sheetName, true);
            docWriter.writeCloseTag();
        } else {
            docWriter.writeTag(XHTML_NAMESPACE, "title", false);
            docWriter.writeText(" ");
            docWriter.writeCloseTag();
        }
        this.writeMeta(docWriter, "subject", configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Subject"));
        this.writeMeta(docWriter, "author", configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Author"));
        this.writeMeta(docWriter, "keywords", configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Keywords"));
        this.writeMeta(docWriter, "generator", GENERATOR);
        AttributeList metaAttrs = new AttributeList();
        metaAttrs.setAttribute(XHTML_NAMESPACE, "http-equiv", "content-type");
        metaAttrs.setAttribute(XHTML_NAMESPACE, "content", "text/html; charset=" + encoding);
        docWriter.writeTag(XHTML_NAMESPACE, "meta", metaAttrs, true);
        if (styleSheetUrl != null) {
            AttributeList attrList = new AttributeList();
            attrList.setAttribute(XHTML_NAMESPACE, "type", "text/css");
            attrList.setAttribute(XHTML_NAMESPACE, "rel", "stylesheet");
            attrList.setAttribute(XHTML_NAMESPACE, "href", styleSheetUrl);
            docWriter.writeTag(XHTML_NAMESPACE, "link", attrList, true);
        } else if (inlineStyleSheet != null) {
            docWriter.writeTag(XHTML_NAMESPACE, "style", "type", "text/css", false);
            StringWriter writer = new StringWriter();
            inlineStyleSheet.write(writer);
            docWriter.writeText(writer.toString());
            docWriter.writeCloseTag();
        }
        Object rawHeaderContent = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-header-content");
        if (rawHeaderContent != null) {
            docWriter.writeText(String.valueOf(rawHeaderContent));
        }
        docWriter.writeCloseTag();
    }

    private void writeMeta(XmlWriter writer, String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        AttributeList attrList = new AttributeList();
        attrList.setAttribute(XHTML_NAMESPACE, "name", name);
        attrList.setAttribute(XHTML_NAMESPACE, "content", value);
        writer.writeTag(XHTML_NAMESPACE, "meta", attrList, true);
    }

    protected StyleManager createStyleManager() {
        if (!this.isCreateBodyFragment() && !this.isInlineStylesRequested()) {
            return new GlobalStyleManager();
        }
        return new InlineStyleManager();
    }

    protected boolean isCreateBodyFragment() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.BodyFragment", "false"));
    }

    protected boolean isInlineStylesRequested() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.InlineStyles"));
    }

    protected void generateHeaderOnOpen(ReportAttributeMap attributeMap, String sheetName, XmlWriter xmlWriter) throws IOException {
        if (!this.isCreateBodyFragment()) {
            if (this.isInlineStylesRequested()) {
                this.writeCompleteHeader(xmlWriter, sheetName, attributeMap, null, null);
            } else if (this.isExternalStyleSheetRequested() && !this.isForceBufferedWriting()) {
                this.writeCompleteHeader(xmlWriter, sheetName, attributeMap, this.styleFileUrl, null);
            }
            xmlWriter.writeTag(XHTML_NAMESPACE, "body", false);
        }
    }

    protected void generateExternalStylePlaceHolder() throws ContentIOException, URLRewriteException {
        if (!this.isExternalStyleSheetRequested()) {
            return;
        }
        this.styleFile = this.getContentGenerator().createItem("style", "text/css");
        this.styleFileUrl = this.getContentReWriteService().rewriteContentDataItem(this.styleFile);
    }

    public ContentItem getStyleFile() {
        return this.styleFile;
    }

    public String getStyleFileUrl() {
        return this.styleFileUrl;
    }

    protected WriterService createWriterService(OutputStream out) throws UnsupportedEncodingException {
        String encoding = this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
        if (!this.isCreateBodyFragment()) {
            if (this.isInlineStylesRequested()) {
                return WriterService.createPassThroughService(out, encoding);
            }
            if (this.isExternalStyleSheetRequested() && !this.isForceBufferedWriting()) {
                return WriterService.createPassThroughService(out, encoding);
            }
            return WriterService.createBufferedService(out, encoding);
        }
        return WriterService.createPassThroughService(out, encoding);
    }

    protected boolean isForceBufferedWriting() {
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ForceBufferedWriting"));
    }

    protected boolean isExternalStyleSheetRequested() {
        if (this.isCreateBodyFragment()) {
            return false;
        }
        if (this.isInlineStylesRequested()) {
            return false;
        }
        if (!this.getContentGenerator().isExternalContentAvailable()) {
            return false;
        }
        return "true".equals(this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ExternalStyle", "true"));
    }

    protected void performCloseFile(String sheetName, ReportAttributeMap logicalPageBox, WriterService writer) throws IOException, ContentIOException {
        XmlWriter xmlWriter = writer.getXmlWriter();
        xmlWriter.writeCloseTag();
        Object rawFooterContent = logicalPageBox.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content");
        if (rawFooterContent != null) {
            xmlWriter.writeText(String.valueOf(rawFooterContent));
        }
        if (this.isCreateBodyFragment()) {
            xmlWriter.close();
            return;
        }
        ContentItem styleFile = this.getStyleFile();
        if (styleFile != null) {
            String encoding = this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
            OutputStreamWriter styleOut = new OutputStreamWriter((OutputStream)new BufferedOutputStream(styleFile.getOutputStream()), encoding);
            this.getStyleManager().write(styleOut);
            ((Writer)styleOut).flush();
            ((Writer)styleOut).close();
            if (!this.isForceBufferedWriting()) {
                xmlWriter.writeCloseTag();
                xmlWriter.writeCloseTag();
                xmlWriter.close();
                return;
            }
        }
        if (this.isInlineStylesRequested()) {
            xmlWriter.writeCloseTag();
            xmlWriter.writeCloseTag();
            xmlWriter.close();
            return;
        }
        xmlWriter.writeCloseTag();
        xmlWriter.flush();
        XmlWriter docWriter = writer.createHeaderXmlWriter();
        if (styleFile != null) {
            this.writeCompleteHeader(docWriter, sheetName, logicalPageBox, this.getStyleFileUrl(), null);
        } else {
            this.writeCompleteHeader(docWriter, sheetName, logicalPageBox, null, this.getStyleManager());
        }
        MemoryStringReader stringReader = writer.getBufferWriter().createReader();
        docWriter.writeStream((Reader)stringReader);
        stringReader.close();
        docWriter.writeCloseTag();
        docWriter.close();
    }

    protected void openSheet(ReportAttributeMap logicalPage, String sheetName, OutputProcessorMetaData metaData, SlimSheetLayout sheetLayout, XmlWriter xmlWriter) throws ContentIOException, URLRewriteException, IOException {
        this.setStyleManager(this.createStyleManager());
        this.generateExternalStylePlaceHolder();
        this.generateHeaderOnOpen(logicalPage, sheetName, xmlWriter);
        Object rawContent = logicalPage.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
        if (rawContent != null) {
            xmlWriter.writeText(String.valueOf(rawContent));
        }
        if ("true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.EnableSheetNameProcessing")) && sheetName != null) {
            xmlWriter.writeTag(XHTML_NAMESPACE, "h1", this.getTagHelper().createSheetNameAttributes(), false);
            xmlWriter.writeTextNormalized(sheetName, true);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeTag(XHTML_NAMESPACE, "table", this.getTagHelper().createTableAttributes(sheetLayout, logicalPage), false);
        this.writeColumnDeclaration(sheetLayout, xmlWriter);
    }

    protected void writeBackgroundCell(CellBackground background, XmlWriter xmlWriter) throws IOException {
        boolean emptyCellsUseCSS = this.getTagHelper().isEmptyCellsUseCSS();
        if (background == null) {
            if (emptyCellsUseCSS) {
                xmlWriter.writeTag(XHTML_NAMESPACE, "td", true);
            } else {
                AttributeList attrs = new AttributeList();
                attrs.setAttribute(XHTML_NAMESPACE, "style", "font-size: 1pt");
                xmlWriter.writeTag(XHTML_NAMESPACE, "td", attrs, false);
                xmlWriter.writeText("&nbsp;");
                xmlWriter.writeCloseTag();
            }
            return;
        }
        StyleBuilder styleBuilder = this.getStyleBuilder();
        DefaultStyleBuilderFactory styleBuilderFactory = this.getStyleBuilderFactory();
        String[] anchor = background.getAnchors();
        if (anchor.length == 0 && emptyCellsUseCSS) {
            StyleBuilder cellStyle = styleBuilderFactory.createCellStyle(styleBuilder, null, null, background, null, null);
            AttributeList cellAttributes = this.getTagHelper().createCellAttributes(1, 1, null, null, background, cellStyle);
            xmlWriter.writeTag(XHTML_NAMESPACE, "td", cellAttributes, true);
        } else {
            StyleBuilder cellStyle = styleBuilderFactory.createCellStyle(styleBuilder, null, null, background, HtmlPrinter.EMPTY_CELL_ATTRNAMES, HtmlPrinter.EMPTY_CELL_ATTRVALS);
            AttributeList cellAttributes = this.getTagHelper().createCellAttributes(1, 1, null, null, background, cellStyle);
            xmlWriter.writeTag(XHTML_NAMESPACE, "td", cellAttributes, false);
            for (int i = 0; i < anchor.length; ++i) {
                xmlWriter.writeTag(XHTML_NAMESPACE, "a", "name", anchor[i], true);
            }
            xmlWriter.writeText("&nbsp;");
            xmlWriter.writeCloseTag();
        }
    }
}

