/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.AbstractReportProcessTask;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FlowHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.SingleRepositoryURLRewriter;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public class ZipHtmlReportProcessTask
extends AbstractReportProcessTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isValid()) {
            this.setError(new ReportProcessingException("Error: The task is not configured properly."));
            return;
        }
        this.setError(null);
        try {
            MasterReport report = this.getReport();
            ContentLocation contentLocation = this.getBodyContentLocation();
            NameGenerator nameGenerator = this.getBodyNameGenerator();
            ContentItem contentItem = contentLocation.createItem(nameGenerator.generateName(null, "application/zip"));
            try (OutputStream out = contentItem.getOutputStream();
                 ZipRepository zipRepository = new ZipRepository(out);){
                ContentLocation root = zipRepository.getRoot();
                ContentLocation data = RepositoryUtilities.createLocation((Repository)zipRepository, (String[])RepositoryUtilities.splitPath((String)"data", (String)"/"));
                FlowHtmlOutputProcessor outputProcessor = new FlowHtmlOutputProcessor();
                AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
                printer.setContentWriter(root, (NameGenerator)new DefaultNameGenerator(root, "report"));
                printer.setDataWriter(data, (NameGenerator)new DefaultNameGenerator(data, "content"));
                printer.setUrlRewriter(new SingleRepositoryURLRewriter());
                outputProcessor.setPrinter(printer);
                try (FlowReportProcessor sp = new FlowReportProcessor(report, outputProcessor);){
                    ReportProgressListener[] progressListeners = this.getReportProgressListeners();
                    for (int i = 0; i < progressListeners.length; ++i) {
                        ReportProgressListener listener = progressListeners[i];
                        sp.addReportProgressListener(listener);
                    }
                    sp.processReport();
                }
            }
        }
        catch (Throwable e) {
            this.setError(e);
        }
    }

    @Override
    public String getReportMimeType() {
        return "application/zip";
    }
}

