/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.xls;

import java.awt.Color;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelFontFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.HSSFFontWrapper;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.RichTextFormat;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class FastExcelTextExtractor
extends FastTextExtractor {
    private static final Log logger = LogFactory.getLog(FastExcelTextExtractor.class);
    private final ExcelFontFactory fontFactory;
    private final CreationHelper creationHelper;
    private final ArrayList<RichTextFormat> formatBuffer;
    private final ExcelColorProducer colorProducer;
    private final FastStack<RichTextFormat> formatBufferStack;

    public FastExcelTextExtractor(ExcelColorProducer colorProducer, ExcelFontFactory fontFactory, CreationHelper creationHelper) {
        this.colorProducer = colorProducer;
        this.formatBuffer = new ArrayList();
        this.fontFactory = fontFactory;
        this.creationHelper = creationHelper;
        this.formatBufferStack = new FastStack();
    }

    @Override
    public Object compute(ReportElement content, ExpressionRuntime runtime) throws ContentProcessingException {
        this.formatBuffer.clear();
        super.compute(content, runtime);
        if (this.formatBuffer.size() <= 1) {
            Object rawResult = this.getRawResult();
            if (rawResult != null && !(rawResult instanceof String)) {
                return rawResult;
            }
            String text = this.getText();
            if (text.length() > Short.MAX_VALUE) {
                logger.warn((Object)"Excel-Cells cannot contain text larger than 32.737 characters. Text will be clipped.");
                return text.substring(0, Short.MAX_VALUE);
            }
            if (text.length() > 0) {
                return text;
            }
            return null;
        }
        String text = this.getText();
        return ExcelTextExtractor.computeRichText(this.fontFactory, this.creationHelper, text, this.formatBuffer);
    }

    @Override
    protected boolean inspectStartSection(ReportElement box, boolean inlineSection) {
        SimpleStyleSheet styleSheet = box.getComputedStyle();
        if (!styleSheet.getBooleanStyleProperty(ElementStyleKeys.VISIBLE)) {
            return false;
        }
        Color textColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT);
        HSSFFontWrapper wrapper = new HSSFFontWrapper(styleSheet, this.colorProducer.getNearestColor(textColor));
        RichTextFormat rtf = new RichTextFormat(this.getTextLength(), wrapper);
        if (this.formatBuffer.isEmpty()) {
            this.formatBuffer.add(rtf);
        } else {
            int lastIndex = this.formatBuffer.size() - 1;
            RichTextFormat lastRtf = this.formatBuffer.get(lastIndex);
            if (lastRtf.getPosition() == rtf.getPosition()) {
                this.formatBuffer.set(lastIndex, rtf);
            } else if (!lastRtf.getFont().equals(rtf.getFont())) {
                this.formatBuffer.add(rtf);
            }
        }
        this.formatBufferStack.push((Object)rtf);
        return true;
    }

    @Override
    protected void handleValueContent(ReportElement element, Object value, boolean inlineSection) throws ContentProcessingException {
        super.handleValueContent(element, value, inlineSection);
    }

    @Override
    protected void inspectEndSection(ReportElement box, boolean inlineSection) {
        this.formatBufferStack.pop();
        if (this.formatBufferStack.isEmpty()) {
            return;
        }
        RichTextFormat rtf = (RichTextFormat)this.formatBufferStack.peek();
        RichTextFormat lastRtf = this.formatBuffer.get(this.formatBuffer.size() - 1);
        if (!lastRtf.getFont().equals(rtf.getFont())) {
            this.formatBuffer.add(new RichTextFormat(this.getTextLength(), rtf.getFont()));
        }
    }
}

