/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.survey;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.modules.misc.survey.SurveyScale;
import org.pentaho.reporting.engine.classic.core.modules.misc.survey.SurveyScaleShapeType;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public class SurveyScaleExpression
extends AbstractExpression {
    private int lowest;
    private int highest;
    private ArrayList<String> fieldList;
    private String rangeLowerBoundField;
    private String rangeUpperBoundField;
    private transient Shape overrideShape;
    private boolean overrideShapeFilled;
    private Font scaleValueFont;
    private Color scaleValuePaint;
    private Color rangeColor;
    private Color fillPaint;
    private Color tickMarkPaint;
    private boolean autoConfigure;
    private double upperMargin;
    private double lowerMargin;
    private ArrayList<Boolean> fillShapes = new ArrayList();
    private boolean drawTickMarks;
    private boolean drawScaleValues;
    private ArrayList<SurveyScaleShapeType> shapes = new ArrayList();
    private SurveyScaleShapeType defaultShape;
    private transient BasicStroke outlineStroke;

    public SurveyScaleExpression() {
        this(0, 1);
    }

    public SurveyScaleExpression(int lowest, int highest) {
        this(lowest, highest, null, null, null);
    }

    public SurveyScaleExpression(int lowest, int highest, String lowerBoundsField, String upperBoundsField, Shape shape) {
        this.lowest = lowest;
        this.highest = highest;
        this.fieldList = new ArrayList();
        this.overrideShape = shape;
        this.overrideShapeFilled = false;
        this.rangeLowerBoundField = lowerBoundsField;
        this.rangeUpperBoundField = upperBoundsField;
        this.rangeColor = Color.lightGray;
        this.tickMarkPaint = Color.gray;
        this.scaleValuePaint = Color.black;
        this.upperMargin = 0.1;
        this.lowerMargin = 0.1;
        this.defaultShape = SurveyScaleShapeType.DownTriangle;
        this.outlineStroke = new BasicStroke(0.5f);
        this.fillPaint = Color.BLACK;
    }

    public SurveyScaleShapeType getDefaultShape() {
        return this.defaultShape;
    }

    public void setDefaultShape(SurveyScaleShapeType defaultShape) {
        this.defaultShape = defaultShape;
    }

    public void setFillShapes(int index, boolean fill) {
        if (this.fillShapes.size() == index) {
            this.fillShapes.add(fill);
        } else {
            this.fillShapes.set(index, fill);
        }
    }

    public boolean getFillShapes(int index) {
        return this.fillShapes.get(index);
    }

    public int getFillShapesCount() {
        return this.fillShapes.size();
    }

    public boolean[] getFillShapes() {
        boolean[] retval = new boolean[this.fillShapes.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = Boolean.TRUE.equals(this.fillShapes.get(i));
        }
        return retval;
    }

    public void setFillShapes(boolean[] fields) {
        this.fillShapes.clear();
        for (int i = 0; i < fields.length; ++i) {
            this.fillShapes.add(fields[i]);
        }
    }

    public void setShapes(int index, SurveyScaleShapeType fill) {
        if (this.shapes.size() == index) {
            this.shapes.add(fill);
        } else {
            this.shapes.set(index, fill);
        }
    }

    public SurveyScaleShapeType getShapes(int index) {
        return this.shapes.get(index);
    }

    public int getShapesCount() {
        return this.shapes.size();
    }

    public SurveyScaleShapeType[] getShapes() {
        SurveyScaleShapeType[] retval = new SurveyScaleShapeType[this.shapes.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = this.shapes.get(i);
        }
        return retval;
    }

    public void setShapes(SurveyScaleShapeType[] fields) {
        this.shapes.clear();
        for (int i = 0; i < fields.length; ++i) {
            this.shapes.add(fields[i]);
        }
    }

    public boolean isAutoConfigure() {
        return this.autoConfigure;
    }

    public void setAutoConfigure(boolean autoConfigure) {
        this.autoConfigure = autoConfigure;
    }

    public String getRangeLowerBoundField() {
        return this.rangeLowerBoundField;
    }

    public void setRangeLowerBoundField(String field) {
        this.rangeLowerBoundField = field;
    }

    public String getRangeUpperBoundField() {
        return this.rangeUpperBoundField;
    }

    public void setRangeUpperBoundField(String field) {
        this.rangeUpperBoundField = field;
    }

    public Shape getOverrideShape() {
        return this.overrideShape;
    }

    public void setOverrideShape(Shape shape) {
        this.overrideShape = shape;
    }

    public boolean isOverrideShapeFilled() {
        return this.overrideShapeFilled;
    }

    public void setOverrideShapeFilled(boolean b) {
        this.overrideShapeFilled = b;
    }

    public int getLowest() {
        return this.lowest;
    }

    public void setLowest(int lowest) {
        this.lowest = lowest;
    }

    public int getHighest() {
        return this.highest;
    }

    public void setHighest(int highest) {
        this.highest = highest;
    }

    public Font getScaleValueFont() {
        return this.scaleValueFont;
    }

    public void setScaleValueFont(Font scaleValueFont) {
        this.scaleValueFont = scaleValueFont;
    }

    public Color getScaleValuePaint() {
        return this.scaleValuePaint;
    }

    public void setScaleValuePaint(Color scaleValuePaint) {
        this.scaleValuePaint = scaleValuePaint;
    }

    public Color getRangeColor() {
        return this.rangeColor;
    }

    public void setRangeColor(Color rangeColor) {
        this.rangeColor = rangeColor;
    }

    public Color getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Color fillPaint) {
        this.fillPaint = fillPaint;
    }

    public Color getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Color tickMarkPaint) {
        this.tickMarkPaint = tickMarkPaint;
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double upperMargin) {
        this.upperMargin = upperMargin;
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double lowerMargin) {
        this.lowerMargin = lowerMargin;
    }

    public boolean isDrawTickMarks() {
        return this.drawTickMarks;
    }

    public void setDrawTickMarks(boolean drawTickMarks) {
        this.drawTickMarks = drawTickMarks;
    }

    public boolean isDrawScaleValues() {
        return this.drawScaleValues;
    }

    public void setDrawScaleValues(boolean drawScaleValues) {
        this.drawScaleValues = drawScaleValues;
    }

    public BasicStroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(BasicStroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    @Override
    public Object getValue() {
        SurveyScale result = new SurveyScale(this.lowest, this.highest, this.collectValues());
        if (this.rangeLowerBoundField != null && this.rangeUpperBoundField != null) {
            DataRow dataRow = this.getDataRow();
            Object b0 = dataRow.get(this.rangeLowerBoundField);
            Object b1 = dataRow.get(this.rangeUpperBoundField);
            if (b0 instanceof Number) {
                result.setRangeLowerBound((Number)b0);
            }
            if (b1 instanceof Number) {
                result.setRangeUpperBound((Number)b1);
            }
        }
        result.setRangePaint(this.rangeColor);
        result.setTickMarkPaint(this.tickMarkPaint);
        result.setFillPaint(this.fillPaint);
        result.setScaleValueFont(this.scaleValueFont);
        result.setScaleValuePaint(this.scaleValuePaint);
        result.setUpperMargin(this.upperMargin);
        result.setLowerMargin(this.lowerMargin);
        result.setDrawScaleValues(this.drawScaleValues);
        result.setDrawTickMarks(this.drawTickMarks);
        result.setDefaultShape(this.defaultShape);
        if (this.overrideShape != null) {
            result.setShape(0, this.overrideShape);
            result.setShapeFilled(0, this.overrideShapeFilled);
        }
        for (int i = 0; i < this.fillShapes.size(); ++i) {
            Boolean fill = this.fillShapes.get(i);
            result.setShapeFilled(i, Boolean.TRUE.equals(fill));
        }
        return result;
    }

    private Number[] collectValues() {
        Number[] retval = new Number[this.fieldList.size()];
        for (int i = 0; i < this.fieldList.size(); ++i) {
            String field = this.fieldList.get(i);
            retval[i] = (Number)this.getDataRow().get(field);
        }
        return retval;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SurveyScaleExpression fva = (SurveyScaleExpression)super.clone();
        fva.fieldList = (ArrayList)this.fieldList.clone();
        fva.fillShapes = (ArrayList)this.fillShapes.clone();
        fva.shapes = (ArrayList)this.shapes.clone();
        return fva;
    }

    public String[] getField() {
        return this.fieldList.toArray(new String[this.fieldList.size()]);
    }

    public void setField(String[] fields) {
        this.fieldList.clear();
        this.fieldList.addAll(Arrays.asList(fields));
    }

    public String getField(int idx) {
        return this.fieldList.get(idx);
    }

    public void setField(int index, String field) {
        if (this.fieldList.size() == index) {
            this.fieldList.add(field);
        } else {
            this.fieldList.set(index, field);
        }
    }

    @Deprecated
    public Paint getRangePaint() {
        return this.rangeColor;
    }

    @Deprecated
    public void setRangePaint(Paint rangePaint) {
        if (rangePaint == null) {
            throw new NullPointerException();
        }
        if (rangePaint instanceof Color) {
            this.rangeColor = (Color)rangePaint;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper helper = SerializerHelper.getInstance();
        helper.writeObject((Object)this.outlineStroke, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializerHelper helper = SerializerHelper.getInstance();
        this.outlineStroke = (BasicStroke)helper.readObject(in);
    }
}

