/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.metadata.builder.StyleMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeGroup;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleGroup;

public class GlobalMetaDefinition
implements Cloneable {
    private LinkedHashMap<String, StyleGroup> styleGroups = new LinkedHashMap();
    private LinkedHashMap<String, AttributeGroup> attributeGroups = new LinkedHashMap();

    public void addAttributeGroup(AttributeGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        this.attributeGroups.put(group.getName(), group);
    }

    public void addStyleGroup(StyleGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        this.styleGroups.put(group.getName(), group);
    }

    public StyleGroup getStyleGroup(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.styleGroups.get(name);
    }

    public AttributeGroup getAttributeGroup(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributeGroups.get(name);
    }

    public Object clone() throws CloneNotSupportedException {
        GlobalMetaDefinition definition = (GlobalMetaDefinition)super.clone();
        definition.styleGroups = (LinkedHashMap)this.styleGroups.clone();
        definition.attributeGroups = (LinkedHashMap)this.attributeGroups.clone();
        return definition;
    }

    public void merge(GlobalMetaDefinition definition) {
        if (definition == null) {
            throw new NullPointerException();
        }
        this.mergeStyles(definition);
        for (Map.Entry<String, AttributeGroup> entry : definition.attributeGroups.entrySet()) {
            AttributeGroup styleGroup = this.attributeGroups.get(entry.getKey());
            if (styleGroup == null) {
                this.addAttributeGroup(entry.getValue());
                continue;
            }
            AttributeGroup entryGroup = entry.getValue();
            String name = styleGroup.getName();
            LinkedHashMap<String, AttributeDefinition> styles = new LinkedHashMap<String, AttributeDefinition>();
            for (AttributeDefinition handler : styleGroup.getMetaData()) {
                styles.put(handler.getName(), handler);
            }
            for (AttributeDefinition handler : entryGroup.getMetaData()) {
                styles.put(handler.getName(), handler);
            }
            this.addAttributeGroup(new AttributeGroup(name, styles.values().toArray(new AttributeDefinition[styles.size()])));
        }
    }

    private void mergeStyles(GlobalMetaDefinition definition) {
        for (Map.Entry<String, StyleGroup> entry : definition.styleGroups.entrySet()) {
            StyleGroup styleGroup = this.styleGroups.get(entry.getKey());
            if (styleGroup == null) {
                this.addStyleGroup(entry.getValue());
                continue;
            }
            LinkedHashMap<String, StyleMetaDataBuilder> styles = new LinkedHashMap<String, StyleMetaDataBuilder>();
            for (StyleMetaDataBuilder handler : styleGroup.getMetaData()) {
                styles.put(handler.getName(), handler);
            }
            for (StyleMetaDataBuilder handler : entry.getValue().getMetaData()) {
                styles.put(handler.getName(), handler);
            }
            this.addStyleGroup(new StyleGroup(styleGroup.getName(), styles.values()));
        }
    }
}

