/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.designtime.DataSourcePlugin;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.ResourceReference;
import org.pentaho.reporting.engine.classic.core.metadata.builder.DataFactoryMetaDataBuilder;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultDataFactoryMetaData
extends AbstractMetaData
implements DataFactoryMetaData {
    private static final Log logger = LogFactory.getLog(DefaultDataFactoryMetaData.class);
    private Class<?> editorClass;
    private boolean editable;
    private boolean freeformQuery;
    private boolean formattingMetadataSource;
    private DataFactoryCore dataFactoryCore;

    @Deprecated
    public DefaultDataFactoryMetaData(String dataFactory, String bundleLocation, String keyPrefix, boolean expert, boolean preferred, boolean hidden, boolean deprecated, boolean editable, boolean freeformQuery, boolean formattingMetadataSource, boolean experimental, DataFactoryCore dataFactoryCore, int compatibilityLevel) {
        this(dataFactory, bundleLocation, keyPrefix, expert, preferred, hidden, deprecated, editable, freeformQuery, formattingMetadataSource, experimental ? MaturityLevel.Development : MaturityLevel.Production, dataFactoryCore, compatibilityLevel);
    }

    public DefaultDataFactoryMetaData(String dataFactory, String bundleLocation, String keyPrefix, boolean expert, boolean preferred, boolean hidden, boolean deprecated, boolean editable, boolean freeformQuery, boolean formattingMetadataSource, MaturityLevel maturityLevel, DataFactoryCore dataFactoryCore, int compatibilityLevel) {
        super(dataFactory, bundleLocation, keyPrefix, expert, preferred, hidden, deprecated, maturityLevel, compatibilityLevel);
        if (dataFactoryCore == null) {
            throw new NullPointerException();
        }
        this.editable = editable;
        this.freeformQuery = freeformQuery;
        this.formattingMetadataSource = formattingMetadataSource;
        this.dataFactoryCore = dataFactoryCore;
    }

    public DefaultDataFactoryMetaData(DataFactoryMetaDataBuilder builder) {
        super(builder);
        this.editable = builder.isEditable();
        this.freeformQuery = builder.isFreeformQuery();
        this.formattingMetadataSource = builder.isFormattingMetadataSource();
        this.dataFactoryCore = builder.getDataFactoryCore();
        this.editorClass = builder.getEditorClass();
        if (this.dataFactoryCore == null) {
            throw new NullPointerException();
        }
    }

    @Override
    protected String computePrefix(String keyPrefix, String name) {
        if (StringUtils.isEmpty((String)keyPrefix)) {
            return "";
        }
        return super.computePrefix(keyPrefix, name);
    }

    @Override
    public String[] getReferencedFields(DataFactory element, String queryName, DataRow parameter) {
        return this.dataFactoryCore.getReferencedFields(this, element, queryName, parameter);
    }

    @Override
    public ResourceReference[] getReferencedResources(DataFactory element, ResourceManager resourceManager, String queryName, DataRow parameter) {
        return this.dataFactoryCore.getReferencedResources(this, element, resourceManager, queryName, parameter);
    }

    @Override
    public boolean isEditable() {
        return this.editable && this.ensureEditorAvailable();
    }

    @Override
    public boolean isEditorAvailable() {
        return this.ensureEditorAvailable();
    }

    @Override
    public DataSourcePlugin createEditor() {
        if (!this.ensureEditorAvailable()) {
            return null;
        }
        if (this.editorClass == null) {
            return null;
        }
        try {
            return (DataSourcePlugin)this.editorClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean ensureEditorAvailable() {
        Configuration configuration;
        String className;
        if (this.editorClass == null && (className = (configuration = ClassicEngineBoot.getInstance().getGlobalConfig()).getConfigProperty(this.getEditorConfigurationKey())) != null) {
            try {
                ClassLoader loader = ObjectUtilities.getClassLoader(DefaultDataFactoryMetaData.class);
                Class<?> maybeClass = Class.forName(className, false, loader);
                if (DataSourcePlugin.class.isAssignableFrom(maybeClass)) {
                    this.editorClass = maybeClass;
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("Editor class " + className + " cannot be found."), (Throwable)e);
                return false;
            }
        }
        return this.editorClass != null;
    }

    protected String getEditorConfigurationKey() {
        return "org.pentaho.reporting.engine.classic.metadata.datafactory-editor." + this.getName();
    }

    @Override
    public boolean isFreeFormQuery() {
        return this.freeformQuery;
    }

    @Override
    public boolean isFormattingMetaDataSource() {
        return this.formattingMetadataSource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultDataFactoryMetaData");
        sb.append("{editorClass=").append(this.editorClass);
        sb.append(", editable=").append(this.editable);
        sb.append(", freeformQuery=").append(this.freeformQuery);
        sb.append(", formattingMetadataSource=").append(this.formattingMetadataSource);
        sb.append(", super=").append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getDisplayConnectionName(DataFactory dataFactory) {
        return this.dataFactoryCore.getDisplayConnectionName(this, dataFactory);
    }

    @Override
    public Object getQueryHash(DataFactory dataFactory, String queryName, DataRow parameter) {
        return this.dataFactoryCore.getQueryHash(this, dataFactory, queryName, parameter);
    }
}

