/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.text;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.text.LineBreakIterator;

public class WordBreakingLineIterator
extends LineBreakIterator {
    private static final float INFINITY = 1.0E7f;
    private final BreakIterator wordInstance = BreakIterator.getWordInstance();

    public WordBreakingLineIterator(ParagraphRenderBox box, FontRenderContext fontRenderContext, AttributedCharacterIterator ci, String text) {
        super(box, fontRenderContext, ci);
        this.wordInstance.setText(text);
    }

    @Override
    protected TextLayout postProcess(int start, TextLayout textLayout, LineBreakMeasurer lineBreakMeasurer) {
        int end = lineBreakMeasurer.getPosition();
        TextLayout layout = this.performWordBreak(start, textLayout, lineBreakMeasurer, end);
        return super.postProcess(start, layout, lineBreakMeasurer);
    }

    private TextLayout performWordBreak(int start, TextLayout textLayout, LineBreakMeasurer lineBreakMeasurer, int end) {
        if (this.wordInstance.isBoundary(end)) {
            return textLayout;
        }
        int preceding = this.wordInstance.preceding(end);
        if (preceding == start) {
            lineBreakMeasurer.setPosition(start);
            return lineBreakMeasurer.nextLayout(1.0E7f, this.wordInstance.following(end), false);
        }
        lineBreakMeasurer.setPosition(start);
        return lineBreakMeasurer.nextLayout(1.0E7f, preceding, false);
    }
}

