/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.FontSmooth;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ImageUtils;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.encoder.ImageEncoder;
import org.pentaho.reporting.libraries.base.encoder.ImageEncoderRegistry;
import org.pentaho.reporting.libraries.base.encoder.UnsupportedEncoderException;
import org.pentaho.reporting.libraries.base.util.MemoryByteArrayOutputStream;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class RenderUtility {
    private static final Log logger = LogFactory.getLog(RenderUtility.class);

    private RenderUtility() {
    }

    public static String getEncoderType(ReportAttributeMap attributes) {
        Object attribute = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "image-encoding-type");
        if (attribute == null) {
            return "image/png";
        }
        String encoder = String.valueOf(attribute);
        if (ImageEncoderRegistry.getInstance().isEncoderAvailable(encoder)) {
            return encoder;
        }
        return "image/png";
    }

    public static float getEncoderQuality(ReportAttributeMap attributeMap) {
        Object attribute = attributeMap.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "image-encoding-quality");
        if (attribute == null) {
            return 0.9f;
        }
        if (attribute instanceof Number) {
            Number n = (Number)attribute;
            float v = n.floatValue();
            if ((double)v < 0.01) {
                return 0.01f;
            }
            if ((double)v > 0.999) {
                return 0.999f;
            }
            return v;
        }
        return 0.9f;
    }

    public static boolean isFontSmooth(StyleSheet styleSheet, OutputProcessorMetaData metaData) {
        double fontSize = styleSheet.getDoubleStyleProperty(TextStyleKeys.FONTSIZE, metaData.getNumericFeatureValue(OutputProcessorFeature.DEFAULT_FONT_SIZE));
        FontSmooth smoothing = (FontSmooth)styleSheet.getStyleProperty(TextStyleKeys.FONT_SMOOTH);
        boolean antiAliasing = FontSmooth.NEVER.equals(smoothing) ? false : !FontSmooth.AUTO.equals(smoothing) || !(fontSize <= metaData.getNumericFeatureValue(OutputProcessorFeature.FONT_SMOOTH_THRESHOLD));
        return antiAliasing;
    }

    public static byte[] encodeImage(Image image) throws UnsupportedEncoderException, IOException {
        return RenderUtility.encodeImage(image, "image/png", 0.9f, true);
    }

    public static byte[] encodeImage(Image image, String mimeType, float quality, boolean alpha) throws UnsupportedEncoderException, IOException {
        MemoryByteArrayOutputStream byteOut = new MemoryByteArrayOutputStream(65536, 131072);
        RenderUtility.encodeImage((OutputStream)byteOut, image, mimeType, quality, alpha);
        return byteOut.toByteArray();
    }

    public static void encodeImage(OutputStream outputStream, Image image, String mimeType, float quality, boolean alpha) throws UnsupportedEncoderException, IOException {
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        ImageEncoder imageEncoder = ImageEncoderRegistry.getInstance().createEncoder(mimeType);
        if (imageEncoder == null) {
            throw new UnsupportedEncoderException("The encoder for mime-type '" + mimeType + "' is not available");
        }
        imageEncoder.encodeImage(image, outputStream, quality, alpha);
    }

    public static Image scaleImage(Image img, int targetWidth, int targetHeight, Object hintValue, boolean higherQuality) {
        int h;
        int w;
        int type = 2;
        Image ret = img;
        do {
            Graphics2D g2;
            BufferedImage tmp;
            block5: {
                block4: {
                    if (higherQuality) {
                        int imageWidth = ret.getWidth(null);
                        int imageHeight = ret.getHeight(null);
                        w = imageWidth < targetWidth ? Math.min(imageWidth << 1, targetWidth) : (imageWidth > targetWidth ? Math.max(imageWidth >> 1, targetWidth) : imageWidth);
                        h = imageHeight < targetHeight ? Math.min(imageHeight << 1, targetHeight) : (imageHeight > targetHeight ? Math.max(imageHeight >> 1, targetHeight) : imageHeight);
                    } else {
                        w = targetWidth;
                        h = targetHeight;
                    }
                    tmp = new BufferedImage(w, h, 2);
                    g2 = tmp.createGraphics();
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hintValue);
                    if (!(ret instanceof BufferedImage)) break block4;
                    if (g2.drawImage(ret, 0, 0, w, h, null)) break block5;
                    logger.debug((Object)"Failed to scale the image. This should not happen.");
                    break block5;
                }
                WaitingImageObserver obs = new WaitingImageObserver(ret);
                while (!g2.drawImage(ret, 0, 0, w, h, null)) {
                    obs.waitImageLoaded();
                    if (!obs.isError()) continue;
                    logger.warn((Object)"Error while loading the image during the rendering.");
                    break;
                }
            }
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public static double getNormalizationScale(OutputProcessorMetaData metaData) {
        double devResolution = metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
        double scale = metaData.isFeatureSupported(OutputProcessorFeature.IMAGE_RESOLUTION_MAPPING) && devResolution > 0.0 ? devResolution / 72.0 : 1.0;
        return scale;
    }

    public static ImageContainer createImageFromDrawable(DrawableWrapper drawable, StrictBounds rect, RenderNode box, OutputProcessorMetaData metaData) {
        return RenderUtility.createImageFromDrawable(drawable, rect, box.getStyleSheet(), metaData);
    }

    public static DefaultImageReference createImageFromDrawable(DrawableWrapper drawable, StrictBounds rect, StyleSheet box, OutputProcessorMetaData metaData) {
        int imageWidth = (int)StrictGeomUtility.toExternalValue(rect.getWidth());
        int imageHeight = (int)StrictGeomUtility.toExternalValue(rect.getHeight());
        if (imageWidth == 0 || imageHeight == 0) {
            return null;
        }
        double scale = RenderUtility.getNormalizationScale(metaData);
        BufferedImage image = ImageUtils.createTransparentImage((int)((double)imageWidth * scale), (int)((double)imageHeight * scale));
        Graphics2D g2 = (Graphics2D)((Image)image).getGraphics();
        Object attribute = box.getStyleProperty(ElementStyleKeys.ANTI_ALIASING);
        if (attribute != null) {
            if (Boolean.TRUE.equals(attribute)) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else if (Boolean.FALSE.equals(attribute)) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        if (RenderUtility.isFontSmooth(box, metaData)) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        g2.scale(scale, scale);
        String fontName = (String)box.getStyleProperty(TextStyleKeys.FONT);
        int fontSize = box.getIntStyleProperty(TextStyleKeys.FONTSIZE, 8);
        boolean bold = box.getBooleanStyleProperty(TextStyleKeys.BOLD);
        boolean italics = box.getBooleanStyleProperty(TextStyleKeys.ITALIC);
        if (bold && italics) {
            g2.setFont(new Font(fontName, 3, fontSize));
        } else if (bold) {
            g2.setFont(new Font(fontName, 1, fontSize));
        } else if (italics) {
            g2.setFont(new Font(fontName, 2, fontSize));
        } else {
            g2.setFont(new Font(fontName, 0, fontSize));
        }
        g2.setStroke((Stroke)box.getStyleProperty(ElementStyleKeys.STROKE));
        g2.setPaint((Paint)box.getStyleProperty(ElementStyleKeys.PAINT));
        drawable.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight));
        g2.dispose();
        try {
            return new DefaultImageReference(image);
        }
        catch (IOException e1) {
            logger.warn((Object)"Unable to fully load a given image. (It should not happen here.)", (Throwable)e1);
            return null;
        }
    }

    public static long computeHorizontalAlignment(ElementAlignment alignment, long width, long imageWidth) {
        if (ElementAlignment.RIGHT.equals(alignment)) {
            return Math.max(0L, width - imageWidth);
        }
        if (ElementAlignment.CENTER.equals(alignment)) {
            return Math.max(0L, (width - imageWidth) / 2L);
        }
        return 0L;
    }

    public static long computeVerticalAlignment(ElementAlignment alignment, long height, long imageHeight) {
        if (ElementAlignment.BOTTOM.equals(alignment)) {
            return Math.max(0L, height - imageHeight);
        }
        if (ElementAlignment.MIDDLE.equals(alignment)) {
            return Math.max(0L, (height - imageHeight) / 2L);
        }
        return 0L;
    }

    @Deprecated
    public static ImageMap extractImageMap(RenderableReplacedContentBox node, DrawableWrapper drawable) {
        return RenderUtility.extractImageMap(drawable, node.getWidth(), node.getHeight());
    }

    private static ImageMap extractImageMap(DrawableWrapper drawable, long width, long height) {
        Object backend = drawable.getBackend();
        if (backend instanceof ReportDrawable) {
            ReportDrawable rdrawable = (ReportDrawable)backend;
            int imageWidth = (int)StrictGeomUtility.toExternalValue(width);
            int imageHeight = (int)StrictGeomUtility.toExternalValue(height);
            if (imageWidth == 0 || imageHeight == 0) {
                return null;
            }
            return rdrawable.getImageMap(new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight));
        }
        return null;
    }

    public static ImageMap extractImageMap(RenderableReplacedContentBox content) {
        ReportAttributeMap<Object> attributes = content.getAttributes();
        Object rawObject = content.getContent().getRawObject();
        return RenderUtility.extractImageMap(attributes, rawObject, content.getWidth(), content.getHeight());
    }

    public static ImageMap extractImageMap(ReportAttributeMap attributes, Object rawObject, long width, long height) {
        Object manualImageMap = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "image-map");
        if (manualImageMap instanceof ImageMap) {
            return (ImageMap)manualImageMap;
        }
        if (rawObject instanceof DrawableWrapper) {
            DrawableWrapper drawable = (DrawableWrapper)rawObject;
            return RenderUtility.extractImageMap(drawable, width, height);
        }
        return null;
    }
}

