/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.IncompatibleFeatureException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.build.RenderNodeFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.AutoRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.BreakMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.SectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinitionFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.style.DefaultStyleCache;
import org.pentaho.reporting.engine.classic.core.layout.style.ManualBreakIndicatorStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.NonPaddingStyleCache;
import org.pentaho.reporting.engine.classic.core.layout.style.ParagraphPoolboxStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SectionKeepTogetherStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.StyleCache;
import org.pentaho.reporting.engine.classic.core.layout.style.UseMinChunkWidthStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class DefaultRenderNodeFactory
implements RenderNodeFactory {
    public static final String LAYOUT_PARAGRAPH_LINEBOX = "::paragraph-linebox";
    private static StyleSheet SECTION_DEFAULT_STYLE = new SimpleStyleSheet(new UseMinChunkWidthStyleSheet(true));
    private SimpleStyleSheet bandWithoutKeepTogetherStyle;
    private BoxDefinitionFactory boxDefinitionFactory = new BoxDefinitionFactory();
    private StyleCache bandCache;
    private SimpleStyleSheet manualBreakBoxStyle;
    private boolean strictCompatibilityMode;
    private OutputProcessorMetaData metaData;

    public DefaultRenderNodeFactory() {
        this.bandWithoutKeepTogetherStyle = new SimpleStyleSheet(new SectionKeepTogetherStyleSheet(false));
    }

    @Override
    public void initialize(OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        this.bandCache = new DefaultStyleCache("rnf");
        boolean paddingsDisabled = metaData.isFeatureSupported(OutputProcessorFeature.DISABLE_PADDING);
        if (paddingsDisabled) {
            this.bandCache = new NonPaddingStyleCache(this.bandCache);
        }
        this.strictCompatibilityMode = metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY);
    }

    @Override
    public LogicalPageBox createPage(ReportDefinition report, StyleSheet style) {
        if (report == null) {
            throw new NullPointerException();
        }
        SimpleStyleSheet reportStyle = this.bandCache.getStyleSheet(style);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(reportStyle);
        return new LogicalPageBox(report, reportStyle, boxDefinition);
    }

    @Override
    public RenderBox produceSectionBox(String layoutType, ReportStateKey stateKey) {
        if (this.strictCompatibilityMode) {
            BoxDefinition boxDefinition = BoxDefinition.EMPTY;
            return new SectionRenderBox(this.bandWithoutKeepTogetherStyle, new InstanceID(), boxDefinition, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.emptyMap(), stateKey);
        }
        RenderBox renderBox = this.createBox(layoutType, stateKey, SECTION_DEFAULT_STYLE, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.emptyMap(), new InstanceID());
        renderBox.getStaticBoxLayoutProperties().setPlaceholderBox(StaticBoxLayoutProperties.PlaceholderType.SECTION);
        renderBox.getStaticBoxLayoutProperties().setSectionContext(true);
        return renderBox;
    }

    @Override
    public RenderBox produceRenderBox(ReportElement band, StyleSheet style, String layoutType, ReportStateKey stateKey) {
        ElementType elementType = band.getElementType();
        RenderBox box = this.createBox(layoutType, stateKey, style, elementType, band.getAttributes(), band.getObjectID());
        String name = band.getName();
        if (name != null && name.length() != 0 && !name.startsWith("anonymousBand@")) {
            box.setName(name);
        }
        return box;
    }

    private RenderBox createBox(String layoutType, ReportStateKey stateKey, StyleSheet elementStyleSheet, ElementType elementType, ReportAttributeMap attributes, InstanceID objectID) {
        if ("auto".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            return new AutoRenderBox(objectID, stateKey, styleSheet, attributes, elementType);
        }
        if ("block".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new BlockRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if (LAYOUT_PARAGRAPH_LINEBOX.equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(new ParagraphPoolboxStyleSheet(elementStyleSheet));
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new InlineRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if ("inline".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new InlineRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if ("row".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new RowRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if ("table".equals(layoutType)) {
            if (this.strictCompatibilityMode) {
                throw new IncompatibleFeatureException("A report with a legacy mode of pre-4.0 cannot handle table layouts. Migrate your report to version 4.0 or higher.", ClassicEngineBoot.computeVersionId(4, 0, 0));
            }
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new TableRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if ("table-body".equals(layoutType) || "table-header".equals(layoutType) || "table-footer".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new TableSectionRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if ("table-row".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new TableRowRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if ("table-cell".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new TableCellRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if ("table-col".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            return new TableColumnNode(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
        }
        if ("table-col-group".equals(layoutType)) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            return new TableColumnGroupNode(styleSheet, attributes);
        }
        SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
        return new CanvasRenderBox(styleSheet, objectID, boxDefinition, elementType, attributes, stateKey);
    }

    @Override
    @Deprecated
    public RenderBox createAutoParagraph(ReportStateKey stateKey) {
        return new ParagraphRenderBox(SimpleStyleSheet.EMPTY_STYLE, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, stateKey);
    }

    @Override
    public RenderBox createAutoParagraph(ReportElement band, StyleSheet bandStyle, ReportStateKey stateKey) {
        SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(bandStyle);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
        ParagraphRenderBox paragraphBox = new ParagraphRenderBox(styleSheet, band.getObjectID(), boxDefinition, band.getElementType(), band.getAttributes(), stateKey);
        paragraphBox.setName(band.getName());
        return paragraphBox;
    }

    @Override
    public RenderBox produceSubReportPlaceholder(ReportElement report, StyleSheet style, ReportStateKey stateKey) {
        String layout;
        if (this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY)) {
            layout = "block";
        } else {
            layout = (String)style.getStyleProperty(BandStyleKeys.LAYOUT, "block");
            if ("inline".equals(layout)) {
                layout = "block";
            }
        }
        RenderBox box = this.createBox(layout, stateKey, style, report.getElementType(), report.getAttributes(), report.getObjectID());
        box.getStaticBoxLayoutProperties().setPlaceholderBox(StaticBoxLayoutProperties.PlaceholderType.COMPLEX);
        box.markAsContentRefHolder();
        String name = report.getName();
        if (name != null && !name.startsWith("anonymousBand@")) {
            box.setName(name);
        }
        return box;
    }

    @Override
    public BoxDefinition getBoxDefinition(StyleSheet style) {
        return this.boxDefinitionFactory.getBoxDefinition(style);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public StyleSheet createAutoGeneratedSectionStyleSheet(StyleSheet style) {
        return this.bandWithoutKeepTogetherStyle;
    }

    @Override
    public RenderBox createPageBreakIndicatorBox(ReportStateKey stateKey, long range) {
        if (this.manualBreakBoxStyle == null) {
            ManualBreakIndicatorStyleSheet mbis = new ManualBreakIndicatorStyleSheet();
            this.manualBreakBoxStyle = new SimpleStyleSheet(mbis);
        }
        BreakMarkerRenderBox sectionBox = new BreakMarkerRenderBox(this.manualBreakBoxStyle, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, stateKey, range);
        sectionBox.setName("pagebreak");
        sectionBox.close();
        return sectionBox;
    }

    @Override
    public StyleSheet createStyle(StyleSheet style) {
        return this.bandCache.getStyleSheet(style);
    }

    @Override
    public void close() {
        this.bandCache.printPerformanceStats();
    }

    @Override
    public RenderableReplacedContentBox createReplacedContent(ReportElement element, StyleSheet style, Object value, Object rawValue, ReportStateKey stateKey) {
        ResourceKey rawKey = rawValue instanceof ResourceKey ? (ResourceKey)rawValue : null;
        SimpleStyleSheet elementStyle = this.bandCache.getStyleSheet(style);
        RenderableReplacedContent content = new RenderableReplacedContent(elementStyle, value, rawKey, this.metaData);
        BoxDefinition boxDefinition = this.getBoxDefinition(elementStyle);
        RenderableReplacedContentBox child = new RenderableReplacedContentBox(elementStyle, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey, content);
        child.setName(element.getName());
        return child;
    }
}

