/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.imagemap.parser;

import java.util.StringTokenizer;
import org.pentaho.reporting.engine.classic.core.imagemap.AbstractImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.CircleImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.DefaultImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.PolygonImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.RectangleImageMapEntry;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AreaReadHandler
extends AbstractXmlReadHandler {
    private AbstractImageMapEntry mapEntry;
    private static final float[] EMPTY_FLOATS = new float[0];

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String shape = attrs.getValue(this.getUri(), "shape");
        String coordinates = attrs.getValue(this.getUri(), "coords");
        float[] coords = this.parseFloatArray(coordinates);
        this.mapEntry = this.createMapEntry(shape, coords);
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String name;
            if ("xmlns".equals(attrs.getQName(i)) || attrs.getQName(i).startsWith("xmlns:") || (name = attrs.getLocalName(i)).indexOf(58) > -1) continue;
            String namespace = attrs.getURI(i);
            String attributeValue = attrs.getValue(i);
            if (this.isSameNamespace(namespace) && ("shape".equals(name) || "coords".equals(name))) continue;
            this.mapEntry.setAttribute(namespace, name, attributeValue);
        }
    }

    private AbstractImageMapEntry createMapEntry(String type, float[] coordinates) throws ParseException {
        if ("rect".equals(type)) {
            if (coordinates.length != 4) {
                throw new ParseException("Rect-shape needs four coordinate-values", this.getLocator());
            }
            return new RectangleImageMapEntry(coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
        }
        if ("circle".equals(type)) {
            if (coordinates.length != 3) {
                throw new ParseException("Circle-shape needs three coordinate-values", this.getLocator());
            }
            return new CircleImageMapEntry(coordinates[0], coordinates[1], coordinates[2]);
        }
        if ("poly".equals(type)) {
            if (coordinates.length % 2 != 0) {
                throw new ParseException("Polygon-shape needs an even number of coordinate-values", this.getLocator());
            }
            return new PolygonImageMapEntry(coordinates);
        }
        if ("default".equals(type)) {
            return new DefaultImageMapEntry();
        }
        if (coordinates.length != 4) {
            throw new ParseException("Implied Rect-shape needs four coordinate-values", this.getLocator());
        }
        return new RectangleImageMapEntry(coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
    }

    public Object getObject() throws SAXException {
        return this.mapEntry;
    }

    private float[] parseFloatArray(String s) throws ParseException {
        if (StringUtils.isEmpty((String)s)) {
            return EMPTY_FLOATS;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(s, ",");
            float[] ret = new float[stringTokenizer.countTokens()];
            int i = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String val = stringTokenizer.nextToken().trim();
                ret[i] = Float.parseFloat(val);
                ++i;
            }
            return ret;
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Unable to convert array-text to real array.", this.getLocator());
        }
    }
}

