/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;

public abstract class AbstractCompareExpression
extends AbstractExpression {
    public static final String EQUAL = "equal";
    public static final String NOT_EQUAL = "not-equal";
    public static final String LOWER = "lower";
    public static final String GREATER = "greater";
    public static final String LOWER_EQUAL = "lower-equal";
    public static final String GREATER_EQUAL = "greater-equal";
    private String compareMethod;
    private String field;

    protected AbstractCompareExpression() {
    }

    @Override
    public Object getValue() {
        Object o = this.getDataRow().get(this.getField());
        if (!(o instanceof Comparable)) {
            return Boolean.FALSE;
        }
        try {
            int result;
            block21: {
                Comparable c = (Comparable)o;
                Comparable comparable = this.getComparable();
                if (comparable == null) {
                    return Boolean.FALSE;
                }
                try {
                    result = c.compareTo(comparable);
                }
                catch (Exception e) {
                    try {
                        result = -comparable.compareTo(c);
                    }
                    catch (Exception e2) {
                        if (c instanceof Number && comparable instanceof Number) {
                            BigDecimal bd1 = new BigDecimal(String.valueOf(c));
                            BigDecimal bd2 = new BigDecimal(String.valueOf(comparable));
                            result = bd1.compareTo(bd2);
                            break block21;
                        }
                        return Boolean.FALSE;
                    }
                }
            }
            String method = this.getCompareMethod();
            if (EQUAL.equals(method)) {
                if (result == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (NOT_EQUAL.equals(method)) {
                if (result != 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (LOWER.equals(method)) {
                if (result < 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (LOWER_EQUAL.equals(method)) {
                if (result <= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (GREATER.equals(method)) {
                if (result > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (GREATER_EQUAL.equals(method)) {
                if (result >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Boolean.FALSE;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getCompareMethod() {
        return this.compareMethod;
    }

    public void setCompareMethod(String compareMethod) {
        this.compareMethod = compareMethod;
    }

    protected abstract Comparable getComparable();
}

