/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextRotation;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.RotatedTextDrawable;

public interface RotatableText {
    default public Object rotate(ReportElement element, Object value, ExpressionRuntime runtime) {
        Object styleProperty;
        ElementStyleSheet style;
        if (element != null && value != null && RotatableText.isRotationSupported(runtime) && (style = element.getStyle()) != null && (styleProperty = style.getStyleProperty(TextStyleKeys.TEXT_ROTATION, null)) instanceof TextRotation) {
            TextRotation rotation = (TextRotation)styleProperty;
            return new RotatedTextDrawable(String.valueOf(value), rotation);
        }
        return value;
    }

    public static boolean isRotationSupported(ExpressionRuntime runtime) {
        OutputProcessorMetaData outputProcessorMetaData;
        ProcessingContext processingContext;
        if (runtime != null && (processingContext = runtime.getProcessingContext()) != null && (outputProcessorMetaData = processingContext.getOutputProcessorMetaData()) != null) {
            return !outputProcessorMetaData.isFeatureSupported(OutputProcessorFeature.IGNORE_ROTATION);
        }
        return false;
    }
}

