/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.ResourceMessageFormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.filter.types.RotatableText;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;

public class ResourceMessageType
extends AbstractElementType
implements RotatableText {
    private transient ElementMetaData elementType;
    public static final ElementType INSTANCE = new ResourceMessageType();

    public ResourceMessageType() {
        super("resource-message");
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object resourceMessageRaw = ElementTypeUtils.queryStaticValue(element);
        if (resourceMessageRaw == null) {
            return this.rotate(element, "<null>", runtime);
        }
        return this.rotate(element, resourceMessageRaw.toString(), runtime);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        Object message = ElementTypeUtils.queryStaticValue(element);
        if (message == null) {
            return this.rotate(element, nullValue, runtime);
        }
        Object resourceId = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-identifier");
        if (resourceId == null) {
            return this.rotate(element, nullValue, runtime);
        }
        ResourceMessageFormatFilter messageFormatFilter = element.getElementContext(ResourceMessageFormatFilter.class);
        messageFormatFilter.setFormatKey(String.valueOf(message));
        messageFormatFilter.setResourceIdentifier(String.valueOf(resourceId));
        Object messageNullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "message-null-value");
        if (messageNullValue != null) {
            messageFormatFilter.setNullString(String.valueOf(messageNullValue));
        } else if (nullValue != null) {
            messageFormatFilter.setNullString(String.valueOf(nullValue));
        } else {
            messageFormatFilter.setNullString(null);
        }
        Object value = messageFormatFilter.getValue(runtime, element);
        if (value == null) {
            return this.rotate(element, nullValue, runtime);
        }
        return this.rotate(element, value, runtime);
    }
}

