/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.Query;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.Messages;

public class QueryAddAction<T>
extends AbstractAction {
    private QueryDialogModel<T> model;

    public QueryAddAction(QueryDialogModel<T> model) {
        this.model = model;
        URL location = QueryAddAction.class.getResource("/org/pentaho/reporting/engine/classic/core/designtime/datafactory/resources/Add.png");
        if (location != null) {
            this.putValue("SmallIcon", new ImageIcon(location));
        } else {
            this.putValue("Name", Messages.getString("QueryAddAction.Name", new Object[0]));
        }
        this.putValue("ShortDescription", Messages.getString("QueryAddAction.Description", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String queryName = this.generateQueryName();
        Query<Object> query = new Query<Object>(queryName, null);
        this.model.addQuery(query);
    }

    private boolean containsQueryWithName(String name) {
        for (Query query : this.model) {
            if (!name.equals(query.getName())) continue;
            return true;
        }
        return false;
    }

    private String generateQueryName() {
        String queryNamePattern = Messages.getString("QueryAddAction.QueryPattern", new Object[0]);
        for (int i = 1; i < 1000; ++i) {
            String newQuery = MessageFormat.format(queryNamePattern, i);
            if (this.containsQueryWithName(newQuery)) continue;
            return newQuery;
        }
        return queryNamePattern;
    }
}

