/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui;

import javax.swing.JComponent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.Query;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.QueryEditorPanel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.TextFieldBinding;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class DefaultQueryEditorPanel
extends QueryEditorPanel<String> {
    private RSyntaxTextArea queryTextArea;

    public DefaultQueryEditorPanel(QueryDialogModel<String> dialogModel) {
        super(dialogModel);
    }

    public RSyntaxTextArea getQueryTextArea() {
        return this.queryTextArea;
    }

    public String getSyntaxEditingStyle() {
        return this.getQueryTextArea().getSyntaxEditingStyle();
    }

    public void setSyntaxEditingStyle(String editingStyle) {
        this.getQueryTextArea().setSyntaxEditingStyle(editingStyle);
    }

    @Override
    protected void initialize() {
        this.queryTextArea = new RSyntaxTextArea();
        this.queryTextArea.setSyntaxEditingStyle("text/sql");
        this.queryTextArea.setEnabled(false);
        this.queryTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryDocumentListener()));
    }

    @Override
    protected void updateSelectedQueryFromModel() {
        QueryDialogModel dialogModel = this.getDialogModel();
        Query selectedQuery = dialogModel.getSelectedQuery();
        if (selectedQuery == null) {
            this.queryTextArea.setEnabled(false);
            this.queryTextArea.setText(null);
        } else {
            this.queryTextArea.setEnabled(true);
            this.queryTextArea.setText((String)selectedQuery.getQuery());
        }
    }

    @Override
    protected JComponent getQueryEditor() {
        return new RTextScrollPane(500, 300, (RTextArea)this.queryTextArea, true);
    }

    private class QueryDocumentListener
    extends TextFieldBinding {
        private QueryDocumentListener() {
        }

        @Override
        protected void performUpdate() {
            QueryDialogModel<String> dialogModel = DefaultQueryEditorPanel.this.getDialogModel();
            Query<String> selectedQuery = dialogModel.getSelectedQuery();
            if (selectedQuery == null) {
                return;
            }
            String text = DefaultQueryEditorPanel.this.queryTextArea.getText();
            if (StringUtils.isEmpty((String)text)) {
                text = null;
            }
            if (ObjectUtilities.equal((Object)text, (Object)selectedQuery.getQueryScript())) {
                return;
            }
            dialogModel.updateSelectedQuery(selectedQuery.updateQuery(text));
        }
    }
}

