/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.designtime.Change;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.DetailsFooterType;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.DetailsHeaderType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ReportDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataSchemaDefinition;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractReportDefinition
extends Section
implements ReportDefinition {
    private ExpressionCollection expressions;
    private Group rootGroup;
    private ReportHeader reportHeader;
    private ReportFooter reportFooter;
    private PageHeader pageHeader;
    private PageFooter pageFooter;
    private Watermark watermark;
    private transient EventListenerList eventListeners;
    private long nonVisualsChangeTracker;
    private long datasourceChangeTracker;
    private DataSchemaDefinition dataSchemaDefinition;

    protected AbstractReportDefinition(InstanceID id) {
        super(id);
        this.init();
    }

    protected AbstractReportDefinition() {
        this.init();
    }

    private void init() {
        this.dataSchemaDefinition = new DefaultDataSchemaDefinition();
        this.rootGroup = new RelationalGroup();
        this.reportHeader = new ReportHeader();
        this.reportFooter = new ReportFooter();
        this.pageHeader = new PageHeader();
        this.pageFooter = new PageFooter();
        this.watermark = new Watermark();
        this.expressions = new ExpressionCollection();
        this.registerAsChild(this.rootGroup);
        this.registerAsChild(this.reportHeader);
        this.registerAsChild(this.reportFooter);
        this.registerAsChild(this.pageHeader);
        this.registerAsChild(this.pageFooter);
        this.registerAsChild(this.watermark);
    }

    @Deprecated
    public ResourceBundleFactory getResourceBundleFactory() {
        return DesignTimeUtil.getResourceBundleFactory(this);
    }

    @Deprecated
    public void setResourceBundleFactory(ResourceBundleFactory resourceBundleFactory) {
    }

    public int getPreProcessorCount() {
        Object maybeArray = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "pre-processors");
        if (maybeArray instanceof ReportPreProcessor[]) {
            ReportPreProcessor[] preprocessors = (ReportPreProcessor[])maybeArray;
            return preprocessors.length;
        }
        return 0;
    }

    public ReportPreProcessor[] getPreProcessors() {
        Object maybeArray = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "pre-processors");
        if (maybeArray instanceof ReportPreProcessor[]) {
            ReportPreProcessor[] preprocessors = (ReportPreProcessor[])maybeArray;
            return (ReportPreProcessor[])preprocessors.clone();
        }
        return new ReportPreProcessor[0];
    }

    public ReportPreProcessor getPreProcessor(int index) {
        Object maybeArray = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "pre-processors");
        if (maybeArray instanceof ReportPreProcessor[]) {
            ReportPreProcessor[] preprocessors = (ReportPreProcessor[])maybeArray;
            return preprocessors[index];
        }
        throw new IndexOutOfBoundsException();
    }

    public void addPreProcessor(ReportPreProcessor preProcessor) {
        if (preProcessor == null) {
            throw new NullPointerException();
        }
        ReportPreProcessor[] preprocessors = this.getPreProcessors();
        ArrayList<ReportPreProcessor> newProcessors = new ArrayList<ReportPreProcessor>(Math.max(10, preprocessors.length));
        for (int i = 0; i < preprocessors.length; ++i) {
            ReportPreProcessor preprocessor = preprocessors[i];
            newProcessors.add(preprocessor);
        }
        newProcessors.add(preProcessor);
        ReportPreProcessor[] newArray = newProcessors.toArray(new ReportPreProcessor[newProcessors.size()]);
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "pre-processors", newArray);
    }

    public void removePreProcessor(ReportPreProcessor preProcessor) {
        if (preProcessor == null) {
            throw new NullPointerException();
        }
        ReportPreProcessor[] preprocessors = this.getPreProcessors();
        ArrayList<ReportPreProcessor> newProcessors = new ArrayList<ReportPreProcessor>(Math.max(10, preprocessors.length));
        boolean found = false;
        for (int i = 0; i < preprocessors.length; ++i) {
            ReportPreProcessor preprocessor = preprocessors[i];
            if (!found && preprocessor == preProcessor) continue;
            newProcessors.add(preprocessor);
            found = true;
        }
        if (found) {
            ReportPreProcessor[] newArray = newProcessors.toArray(new ReportPreProcessor[newProcessors.size()]);
            this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "pre-processors", newArray);
        }
    }

    @Override
    public Group getRootGroup() {
        return this.rootGroup;
    }

    public void setRootGroup(Group rootGroup) {
        if (rootGroup == null) {
            throw new NullPointerException();
        }
        if (!(rootGroup instanceof CrosstabGroup) && !(rootGroup instanceof RelationalGroup)) {
            throw new IllegalArgumentException("Only Crosstabs or relational-groups are permitted at the root");
        }
        this.validateLooping(rootGroup);
        if (this.unregisterParent(rootGroup)) {
            return;
        }
        Group oldElement = this.rootGroup;
        this.rootGroup.setParent(null);
        this.rootGroup = rootGroup;
        this.rootGroup.setParent(this);
        this.notifyNodeChildRemoved(oldElement);
        this.notifyNodeChildAdded(rootGroup);
    }

    public void setReportHeader(ReportHeader header) {
        if (header == null) {
            throw new NullPointerException("AbstractReportDefinition.setReportHeader(...) : null not permitted.");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        ReportHeader oldElement = this.reportHeader;
        this.reportHeader.setParent(null);
        this.reportHeader = header;
        this.reportHeader.setParent(this);
        this.notifyNodeChildRemoved(oldElement);
        this.notifyNodeChildAdded(header);
    }

    @Override
    public ReportHeader getReportHeader() {
        return this.reportHeader;
    }

    public void setReportFooter(ReportFooter footer) {
        if (footer == null) {
            throw new NullPointerException("AbstractReportDefinition.setReportFooter(...) : null not permitted.");
        }
        this.validateLooping(footer);
        if (this.unregisterParent(footer)) {
            return;
        }
        ReportFooter oldElement = this.reportFooter;
        this.reportFooter.setParent(null);
        this.reportFooter = footer;
        this.reportFooter.setParent(this);
        this.notifyNodeChildRemoved(oldElement);
        this.notifyNodeChildAdded(footer);
    }

    @Override
    public ReportFooter getReportFooter() {
        return this.reportFooter;
    }

    public void setPageHeader(PageHeader header) {
        if (header == null) {
            throw new NullPointerException("AbstractReportDefinition.setPageHeader(...) : null not permitted.");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        PageHeader oldElement = this.pageHeader;
        this.pageHeader.setParent(null);
        this.pageHeader = header;
        this.pageHeader.setParent(this);
        this.notifyNodeChildRemoved(oldElement);
        this.notifyNodeChildAdded(header);
    }

    @Override
    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    public void setPageFooter(PageFooter footer) {
        if (footer == null) {
            throw new NullPointerException("AbstractReportDefinition.setPageFooter(...) : null not permitted.");
        }
        this.validateLooping(footer);
        if (this.unregisterParent(footer)) {
            return;
        }
        PageFooter oldElement = this.pageFooter;
        this.pageFooter.setParent(null);
        this.pageFooter = footer;
        this.pageFooter.setParent(this);
        this.notifyNodeChildRemoved(oldElement);
        this.notifyNodeChildAdded(footer);
    }

    @Override
    public PageFooter getPageFooter() {
        return this.pageFooter;
    }

    public void setWatermark(Watermark band) {
        if (band == null) {
            throw new NullPointerException("AbstractReportDefinition.setWatermark(...) : null not permitted.");
        }
        this.validateLooping(band);
        if (this.unregisterParent(band)) {
            return;
        }
        Watermark oldElement = this.watermark;
        this.watermark.setParent(null);
        this.watermark = band;
        this.watermark.setParent(this);
        this.notifyNodeChildRemoved(oldElement);
        this.notifyNodeChildAdded(band);
    }

    @Override
    public Watermark getWatermark() {
        return this.watermark;
    }

    @Override
    public NoDataBand getNoDataBand() {
        Group innerMostRelationalGroup = this.getInnerMostRelationalGroup();
        if (innerMostRelationalGroup instanceof CrosstabGroup) {
            CrosstabGroup cg = (CrosstabGroup)innerMostRelationalGroup;
            return cg.getNoDataBand();
        }
        GroupBody body = innerMostRelationalGroup.getBody();
        if (body instanceof GroupDataBody) {
            GroupDataBody gd = (GroupDataBody)body;
            return gd.getNoDataBand();
        }
        return null;
    }

    @Override
    public ItemBand getItemBand() {
        Group group = this.getInnerMostGroup();
        GroupBody body = group.getBody();
        if (body instanceof GroupDataBody) {
            GroupDataBody dataBody = (GroupDataBody)body;
            return dataBody.getItemBand();
        }
        return null;
    }

    @Override
    public DetailsHeader getDetailsHeader() {
        return (DetailsHeader)this.getInnerMostGroup().getChildElementByType(DetailsHeaderType.INSTANCE);
    }

    @Override
    public DetailsFooter getDetailsFooter() {
        return (DetailsFooter)this.getInnerMostGroup().getChildElementByType(DetailsFooterType.INSTANCE);
    }

    private Group getInnerMostGroup() {
        Group existingGroup = this.rootGroup;
        while (existingGroup != null) {
            Group next = existingGroup.getBody().getGroup();
            if (next == null) {
                return existingGroup;
            }
            existingGroup = next;
        }
        throw new IllegalStateException("We shall never reach this point.");
    }

    private Group getInnerMostRelationalGroup() {
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                Element element = gb.getElement(i);
                if (!(element instanceof RelationalGroup)) continue;
                existingGroup = (Group)element;
                gb = existingGroup.getBody();
                found = true;
                break;
            }
            if (found) continue;
            gb = null;
        }
        return existingGroup;
    }

    public void addGroup(RelationalGroup group) {
        if (group == null) {
            throw new NullPointerException("AbstractReporDefinition.addGroup(..) : Null not permitted");
        }
        Group existingGroup = this.getInnerMostRelationalGroup();
        GroupBody gb = existingGroup.getBody();
        existingGroup.setBody(new SubGroupBody(group));
        group.setBody(gb);
    }

    public void addGroup(CrosstabGroup group) {
        if (group == null) {
            throw new NullPointerException("AbstractReporDefinition.addGroup(..) : Null not permitted");
        }
        Group existingGroup = this.getInnerMostRelationalGroup();
        existingGroup.setBody(new SubGroupBody(group));
    }

    public void removeGroup(CrosstabGroup group) {
        SubGroupBody sgb;
        if (group == null) {
            throw new NullPointerException("AbstractReporDefinition.addGroup(..) : Null not permitted");
        }
        if (this.rootGroup == group) {
            this.removeRootGroup();
            return;
        }
        Group existingGroup = this.getInnerMostRelationalGroup();
        GroupBody gb = existingGroup.getBody();
        if (gb instanceof SubGroupBody && (sgb = (SubGroupBody)gb).getGroup() == group) {
            existingGroup.setBody(new GroupDataBody());
        }
    }

    public void removeGroup(RelationalGroup deleteGroup) {
        if (deleteGroup == null) {
            throw new NullPointerException("AbstractReporDefinition.addGroup(..) : Null not permitted");
        }
        if (this.rootGroup == deleteGroup) {
            this.removeRootGroup();
            return;
        }
        Group currentGroup = this.rootGroup;
        Group parentGroup = null;
        GroupBody currentGroupBody = currentGroup.getBody();
        while (currentGroupBody instanceof SubGroupBody && currentGroup != deleteGroup) {
            parentGroup = currentGroup;
            SubGroupBody sgb = (SubGroupBody)currentGroupBody;
            currentGroup = sgb.getGroup();
            currentGroupBody = currentGroup.getBody();
        }
        if (currentGroup == deleteGroup) {
            parentGroup.setBody(currentGroupBody);
            SubGroupBody subGroupBody = (SubGroupBody)currentGroup.getParentSection();
            subGroupBody.setParent(parentGroup);
        }
    }

    private void removeRootGroup() {
        Group group = this.rootGroup;
        GroupBody rootBody = this.rootGroup.getBody();
        if (group instanceof CrosstabGroup) {
            this.rootGroup = new CrosstabGroup();
            this.rootGroup.setBody(rootBody);
        } else if (rootBody instanceof SubGroupBody) {
            SubGroupBody newRootGroup = (SubGroupBody)rootBody;
            this.rootGroup.removeElement(rootBody);
            this.rootGroup = newRootGroup.getGroup();
            this.registerAsChild(this.rootGroup);
        } else {
            this.rootGroup = new RelationalGroup();
            this.rootGroup.setBody(rootBody);
        }
        this.unregisterAsChild(group);
        this.registerAsChild(this.rootGroup);
        this.notifyNodeChildRemoved(group);
        this.notifyNodeChildAdded(this.rootGroup);
    }

    @Override
    public int getGroupCount() {
        int result = 1;
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                Element element = gb.getElement(i);
                if (!(element instanceof Group)) continue;
                existingGroup = (Group)element;
                ++result;
                gb = existingGroup.getBody();
                found = true;
                break;
            }
            if (found) continue;
            gb = null;
        }
        return result;
    }

    public RelationalGroup getRelationalGroup(int groupIndex) {
        Group g = this.getGroup(groupIndex);
        if (g instanceof RelationalGroup) {
            return (RelationalGroup)g;
        }
        return null;
    }

    @Override
    public Group getGroup(int groupIndex) {
        if (groupIndex < 0) {
            throw new IllegalArgumentException("GroupCount must not be negative");
        }
        if (groupIndex == 0) {
            return this.rootGroup;
        }
        int result = 0;
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                Element element = gb.getElement(i);
                if (!(element instanceof Group)) continue;
                existingGroup = (Group)element;
                if (++result == groupIndex) {
                    return existingGroup;
                }
                gb = existingGroup.getBody();
                found = true;
                break;
            }
            if (found) continue;
            gb = null;
        }
        throw new IndexOutOfBoundsException("No group defined at the given index. Max-index=" + result);
    }

    public RelationalGroup getGroupByName(String name) {
        if (name == null) {
            throw new NullPointerException("AbstractReporDefinition.getGroupByName(..) : Null not permitted");
        }
        if (!(this.rootGroup instanceof RelationalGroup)) {
            return null;
        }
        if (this.rootGroup.matches(name)) {
            return (RelationalGroup)this.rootGroup;
        }
        GroupBody gb = this.rootGroup.getBody();
        while (gb instanceof SubGroupBody) {
            SubGroupBody sgb = (SubGroupBody)gb;
            Group group = sgb.getGroup();
            if (!(group instanceof RelationalGroup)) {
                return null;
            }
            if (group.matches(name)) {
                return (RelationalGroup)group;
            }
            gb = group.getBody();
        }
        return null;
    }

    public void addExpression(Expression function) {
        if (function == null) {
            throw new NullPointerException("AbstractReporDefinition.addExpression(..) : Null not permitted");
        }
        this.expressions.add(function);
        this.notifyNodeChildAdded(function);
    }

    @Override
    public int getQueryTimeout() {
        Object queryTimeoutText = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-timeout");
        if (queryTimeoutText instanceof Number) {
            Number n = (Number)queryTimeoutText;
            return n.intValue();
        }
        return 0;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-timeout", IntegerCache.getInteger(queryTimeout));
    }

    @Override
    public int getQueryLimit() {
        Object queryLimitText = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit");
        if (queryLimitText instanceof Number) {
            Number n = (Number)queryLimitText;
            return n.intValue();
        }
        return -1;
    }

    public void setQueryLimit(int queryLimit) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit", IntegerCache.getInteger(queryLimit));
    }

    public void setQueryLimitInheritance(boolean queryLimitInheritance) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit-inheritance", queryLimitInheritance);
    }

    public boolean isQueryLimitInherited() {
        Object queryLimitInheritanceText = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit-inheritance");
        if (queryLimitInheritanceText instanceof Boolean) {
            return (Boolean)queryLimitInheritanceText;
        }
        Object masterReportQueryLimitInheritanceText = this.getMasterReport().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit-inheritance");
        if (masterReportQueryLimitInheritanceText instanceof Boolean) {
            return (Boolean)masterReportQueryLimitInheritanceText;
        }
        return false;
    }

    public int getUserQueryLimit() {
        Object queryLimitText = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit-user");
        if (queryLimitText instanceof Number) {
            Number n = (Number)queryLimitText;
            return n.intValue();
        }
        return -1;
    }

    public void setUserQueryLimit(int queryLimit) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit-user", IntegerCache.getInteger(queryLimit));
    }

    @Override
    public String getQuery() {
        return (String)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query");
    }

    public void setQuery(String query) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query", query);
    }

    public ExpressionCollection getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ExpressionCollection expressions) {
        if (expressions == null) {
            throw new NullPointerException("AbstractReportDefinition.setExpressions(...) : null not permitted.");
        }
        this.expressions = expressions;
        this.notifyNodeStructureChanged();
    }

    @Override
    public AbstractReportDefinition clone() {
        try {
            AbstractReportDefinition report = (AbstractReportDefinition)super.clone();
            report.eventListeners = null;
            report.rootGroup = this.rootGroup.clone();
            report.watermark = (Watermark)this.watermark.clone();
            report.pageFooter = (PageFooter)this.pageFooter.clone();
            report.pageHeader = (PageHeader)this.pageHeader.clone();
            report.reportFooter = (ReportFooter)this.reportFooter.clone();
            report.reportHeader = (ReportHeader)this.reportHeader.clone();
            report.expressions = this.expressions.clone();
            report.dataSchemaDefinition = (DataSchemaDefinition)this.dataSchemaDefinition.clone();
            report.rootGroup.setParent(report);
            report.reportHeader.setParent(report);
            report.reportFooter.setParent(report);
            report.pageHeader.setParent(report);
            report.pageFooter.setParent(report);
            report.watermark.setParent(report);
            ReportPreProcessor[] reportPreProcessors = report.getPreProcessors();
            for (int i = 0; i < reportPreProcessors.length; ++i) {
                reportPreProcessors[i] = reportPreProcessors[i].clone();
            }
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "pre-processors", reportPreProcessors);
            StructureFunction[] structureFunctions = report.getStructureFunctions();
            for (int i = 0; i < structureFunctions.length; ++i) {
                structureFunctions[i] = (StructureFunction)structureFunctions[i].clone();
            }
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "structure-functions", structureFunctions);
            return report;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    @Override
    public AbstractReportDefinition derive(boolean preserveElementInstanceIds) {
        AbstractReportDefinition report = (AbstractReportDefinition)super.derive(preserveElementInstanceIds);
        report.eventListeners = null;
        report.rootGroup = this.rootGroup.derive(preserveElementInstanceIds);
        report.watermark = (Watermark)this.watermark.derive(preserveElementInstanceIds);
        report.pageFooter = (PageFooter)this.pageFooter.derive(preserveElementInstanceIds);
        report.pageHeader = (PageHeader)this.pageHeader.derive(preserveElementInstanceIds);
        report.reportFooter = (ReportFooter)this.reportFooter.derive(preserveElementInstanceIds);
        report.reportHeader = (ReportHeader)this.reportHeader.derive(preserveElementInstanceIds);
        report.expressions = this.expressions.clone();
        report.dataSchemaDefinition = (DataSchemaDefinition)this.dataSchemaDefinition.clone();
        report.rootGroup.setParent(report);
        report.reportHeader.setParent(report);
        report.reportFooter.setParent(report);
        report.pageHeader.setParent(report);
        report.pageFooter.setParent(report);
        report.watermark.setParent(report);
        ReportPreProcessor[] reportPreProcessors = report.getPreProcessors();
        for (int i = 0; i < reportPreProcessors.length; ++i) {
            reportPreProcessors[i] = reportPreProcessors[i].clone();
        }
        report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "pre-processors", reportPreProcessors);
        StructureFunction[] structureFunctions = report.getStructureFunctions();
        for (int i = 0; i < structureFunctions.length; ++i) {
            structureFunctions[i] = (StructureFunction)structureFunctions[i].getInstance();
        }
        report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "structure-functions", structureFunctions);
        return report;
    }

    @Override
    public void setElementAt(int position, Element element) {
        switch (position) {
            case 0: {
                this.setPageHeader((PageHeader)element);
                break;
            }
            case 1: {
                this.setReportHeader((ReportHeader)element);
                break;
            }
            case 2: {
                this.setRootGroup((Group)element);
                break;
            }
            case 3: {
                this.setReportFooter((ReportFooter)element);
                break;
            }
            case 4: {
                this.setPageFooter((PageFooter)element);
                break;
            }
            case 5: {
                this.setWatermark((Watermark)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    @Override
    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException("AbstractReporDefinition.removeElement(..) : Null not permitted");
        }
        if (this.pageHeader == element) {
            this.pageHeader.setParent(null);
            this.pageHeader = new PageHeader();
            this.pageHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.pageHeader);
        } else if (this.watermark == element) {
            this.watermark.setParent(null);
            this.watermark = new Watermark();
            this.watermark.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.watermark);
        } else if (this.reportHeader == element) {
            this.reportHeader.setParent(null);
            this.reportHeader = new ReportHeader();
            this.reportHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.reportHeader);
        } else if (this.rootGroup == element) {
            this.removeRootGroup();
        } else if (this.reportFooter == element) {
            this.reportFooter.setParent(null);
            this.reportFooter = new ReportFooter();
            this.reportFooter.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.reportFooter);
        } else if (this.pageFooter == element) {
            this.pageFooter.setParent(null);
            this.pageFooter = new PageFooter();
            this.pageFooter.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.pageFooter);
        }
    }

    @Override
    public int getElementCount() {
        return 6;
    }

    @Override
    public Element getElement(int index) {
        switch (index) {
            case 0: {
                return this.pageHeader;
            }
            case 1: {
                return this.reportHeader;
            }
            case 2: {
                return this.rootGroup;
            }
            case 3: {
                return this.reportFooter;
            }
            case 4: {
                return this.pageFooter;
            }
            case 5: {
                return this.watermark;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setContentBase(ResourceKey key) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base", key);
    }

    @Override
    public ResourceKey getContentBase() {
        Object attribute = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base");
        if (attribute instanceof ResourceKey) {
            return (ResourceKey)attribute;
        }
        return this.getDefinitionSource();
    }

    public void setDefinitionSource(ResourceKey key) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", key);
    }

    @Override
    public ResourceKey getDefinitionSource() {
        Object attribute = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source");
        if (attribute instanceof ResourceKey) {
            return (ResourceKey)attribute;
        }
        return null;
    }

    @Override
    public ReportDefinition getReportDefinition() {
        return this;
    }

    public abstract DataFactory getDataFactory();

    public abstract void setDataFactory(DataFactory var1);

    public void addReportModelListener(ReportModelListener listener) {
        if (this.eventListeners == null) {
            this.eventListeners = new EventListenerList();
        }
        this.eventListeners.add(ReportModelListener.class, listener);
    }

    public void removeReportModelListener(ReportModelListener listener) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.remove(ReportModelListener.class, listener);
    }

    public void fireModelLayoutChanged(ReportElement node, int type, Object parameter) {
        if (node == this) {
            if (!(parameter instanceof Change)) {
                ++this.nonVisualsChangeTracker;
            }
            if (parameter instanceof DataFactory) {
                ++this.datasourceChangeTracker;
            }
        }
        this.updateInternalChangeFlag();
        if (this.eventListeners != null) {
            ReportModelEvent event = new ReportModelEvent(this, node, type, parameter);
            ReportModelListener[] listeners = (ReportModelListener[])this.eventListeners.getListeners(ReportModelListener.class);
            for (int i = 0; i < listeners.length; ++i) {
                ReportModelListener listener = listeners[i];
                listener.nodeChanged(event);
            }
        }
    }

    public long getDatasourceChangeTracker() {
        return this.datasourceChangeTracker;
    }

    public long getNonVisualsChangeTracker() {
        return this.nonVisualsChangeTracker;
    }

    public void removeExpression(Expression expression) {
        this.expressions.removeExpression(expression);
        this.notifyNodeChildRemoved(expression);
    }

    public DataSchemaDefinition getDataSchemaDefinition() {
        return this.dataSchemaDefinition;
    }

    public void setDataSchemaDefinition(DataSchemaDefinition dataSchemaDefinition) {
        if (dataSchemaDefinition == null) {
            throw new NullPointerException();
        }
        this.dataSchemaDefinition = dataSchemaDefinition;
        this.notifyNodePropertiesChanged();
    }

    @Deprecated
    public abstract ResourceManager getResourceManager();

    public void addStructureFunction(StructureFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        StructureFunction[] structureFunctions = this.getStructureFunctions();
        ArrayList<StructureFunction> newProcessors = new ArrayList<StructureFunction>(Math.max(10, structureFunctions.length));
        for (int i = 0; i < structureFunctions.length; ++i) {
            StructureFunction structureFunction = structureFunctions[i];
            newProcessors.add(structureFunction);
        }
        newProcessors.add(function);
        StructureFunction[] newArray = newProcessors.toArray(new StructureFunction[newProcessors.size()]);
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "structure-functions", newArray);
    }

    public int getStructureFunctionCount() {
        Object maybeArray = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "structure-functions");
        if (maybeArray instanceof StructureFunction[]) {
            StructureFunction[] structureFunctions = (StructureFunction[])maybeArray;
            return structureFunctions.length;
        }
        return 0;
    }

    public StructureFunction getStructureFunction(int index) {
        Object maybeArray = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "structure-functions");
        if (maybeArray instanceof StructureFunction[]) {
            StructureFunction[] structureFunctions = (StructureFunction[])maybeArray;
            return structureFunctions[index];
        }
        throw new IndexOutOfBoundsException();
    }

    public void removeStructureFunction(StructureFunction f) {
        if (f == null) {
            throw new NullPointerException();
        }
        StructureFunction[] structureFunctions = this.getStructureFunctions();
        ArrayList<StructureFunction> newProcessors = new ArrayList<StructureFunction>(Math.max(10, structureFunctions.length));
        boolean found = false;
        for (int i = 0; i < structureFunctions.length; ++i) {
            StructureFunction structureFunction = structureFunctions[i];
            if (!found && structureFunction == f) continue;
            newProcessors.add(structureFunction);
            found = true;
        }
        if (found) {
            StructureFunction[] newArray = newProcessors.toArray(new StructureFunction[newProcessors.size()]);
            this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "structure-functions", newArray);
        }
    }

    public StructureFunction[] getStructureFunctions() {
        Object maybeArray = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "structure-functions");
        if (maybeArray instanceof StructureFunction[]) {
            StructureFunction[] structureFunctions = (StructureFunction[])maybeArray;
            return (StructureFunction[])structureFunctions.clone();
        }
        return new StructureFunction[0];
    }

    @Override
    public ElementStyleSheet getDefaultStyleSheet() {
        return ReportDefaultStyleSheet.getSectionDefault();
    }

    @Override
    public CrosstabCellBody getCrosstabCellBody() {
        GroupBody body = this.getInnerMostGroup().getBody();
        if (body instanceof CrosstabCellBody) {
            return (CrosstabCellBody)body;
        }
        return null;
    }

    public void setAutoSort(Boolean sort) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "auto-sort", sort);
    }

    public Boolean getAutoSort() {
        Object attribute = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "auto-sort");
        if (attribute instanceof Boolean) {
            return (Boolean)attribute;
        }
        return null;
    }
}

