/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.concatfields;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.concatfields.ConcatFields;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsData;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsMetaInjection;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="ConcatFields", name="BaseStep.TypeLongDesc.ConcatFields", categoryDescription="BaseStep.Category.Transform", description="BaseStep.TypeTooltipDesc.ConcatFields", i18nPackageName="org.pentaho.di.trans.step")
public class ConcatFieldsMeta
extends TextFileOutputMeta
implements StepMetaInterface {
    private static Class<?> PKG = ConcatFieldsMeta.class;
    private static final String ConcatFieldsNodeNameSpace = "ConcatFields";
    private String targetFieldName;
    private int targetFieldLength;
    private boolean removeSelectedFields;

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public void setTargetFieldName(String targetField) {
        this.targetFieldName = targetField;
    }

    public int getTargetFieldLength() {
        return this.targetFieldLength;
    }

    public void setTargetFieldLength(int targetFieldLength) {
        this.targetFieldLength = targetFieldLength;
    }

    public boolean isRemoveSelectedFields() {
        return this.removeSelectedFields;
    }

    public void setRemoveSelectedFields(boolean removeSelectedFields) {
        this.removeSelectedFields = removeSelectedFields;
    }

    public void setDefault() {
        super.setDefault();
        super.setHeaderEnabled(false);
        super.setFileName("");
        super.setFileNameInField(false);
        this.targetFieldName = "";
        this.targetFieldLength = 0;
        this.removeSelectedFields = false;
    }

    @Deprecated
    public void getFieldsModifyInput(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        this.getFieldsModifyInput(row, name, info, nextStep, space, null, null);
    }

    public void getFieldsModifyInput(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        super.getFields(row, name, info, nextStep, space, repository, metaStore);
    }

    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.removeSelectedFields) {
            if (this.getOutputFields().length > 0) {
                for (int i = 0; i < this.getOutputFields().length; ++i) {
                    TextFileField field = this.getOutputFields()[i];
                    try {
                        row.removeValueMeta(field.getName());
                        continue;
                    }
                    catch (KettleValueException kettleValueException) {
                        // empty catch block
                    }
                }
            } else {
                row.clear();
            }
        }
        if (Utils.isEmpty((CharSequence)this.targetFieldName)) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldNameMissing", (String[])new String[0]));
        }
        ValueMetaString vValue = new ValueMetaString(this.targetFieldName);
        vValue.setLength(this.targetFieldLength, 0);
        vValue.setOrigin(name);
        if (!Utils.isEmpty((CharSequence)this.getEncoding())) {
            vValue.setStringEncoding(this.getEncoding());
        }
        row.addValueMeta((ValueMetaInterface)vValue);
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(stepnode, databases, metaStore);
        this.targetFieldName = XMLHandler.getTagValue((Node)stepnode, (String)ConcatFieldsNodeNameSpace, (String)"targetFieldName");
        this.targetFieldLength = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)ConcatFieldsNodeNameSpace, (String)"targetFieldLength"), (int)0);
        this.removeSelectedFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)ConcatFieldsNodeNameSpace, (String)"removeSelectedFields"));
        super.setFileName("");
        super.setFileNameInField(false);
    }

    public String getXML() {
        super.setFileName("");
        super.setFileNameInField(false);
        String retval = super.getXML();
        retval = retval + "    <" + ConcatFieldsNodeNameSpace + ">" + Const.CR;
        retval = retval + XMLHandler.addTagValue((String)"targetFieldName", (String)this.targetFieldName);
        retval = retval + XMLHandler.addTagValue((String)"targetFieldLength", (int)this.targetFieldLength);
        retval = retval + XMLHandler.addTagValue((String)"removeSelectedFields", (boolean)this.removeSelectedFields);
        retval = retval + "    </" + ConcatFieldsNodeNameSpace + ">" + Const.CR;
        return retval;
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        super.readRep(rep, metaStore, id_step, databases);
        this.targetFieldName = rep.getStepAttributeString(id_step, "ConcatFieldstargetFieldName");
        this.targetFieldLength = (int)rep.getStepAttributeInteger(id_step, "ConcatFieldstargetFieldLength");
        this.removeSelectedFields = rep.getStepAttributeBoolean(id_step, "ConcatFieldsremoveSelectedFields");
        super.setFileName("");
        super.setFileNameInField(false);
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        super.setFileName("");
        super.setFileNameInField(false);
        super.saveRep(rep, metaStore, id_transformation, id_step);
        rep.saveStepAttribute(id_transformation, id_step, "ConcatFieldstargetFieldName", this.targetFieldName);
        rep.saveStepAttribute(id_transformation, id_step, "ConcatFieldstargetFieldLength", (long)this.targetFieldLength);
        rep.saveStepAttribute(id_transformation, id_step, "ConcatFieldsremoveSelectedFields", this.removeSelectedFields);
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = null;
        if (Utils.isEmpty((CharSequence)this.targetFieldName)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldNameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.targetFieldLength <= 0 && this.isFastDump()) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldLengthMissingFastDataDump", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.getOutputFields().length; ++i) {
                int idx = prev.indexOfValue(this.getOutputFields()[i].getName());
                if (idx >= 0) continue;
                errorMessage = errorMessage + "\t\t" + this.getOutputFields()[i].getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, errorMessage, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ConcatFields(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new ConcatFieldsData();
    }

    public boolean isFileNameInField() {
        return false;
    }

    protected void saveSource(StringBuilder retVal, String value) {
        super.setFileName("");
        super.setFileNameInField(false);
        super.saveSource(retVal, value);
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        return null;
    }

    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new ConcatFieldsMetaInjection(this);
    }

    protected void calcMetaWithFieldOptions(TextFileOutputData data) {
        super.calcMetaWithFieldOptions(data);
    }

    protected synchronized void calcMetaWithFieldOptions(ConcatFieldsData data) {
        if (null == this.metaWithFieldOptions) {
            if (!Utils.isEmpty((Object[])this.getOutputFields())) {
                this.metaWithFieldOptions = new ValueMetaInterface[this.getOutputFields().length];
                for (int i = 0; i < this.getOutputFields().length; ++i) {
                    ValueMetaInterface v = data.inputRowMetaModified.getValueMeta(data.fieldnrs[i]);
                    if (v == null) continue;
                    this.metaWithFieldOptions[i] = v.clone();
                    TextFileField field = this.getOutputFields()[i];
                    this.metaWithFieldOptions[i].setLength(field.getLength());
                    this.metaWithFieldOptions[i].setPrecision(field.getPrecision());
                    if (!Utils.isEmpty((CharSequence)field.getFormat())) {
                        this.metaWithFieldOptions[i].setConversionMask(field.getFormat());
                    }
                    this.metaWithFieldOptions[i].setDecimalSymbol(field.getDecimalSymbol());
                    this.metaWithFieldOptions[i].setGroupingSymbol(field.getGroupingSymbol());
                    this.metaWithFieldOptions[i].setCurrencySymbol(field.getCurrencySymbol());
                    this.metaWithFieldOptions[i].setTrimType(field.getTrimType());
                    if (!Utils.isEmpty((CharSequence)this.getEncoding())) {
                        this.metaWithFieldOptions[i].setStringEncoding(this.getEncoding());
                    }
                    this.metaWithFieldOptions[i].setOutputPaddingEnabled(true);
                }
            } else {
                this.metaWithFieldOptions = null;
            }
        }
    }
}

