/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import mondrian.olap.MondrianProperties;
import mondrian.util.CreationException;
import mondrian.util.FauxMemoryMonitor;
import mondrian.util.MemoryMonitor;
import mondrian.util.NotificationMemoryMonitor;
import mondrian.util.ObjectFactory;
import org.eigenbase.util.property.StringProperty;

public final class MemoryMonitorFactory
extends ObjectFactory.Singleton<MemoryMonitor> {
    private static final MemoryMonitorFactory factory = new MemoryMonitorFactory();
    private static final ThreadLocal<String> ClassName = new ThreadLocal();

    public static MemoryMonitor getMemoryMonitor() {
        return (MemoryMonitor)factory.getObject();
    }

    private static String getThreadLocalClassName() {
        return ClassName.get();
    }

    public static void setThreadLocalClassName(String className) {
        ClassName.set(className);
    }

    public static void clearThreadLocalClassName() {
        ClassName.set(null);
        if (MemoryMonitorFactory.factory.testSingleInstance != null) {
            ((MemoryMonitor)MemoryMonitorFactory.factory.testSingleInstance).removeAllListener();
            MemoryMonitorFactory.factory.testSingleInstance = null;
        }
        if (MemoryMonitorFactory.factory.singleInstance instanceof MemoryMonitor.Test) {
            ((MemoryMonitor.Test)MemoryMonitorFactory.factory.singleInstance).resetFromTest();
        }
    }

    private MemoryMonitorFactory() {
        super(MemoryMonitor.class);
    }

    protected boolean enabled() {
        return MondrianProperties.instance().MemoryMonitor.get();
    }

    @Override
    protected String getClassName() {
        return MemoryMonitorFactory.getThreadLocalClassName();
    }

    @Override
    protected StringProperty getStringProperty() {
        return MondrianProperties.instance().MemoryMonitorClass;
    }

    @Override
    protected MemoryMonitor getDefault(Class[] parameterTypes, Object[] parameterValues) throws CreationException {
        return !this.enabled() ? new FauxMemoryMonitor() : new NotificationMemoryMonitor();
    }
}

