/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.DialectUtil;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;
import mondrian.spi.impl.PostgreSqlDialect;

public class RedshiftDialect
extends PostgreSqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(RedshiftDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        @Override
        protected boolean acceptsConnection(Connection connection) {
            return super.acceptsConnection(connection) && JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.REDSHIFT, connection);
        }
    };

    public RedshiftDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.REDSHIFT;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String value) {
        Util.singleQuoteString(value.replaceAll("\\\\", "\\\\\\\\"), buf);
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        javaRegex = DialectUtil.cleanUnicodeAwareCaseFlag(javaRegex);
        StringBuilder mappedFlags = new StringBuilder();
        String[][] mapping = new String[][]{{"i", "i"}};
        javaRegex = this.extractEmbeddedFlags(javaRegex, mapping, mappedFlags);
        boolean caseSensitive = true;
        if (mappedFlags.toString().contains("i")) {
            caseSensitive = false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("REGEXP_INSTR(");
        sb.append(source);
        sb.append(",");
        this.quoteStringLiteral(sb, javaRegex);
        sb.append(",1,1,0,");
        sb.append(caseSensitive ? "'c'" : "'i'");
        sb.append(") > 0");
        return sb.toString();
    }
}

