/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.rolap.RolapSchema;
import mondrian.server.UrlRepositoryContentFinder;
import mondrian.tui.XmlaSupport;
import mondrian.util.Pair;
import mondrian.xmla.DataSourcesConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicContentFinder
extends UrlRepositoryContentFinder {
    protected String lastDataSourcesConfigString;
    protected DataSourcesConfig.DataSources dataSources;
    private static final Logger LOGGER = LogManager.getLogger(MondrianServer.class);
    private final Timer timer;

    public DynamicContentFinder(String dataSourcesConfigUrl) {
        super(dataSourcesConfigUrl);
        this.reloadDataSources();
        this.timer = Util.newTimer("mondrian.server.DynamicContentFinder$timer", true);
        Pair<Long, TimeUnit> interval = Util.parseInterval(String.valueOf(MondrianProperties.instance().XmlaSchemaRefreshInterval.get()), TimeUnit.MILLISECONDS);
        long period = ((TimeUnit)((Object)interval.right)).toMillis((Long)interval.left);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DynamicContentFinder.this.reloadDataSources();
            }
        }, period, period);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.timer.cancel();
    }

    public synchronized void reloadDataSources() {
        try {
            String dataSourcesConfigString = this.getContent();
            if (!this.hasDataSourcesContentChanged(dataSourcesConfigString)) {
                return;
            }
            DataSourcesConfig.DataSources newDataSources = XmlaSupport.parseDataSources(dataSourcesConfigString, LOGGER);
            if (newDataSources == null) {
                return;
            }
            this.flushObsoleteCatalogs(newDataSources);
            this.dataSources = newDataSources;
            this.lastDataSourcesConfigString = dataSourcesConfigString;
        }
        catch (Exception e) {
            throw Util.newError(e, "Failed to parse data sources config '" + this.url + "'");
        }
    }

    protected boolean hasDataSourcesContentChanged(String dataSourcesConfigString) {
        return dataSourcesConfigString != null && !dataSourcesConfigString.equals(this.lastDataSourcesConfigString);
    }

    private Map<String, Pair<DataSourcesConfig.DataSource, DataSourcesConfig.Catalog>> createCatalogMap(DataSourcesConfig.DataSources newDataSources) {
        HashMap<String, Pair<DataSourcesConfig.DataSource, DataSourcesConfig.Catalog>> newDatasourceCatalogNames = new HashMap<String, Pair<DataSourcesConfig.DataSource, DataSourcesConfig.Catalog>>();
        for (DataSourcesConfig.DataSource dataSource : newDataSources.dataSources) {
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                if (catalog.dataSourceInfo == null) {
                    catalog.dataSourceInfo = dataSource.dataSourceInfo;
                }
                newDatasourceCatalogNames.put(catalog.name, Pair.of(dataSource, catalog));
            }
        }
        return newDatasourceCatalogNames;
    }

    public synchronized void flushObsoleteCatalogs(DataSourcesConfig.DataSources newDataSources) {
        if (this.dataSources == null) {
            return;
        }
        Map<String, Pair<DataSourcesConfig.DataSource, DataSourcesConfig.Catalog>> newDatasourceCatalogs = this.createCatalogMap(newDataSources);
        for (DataSourcesConfig.DataSource oldDataSource : this.dataSources.dataSources) {
            for (DataSourcesConfig.Catalog oldCatalog : oldDataSource.catalogs.catalogs) {
                Pair<DataSourcesConfig.DataSource, DataSourcesConfig.Catalog> pair = newDatasourceCatalogs.get(oldCatalog.name);
                if (pair != null && DynamicContentFinder.areCatalogsEqual(oldDataSource, oldCatalog, (DataSourcesConfig.DataSource)((Object)pair.left), (DataSourcesConfig.Catalog)((Object)pair.right))) continue;
                this.flushCatalog(oldCatalog.name);
            }
        }
    }

    protected void flushCatalog(String catalogName) {
        for (RolapSchema schema : RolapSchema.getRolapSchemas()) {
            if (!schema.getName().equals(catalogName)) continue;
            schema.getInternalConnection().getCacheControl(null).flushSchema(schema);
        }
    }

    public static boolean areCatalogsEqual(DataSourcesConfig.DataSource dataSource1, DataSourcesConfig.Catalog catalog1, DataSourcesConfig.DataSource dataSource2, DataSourcesConfig.Catalog catalog2) {
        return Util.equals(DynamicContentFinder.dsi(dataSource1, catalog1), DynamicContentFinder.dsi(dataSource2, catalog2)) && catalog1.name.equals(catalog2.name) && catalog1.definition.equals(catalog2.definition);
    }

    public static String dsi(DataSourcesConfig.DataSource dataSource, DataSourcesConfig.Catalog catalog) {
        return catalog.dataSourceInfo == null && dataSource != null ? dataSource.dataSourceInfo : catalog.dataSourceInfo;
    }
}

