/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.ListTupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;

public class UnaryTupleList
extends AbstractList<List<Member>>
implements TupleList {
    final List<Member> list;

    public UnaryTupleList() {
        this(new ArrayList<Member>());
    }

    public UnaryTupleList(List<Member> list) {
        this.list = list;
    }

    @Override
    public Member get(int slice, int index) {
        assert (slice == 0);
        return this.list.get(index);
    }

    @Override
    public List<Member> get(int index) {
        return Collections.singletonList(this.list.get(index));
    }

    @Override
    public void add(int index, List<Member> element) {
        this.list.add(index, element.get(0));
    }

    @Override
    public boolean add(List<Member> element) {
        return this.list.add(element.get(0));
    }

    @Override
    public TupleList fix() {
        return this;
    }

    @Override
    public List<Member> set(int index, List<Member> element) {
        Member member = this.list.set(index, element.get(0));
        return member == null ? null : Collections.singletonList(member);
    }

    @Override
    public List<Member> remove(int index) {
        Member member = this.list.remove(index);
        return member == null ? null : Collections.singletonList(member);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public List<Member> slice(int column) {
        return this.list;
    }

    @Override
    public TupleList cloneList(int capacity) {
        return new UnaryTupleList(capacity < 0 ? new ArrayList<Member>(this.list) : new ArrayList(capacity));
    }

    @Override
    public TupleCursor tupleCursor() {
        return this.tupleIterator();
    }

    @Override
    public TupleIterator tupleIterator() {
        return new UnaryIterator();
    }

    @Override
    public final Iterator<List<Member>> iterator() {
        return this.tupleIterator();
    }

    @Override
    public TupleList project(int[] destIndices) {
        assert (destIndices.length == 1);
        assert (destIndices[0] == 0);
        return this;
    }

    @Override
    public void addTuple(Member ... members) {
        assert (members.length == 1);
        this.list.add(members[0]);
    }

    @Override
    public void addCurrent(TupleCursor tupleIter) {
        this.list.add(tupleIter.member(0));
    }

    @Override
    public TupleList subList(int fromIndex, int toIndex) {
        return new ListTupleList(1, this.list.subList(fromIndex, toIndex));
    }

    @Override
    public TupleList withPositionCallback(final TupleList.PositionCallback positionCallback) {
        return new UnaryTupleList((List<Member>)new AbstractList<Member>(){

            @Override
            public Member get(int index) {
                positionCallback.onPosition(index);
                return UnaryTupleList.this.list.get(index);
            }

            @Override
            public int size() {
                return UnaryTupleList.this.list.size();
            }

            @Override
            public Member set(int index, Member element) {
                positionCallback.onPosition(index);
                return UnaryTupleList.this.list.set(index, element);
            }

            @Override
            public void add(int index, Member element) {
                positionCallback.onPosition(index);
                UnaryTupleList.this.list.add(index, element);
            }

            @Override
            public Member remove(int index) {
                positionCallback.onPosition(index);
                return UnaryTupleList.this.list.remove(index);
            }
        });
    }

    private class UnaryIterator
    implements TupleIterator {
        int cursor = 0;
        int lastRet = -1;

        private UnaryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != UnaryTupleList.this.size();
        }

        @Override
        public List<Member> next() {
            try {
                Object next = UnaryTupleList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void currentToArray(Member[] members, int offset) {
            members[offset] = UnaryTupleList.this.list.get(this.lastRet);
        }

        @Override
        public boolean forward() {
            if (this.cursor == UnaryTupleList.this.size()) {
                return false;
            }
            this.lastRet = this.cursor++;
            return true;
        }

        @Override
        public List<Member> current() {
            return UnaryTupleList.this.get(this.lastRet);
        }

        @Override
        public int getArity() {
            return 1;
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                UnaryTupleList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void setContext(Evaluator evaluator) {
            evaluator.setContext(UnaryTupleList.this.list.get(this.lastRet));
        }

        @Override
        public Member member(int column) {
            assert (column == 0);
            return UnaryTupleList.this.list.get(this.lastRet);
        }
    }
}

