/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.palo.celloutput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.palo.core.DimensionField;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.palo.core.PaloNameComparator;
import org.pentaho.di.palo.core.PaloOption;
import org.pentaho.di.palo.core.PaloOptionCollection;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.steps.palo.celloutput.PaloCellOutputData;
import org.pentaho.di.trans.steps.palo.celloutput.PaloCellOutputMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.palo.cellinput.PaloCellInputDialog;

public class PaloCellOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = PaloCellOutputMeta.class;
    private PaloCellOutputMeta meta;
    private TableView tableViewFields;
    private Text textStepName;
    private Combo comboCube;
    private Label labelStepName;
    private Label labelCube;
    private Label labelMeasureType;
    private Combo comboMeasureType;
    private Label labelUpdateMode;
    private Combo comboUpdateMode;
    private Label labelSplashMode;
    private Combo comboSplashMode;
    private Button buttonClearFields;
    private Button buttonGetFields;
    private Button buttonOk;
    private Button buttonCancel;
    private Label labelClearCube;
    private Button buttonClearCube;
    private Label labelCommitSize;
    private Text textCommitSize;
    private Label labelPreloadDimensionCache;
    private Button buttonPreloadDimensionCache;
    private Label labelEnableDimensionCache;
    private Button buttonEnableDimensionCache;
    private CCombo addConnectionLine;
    private ColumnInfo[] colinf;
    private PaloOptionCollection splashOptions = PaloHelper.getSplasModeOptions();
    private PaloOptionCollection updateOptions = PaloHelper.getUpdateModeOptions();

    public static void main(String[] args) {
        try {
            PaloCellOutputDialog window = new PaloCellOutputDialog(null, (Object)new PaloCellOutputMeta(), null, "noname");
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PaloCellOutputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.meta = (PaloCellOutputMeta)((Object)in);
    }

    public String open() {
        Display display = this.getParent().getDisplay();
        this.shell = new Shell(this.getParent(), 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.labelStepName = new Label((Composite)this.shell, 131072);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.labelStepName.setLayoutData((Object)fd);
        this.textStepName = new Text((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, margin);
        this.textStepName.setLayoutData((Object)fd);
        this.addConnectionLine = this.addConnectionLine((Composite)this.shell, (Control)this.textStepName, 35, margin);
        this.labelCube = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.labelCube.setLayoutData((Object)fd);
        this.comboCube = new Combo((Composite)this.shell, 8);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.comboCube.setLayoutData((Object)fd);
        this.labelMeasureType = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.comboCube, margin);
        this.labelMeasureType.setLayoutData((Object)fd);
        this.comboMeasureType = new Combo((Composite)this.shell, 12);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.comboCube, margin);
        this.comboMeasureType.setLayoutData((Object)fd);
        this.labelUpdateMode = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.comboMeasureType, margin);
        this.labelUpdateMode.setLayoutData((Object)fd);
        this.comboUpdateMode = new Combo((Composite)this.shell, 12);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.comboMeasureType, margin);
        this.comboUpdateMode.setLayoutData((Object)fd);
        this.labelSplashMode = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.comboUpdateMode, margin);
        this.labelSplashMode.setLayoutData((Object)fd);
        this.comboSplashMode = new Combo((Composite)this.shell, 12);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.comboUpdateMode, margin);
        this.comboSplashMode.setLayoutData((Object)fd);
        this.labelCommitSize = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.comboSplashMode, margin);
        this.labelCommitSize.setLayoutData((Object)fd);
        this.textCommitSize = new Text((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.comboSplashMode, margin);
        this.textCommitSize.setLayoutData((Object)fd);
        this.labelClearCube = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.textCommitSize, margin);
        this.labelClearCube.setLayoutData((Object)fd);
        this.buttonClearCube = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.textCommitSize, margin);
        this.buttonClearCube.setLayoutData((Object)fd);
        this.labelEnableDimensionCache = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.buttonClearCube, margin);
        this.labelEnableDimensionCache.setLayoutData((Object)fd);
        this.buttonEnableDimensionCache = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.buttonClearCube, margin);
        this.buttonEnableDimensionCache.setLayoutData((Object)fd);
        this.labelPreloadDimensionCache = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.buttonEnableDimensionCache, margin);
        this.labelPreloadDimensionCache.setLayoutData((Object)fd);
        this.buttonPreloadDimensionCache = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.buttonEnableDimensionCache, margin);
        this.buttonPreloadDimensionCache.setLayoutData((Object)fd);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PaloCellOutputDialog.this.meta.setChanged();
            }
        };
        this.colinf = new ColumnInfo[]{new ColumnInfo(this.getLocalizedColumn(0), 1, false, true), new ColumnInfo(this.getLocalizedColumn(1), 2, new String[0], true)};
        this.tableViewFields = new TableView(null, (Composite)this.shell, 2048, this.colinf, 10, true, lsMod, this.props);
        this.tableViewFields.setSize(477, 105);
        this.tableViewFields.setBounds(5, 250, 477, 105);
        this.tableViewFields.setReadonly(true);
        this.tableViewFields.setSortable(false);
        this.tableViewFields.table.removeAll();
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment((Control)this.buttonPreloadDimensionCache, 3 * margin);
        fd.right = new FormAttachment(100, -150);
        fd.bottom = new FormAttachment(100, -50);
        this.tableViewFields.setLayoutData((Object)fd);
        this.buttonGetFields = new Button((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.buttonPreloadDimensionCache, 3 * margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonGetFields.setLayoutData((Object)fd);
        this.buttonClearFields = new Button((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.buttonGetFields, margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonClearFields.setLayoutData((Object)fd);
        this.buttonOk = new Button((Composite)this.shell, 0x1000000);
        this.buttonCancel = new Button((Composite)this.shell, 0x1000000);
        this.buttonOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.buttonCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.buttonOk, this.buttonCancel}, margin, null);
        this.buttonGetFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellOutputDialog.this.doGetFields();
            }
        });
        this.buttonClearFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellOutputDialog.this.doClearFields();
            }
        });
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellOutputDialog.this.cancel();
            }
        });
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellOutputDialog.this.ok();
            }
        });
        this.addConnectionLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellOutputDialog.this.doSelectConnection(false);
            }
        });
        this.comboCube.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellOutputDialog.this.doSelectCube();
            }
        });
        this.buttonEnableDimensionCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PaloCellOutputDialog.this.buttonPreloadDimensionCache.setEnabled(PaloCellOutputDialog.this.buttonEnableDimensionCache.getSelection());
            }
        });
        this.fillLocalizedData();
        this.fillStoredData();
        this.doSelectConnection(false);
        this.props.setLook((Control)this.tableViewFields);
        this.props.setLook((Control)this.textStepName);
        this.props.setLook((Control)this.comboCube);
        this.props.setLook((Control)this.labelStepName);
        this.props.setLook((Control)this.labelCube);
        this.props.setLook((Control)this.labelMeasureType);
        this.props.setLook((Control)this.comboMeasureType);
        this.props.setLook((Control)this.labelUpdateMode);
        this.props.setLook((Control)this.comboUpdateMode);
        this.props.setLook((Control)this.labelSplashMode);
        this.props.setLook((Control)this.comboSplashMode);
        this.props.setLook((Control)this.buttonClearFields);
        this.props.setLook((Control)this.buttonGetFields);
        this.props.setLook((Control)this.buttonOk);
        this.props.setLook((Control)this.buttonCancel);
        this.props.setLook((Control)this.addConnectionLine);
        this.props.setLook((Control)this.buttonClearCube);
        this.props.setLook((Control)this.labelClearCube);
        this.props.setLook((Control)this.textCommitSize);
        this.props.setLook((Control)this.labelCommitSize);
        this.props.setLook((Control)this.labelPreloadDimensionCache);
        this.props.setLook((Control)this.buttonPreloadDimensionCache);
        this.props.setLook((Control)this.labelEnableDimensionCache);
        this.props.setLook((Control)this.buttonEnableDimensionCache);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PaloCellOutputDialog.this.cancel();
            }
        });
        this.meta.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        PaloCellInputDialog.showPaloLibWarningDialog(this.shell);
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private String getLocalizedColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.ColumnDimension", (String[])new String[0]);
            }
            case 1: {
                return BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.ColumnField", (String[])new String[0]);
            }
            case 2: {
                return BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.ColumnType", (String[])new String[0]);
            }
        }
        return "";
    }

    private void fillLocalizedData() {
        this.labelStepName.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.StepName", (String[])new String[0]));
        this.shell.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.PaloCellOutput", (String[])new String[0]));
        this.buttonGetFields.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.GetFields", (String[])new String[0]));
        this.buttonClearFields.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.ClearFields", (String[])new String[0]));
        this.labelCube.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.SelectCube", (String[])new String[0]));
        this.labelMeasureType.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.SelectMeasureType", (String[])new String[0]));
        this.labelUpdateMode.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.UpdateMode", (String[])new String[0]));
        this.labelSplashMode.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.SplashMode", (String[])new String[0]));
        this.labelClearCube.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.ClearCube", (String[])new String[0]));
        this.labelCommitSize.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.CommitSize", (String[])new String[0]));
        this.labelPreloadDimensionCache.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.PreloadDimensionCache", (String[])new String[0]));
        this.labelEnableDimensionCache.setText(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.EnableDimensionCache", (String[])new String[0]));
        for (PaloOption option : this.updateOptions) {
            option.setDescription(BaseMessages.getString(PKG, (String)("PaloCellOutputDialog.UpdateOptions." + option.getCode()), (String[])new String[0]));
        }
        for (PaloOption option : this.splashOptions) {
            option.setDescription(BaseMessages.getString(PKG, (String)("PaloCellOutputDialog.SplashOptions." + option.getCode()), (String[])new String[0]));
        }
    }

    private void fillStoredData() {
        int indexType;
        int index;
        if (this.stepname != null) {
            this.textStepName.setText(this.stepname);
        }
        if ((index = this.addConnectionLine.indexOf(this.meta.getDatabaseMeta() != null ? this.meta.getDatabaseMeta().getName() : "")) >= 0) {
            this.addConnectionLine.select(index);
        }
        if (this.meta.getCube() != null) {
            this.comboCube.add(this.meta.getCube());
            this.comboCube.select(0);
        }
        for (PaloOption option : this.updateOptions) {
            this.comboUpdateMode.add(option.getDescription());
        }
        this.comboUpdateMode.select(this.comboUpdateMode.indexOf(this.updateOptions.getDescription(this.meta.getUpdateMode())));
        for (PaloOption option : this.splashOptions) {
            this.comboSplashMode.add(option.getDescription());
        }
        this.comboSplashMode.select(this.comboSplashMode.indexOf(this.splashOptions.getDescription(this.meta.getSplashMode())));
        this.textCommitSize.setText(String.valueOf(this.meta.getCommitSize()));
        this.buttonEnableDimensionCache.setSelection(this.meta.getEnableDimensionCache());
        this.buttonPreloadDimensionCache.setSelection(this.meta.getPreloadDimensionCache());
        this.buttonPreloadDimensionCache.setEnabled(this.buttonEnableDimensionCache.getSelection());
        this.comboMeasureType.setItems(new String[]{"Numeric", "String"});
        this.comboMeasureType.select(0);
        if (this.meta.getMeasureType() != null && (indexType = this.comboMeasureType.indexOf(this.meta.getMeasureType())) >= 0) {
            this.comboMeasureType.select(indexType);
        }
        this.tableViewFields.table.removeAll();
        if (this.meta.getFields().size() > 0) {
            for (DimensionField level : this.meta.getFields()) {
                this.tableViewFields.add(new String[]{level.getDimensionName(), level.getFieldName()});
            }
        }
        List<String> fieldNameList = null;
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            fieldNameList = Arrays.asList(r.getFieldNames());
            Collections.sort(fieldNameList);
        }
        catch (Exception r) {
            // empty catch block
        }
        this.tableViewFields.setColumnInfo(1, new ColumnInfo("Field", 2, fieldNameList == null ? null : fieldNameList.toArray(new String[0]), true));
        if (this.meta.getMeasure() != null) {
            TableItem item = new TableItem(this.tableViewFields.table, 0);
            item.setText(1, this.meta.getMeasure().getDimensionName());
            item.setText(2, this.meta.getMeasure().getFieldName());
            item.setForeground(Display.getCurrent().getSystemColor(6));
        }
        this.tableViewFields.setRowNums();
        this.tableViewFields.optWidth(true);
        this.buttonClearCube.setSelection(this.meta.getClearCube());
    }

    private void doSelectConnection(boolean clearCurrentData) {
        try {
            DatabaseMeta dbMeta;
            if (clearCurrentData) {
                this.tableViewFields.table.removeAll();
                this.comboCube.removeAll();
            }
            if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
                PaloCellOutputData data = new PaloCellOutputData(dbMeta);
                data.helper.connect();
                List cubes = data.helper.getCubesNames();
                Collections.sort(cubes, new PaloNameComparator());
                for (String cubeName : cubes) {
                    if (this.comboCube.indexOf(cubeName) != -1) continue;
                    this.comboCube.add(cubeName);
                }
                data.helper.disconnect();
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.RetreiveCubesErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.RetreiveCubesError", (String[])new String[0]), ex);
        }
    }

    private void fillPreviousFieldTableViewColumn() throws KettleException {
        RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
        if (r != null) {
            List<String> fieldNameList = Arrays.asList(r.getFieldNames());
            Collections.sort(fieldNameList);
            this.colinf[1] = new ColumnInfo(this.getLocalizedColumn(1), 2, fieldNameList.toArray(new String[0]), true);
        }
    }

    private void doGetFields() {
        try {
            List cubeDimensions = null;
            if (this.comboCube.getText() != null && this.comboCube.getText() != "") {
                DatabaseMeta dbMeta;
                if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
                    PaloCellOutputData data = new PaloCellOutputData(dbMeta);
                    data.helper.connect();
                    cubeDimensions = data.helper.getCubeDimensions(this.comboCube.getText());
                    data.helper.disconnect();
                }
                this.tableViewFields.table.removeAll();
                for (int i = 0; i < cubeDimensions.size(); ++i) {
                    TableItem item = new TableItem(this.tableViewFields.table, 0);
                    item.setText(1, (String)cubeDimensions.get(i));
                }
                TableItem item = new TableItem(this.tableViewFields.table, 0);
                item.setText(1, "Cube Measure");
                item.setForeground(Display.getCurrent().getSystemColor(6));
                this.tableViewFields.removeEmptyRows();
                this.tableViewFields.setRowNums();
                this.tableViewFields.optWidth(true);
                this.tableViewFields.setReadonly(true);
            } else {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), new Exception(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.SelectCubeFirstError", (String[])new String[0])));
            }
            this.fillPreviousFieldTableViewColumn();
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void doClearFields() {
        this.tableViewFields.table.removeAll();
    }

    private void doSelectCube() {
    }

    private void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.meta);
            this.dispose();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.FailedToSaveDataErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.FailedToSaveDataError", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getInfo(PaloCellOutputMeta myMeta) throws KettleException {
        this.stepname = this.textStepName.getText();
        ArrayList<DimensionField> fields = new ArrayList<DimensionField>();
        if (this.updateOptions.getCode(this.comboUpdateMode.getText()) == "ADD" && this.splashOptions.getCode(this.comboSplashMode.getText()) == "SET") {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.UpdateSplashError", (String[])new String[]{BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.UpdateMode", (String[])new String[0]), this.comboUpdateMode.getText(), BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.SplashMode", (String[])new String[0]), this.comboSplashMode.getText()}));
        }
        try {
            Integer.parseInt(this.textCommitSize.getText());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.CommitSizeErrorMessage", (String[])new String[0]));
        }
        for (int i = 0; i < this.tableViewFields.table.getItemCount(); ++i) {
            DimensionField field = new DimensionField(this.tableViewFields.table.getItem(i).getText(1), this.tableViewFields.table.getItem(i).getText(2), "");
            if (i != this.tableViewFields.table.getItemCount() - 1) {
                fields.add(field);
                continue;
            }
            myMeta.setMeasureField(field);
        }
        myMeta.setCube(this.comboCube.getText());
        myMeta.setMeasureType(this.comboMeasureType.getText());
        myMeta.setUpdateMode(this.updateOptions.getCode(this.comboUpdateMode.getText()));
        myMeta.setSplashMode(this.splashOptions.getCode(this.comboSplashMode.getText()));
        myMeta.setLevels(fields);
        myMeta.setClearCube(this.buttonClearCube.getSelection());
        myMeta.setDatabaseMeta(this.transMeta.findDatabase(this.addConnectionLine.getText()));
        myMeta.setCommitSize(Integer.parseInt(this.textCommitSize.getText()));
        myMeta.setEnableDimensionCache(this.buttonEnableDimensionCache.getSelection());
        if (this.buttonEnableDimensionCache.getSelection()) {
            myMeta.setPreloadDimensionCache(this.buttonPreloadDimensionCache.getSelection());
        } else {
            myMeta.setPreloadDimensionCache(false);
        }
        myMeta.setChanged(true);
    }
}

