/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.georss;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.georss.GeoRSSModule;
import com.sun.syndication.feed.module.georss.geometries.AbstractGeometry;
import com.sun.syndication.feed.module.georss.geometries.AbstractRing;
import com.sun.syndication.feed.module.georss.geometries.Envelope;
import com.sun.syndication.feed.module.georss.geometries.LineString;
import com.sun.syndication.feed.module.georss.geometries.LinearRing;
import com.sun.syndication.feed.module.georss.geometries.Point;
import com.sun.syndication.feed.module.georss.geometries.Polygon;
import com.sun.syndication.feed.module.georss.geometries.Position;
import com.sun.syndication.feed.module.georss.geometries.PositionList;
import com.sun.syndication.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class GMLGenerator
implements ModuleGenerator {
    private static final Set NAMESPACES;

    private Element createPosListElement(PositionList positionList) {
        Element element = new Element("posList", GeoRSSModule.GML_NS);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < positionList.size(); ++i) {
            stringBuffer.append(positionList.getLatitude(i)).append(" ").append(positionList.getLongitude(i)).append(" ");
        }
        element.addContent(stringBuffer.toString());
        return element;
    }

    public String getNamespaceUri() {
        return "http://www.opengis.net/gml";
    }

    public Set getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        Element element2 = element;
        while (element2.getParent() != null && element2.getParent() instanceof Element) {
            element2 = (Element)element.getParent();
        }
        element2.addNamespaceDeclaration(GeoRSSModule.SIMPLE_NS);
        element2.addNamespaceDeclaration(GeoRSSModule.GML_NS);
        Element element3 = new Element("where", GeoRSSModule.SIMPLE_NS);
        element.addContent((Content)element3);
        GeoRSSModule geoRSSModule = (GeoRSSModule)module;
        AbstractGeometry abstractGeometry = geoRSSModule.getGeometry();
        if (abstractGeometry instanceof Point) {
            Position position = ((Point)abstractGeometry).getPosition();
            Element element4 = new Element("Point", GeoRSSModule.GML_NS);
            element3.addContent((Content)element4);
            Element element5 = new Element("pos", GeoRSSModule.GML_NS);
            element5.addContent(String.valueOf(position.getLatitude()) + " " + String.valueOf(position.getLongitude()));
            element4.addContent((Content)element5);
        } else if (abstractGeometry instanceof LineString) {
            PositionList positionList = ((LineString)abstractGeometry).getPositionList();
            Element element6 = new Element("LineString", GeoRSSModule.GML_NS);
            element6.addContent((Content)this.createPosListElement(positionList));
            element3.addContent((Content)element6);
        } else if (abstractGeometry instanceof Polygon) {
            Object object;
            Object object2;
            Element element7 = new Element("Polygon", GeoRSSModule.GML_NS);
            Object object3 = ((Polygon)abstractGeometry).getExterior();
            if (object3 instanceof LinearRing) {
                object2 = new Element("exterior", GeoRSSModule.GML_NS);
                element7.addContent((Content)object2);
                object = new Element("LinearRing", GeoRSSModule.GML_NS);
                object2.addContent((Content)object);
                object.addContent((Content)this.createPosListElement(((LinearRing)object3).getPositionList()));
            } else {
                System.err.println("GeoRSS GML format can't handle rings of type: " + object3.getClass().getName());
            }
            object3 = ((Polygon)abstractGeometry).getInterior();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (AbstractRing)object2.next();
                if (object instanceof LinearRing) {
                    Element element8 = new Element("interior", GeoRSSModule.GML_NS);
                    element7.addContent((Content)element8);
                    Element element9 = new Element("LinearRing", GeoRSSModule.GML_NS);
                    element8.addContent((Content)element9);
                    element9.addContent((Content)this.createPosListElement(((LinearRing)object).getPositionList()));
                    continue;
                }
                System.err.println("GeoRSS GML format can't handle rings of type: " + object.getClass().getName());
            }
            element3.addContent((Content)element7);
        } else if (abstractGeometry instanceof Envelope) {
            Envelope envelope = (Envelope)abstractGeometry;
            Element element10 = new Element("Envelope", GeoRSSModule.GML_NS);
            element3.addContent((Content)element10);
            Element element11 = new Element("lowerCorner", GeoRSSModule.GML_NS);
            element11.addContent(String.valueOf(envelope.getMinLatitude()) + " " + String.valueOf(envelope.getMinLongitude()));
            element10.addContent((Content)element11);
            Element element12 = new Element("upperCorner", GeoRSSModule.GML_NS);
            element12.addContent(String.valueOf(envelope.getMaxLatitude()) + " " + String.valueOf(envelope.getMaxLongitude()));
            element10.addContent((Content)element12);
        } else {
            System.err.println("GeoRSS GML format can't handle geometries of type: " + abstractGeometry.getClass().getName());
        }
    }

    static {
        HashSet<Namespace> hashSet = new HashSet<Namespace>();
        hashSet.add(GeoRSSModule.GML_NS);
        NAMESPACES = Collections.unmodifiableSet(hashSet);
    }
}

