/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting.urlrepository;

import java.io.File;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.trans.steps.pentahoreporting.urlrepository.FileObjectContentEntity;
import org.pentaho.di.trans.steps.pentahoreporting.urlrepository.FileObjectContentItem;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;

public class FileObjectContentLocation
extends FileObjectContentEntity
implements ContentLocation {
    private static final long serialVersionUID = -5452372293937107734L;

    public FileObjectContentLocation(ContentLocation parent, FileObject backend) throws ContentIOException {
        super(parent, backend);
        boolean error;
        try {
            error = !backend.exists() || !backend.isFolder();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        if (error) {
            throw new ContentIOException("The given backend-file is not a directory.");
        }
    }

    public FileObjectContentLocation(Repository repository, FileObject backend) throws ContentIOException {
        super(repository, backend);
        boolean error;
        try {
            error = !backend.exists() || !backend.isFolder();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        if (error) {
            throw new ContentIOException("The given backend-file is not a directory.");
        }
    }

    public ContentEntity[] listContents() throws ContentIOException {
        try {
            FileObject file = this.getBackend();
            FileObject[] files = file.getChildren();
            ContentEntity[] entities = new ContentEntity[files.length];
            for (int i = 0; i < files.length; ++i) {
                FileObject child = files[i];
                if (RepositoryUtilities.isInvalidPathName((String)child.getPublicURIString())) continue;
                if (child.isFolder()) {
                    entities[i] = new FileObjectContentLocation(this, child);
                    continue;
                }
                if (!child.isFile()) continue;
                entities[i] = new FileObjectContentLocation(this, child);
            }
            return entities;
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public ContentEntity getEntry(String name) throws ContentIOException {
        try {
            if (RepositoryUtilities.isInvalidPathName((String)name)) {
                throw new IllegalArgumentException("The name given is not valid.");
            }
            FileObject file = this.getBackend();
            FileObject child = file.resolveFile(name);
            if (!child.exists()) {
                throw new ContentIOException("Not found:" + child);
            }
            if (child.isFolder()) {
                return new FileObjectContentLocation(this, child);
            }
            if (child.isFile()) {
                return new FileObjectContentItem(this, child);
            }
            throw new ContentIOException("Not File nor directory.");
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public ContentItem createItem(String name) throws ContentCreationException {
        String fileName = new File(name).getName();
        if (RepositoryUtilities.isInvalidPathName((String)fileName)) {
            throw new IllegalArgumentException("The name given is not valid.");
        }
        try {
            FileObject file = this.getBackend();
            FileObject child = file.resolveFile(fileName);
            if (child.exists()) {
                if (child.getContent().getSize() == 0L) {
                    return new FileObjectContentItem(this, child);
                }
                throw new ContentCreationException("File already exists: " + child);
            }
            try {
                child.createFile();
                return new FileObjectContentItem(this, child);
            }
            catch (IOException e) {
                throw new ContentCreationException("IOError while create", (Exception)e);
            }
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public ContentLocation createLocation(String name) throws ContentCreationException {
        if (RepositoryUtilities.isInvalidPathName((String)name)) {
            throw new IllegalArgumentException("The name given is not valid.");
        }
        try {
            FileObject file = this.getBackend();
            FileObject child = file.resolveFile(name);
            if (child.exists()) {
                throw new ContentCreationException("File already exists.");
            }
            child.createFile();
            try {
                return new FileObjectContentLocation(this, child);
            }
            catch (ContentIOException e) {
                throw new ContentCreationException("Failed to create the content-location", (Exception)((Object)e));
            }
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean exists(String name) {
        if (RepositoryUtilities.isInvalidPathName((String)name)) {
            return false;
        }
        try {
            FileObject file = this.getBackend();
            FileObject child = file.resolveFile(name);
            return child.exists();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }
}

