/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.rssinput;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rssinput.RssInputField;
import org.pentaho.di.trans.steps.rssinput.RssInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.ComponentSelectionListener;

@PluginDialog(id="RssInput", image="RIN.svg", pluginType=PluginDialog.PluginType.STEP, documentationUrl="http://wiki.pentaho.com/display/EAI/Rss+Input")
public class RssInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = RssInputMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wGeneralTab;
    private CTabItem wContentTab;
    private CTabItem wFieldsTab;
    private Composite wGeneralComp;
    private Composite wContentComp;
    private Composite wFieldsComp;
    private FormData fdGeneralComp;
    private FormData fdContentComp;
    private FormData fdFieldsComp;
    private Label wlUrlList;
    private TableView wUrlList;
    private FormData fdlUrlList;
    private FormData fdUrlList;
    private Label wlInclRownum;
    private Button wInclRownum;
    private FormData fdlInclRownum;
    private FormData fdRownum;
    private Label wlInclRownumField;
    private TextVar wInclRownumField;
    private FormData fdlInclRownumField;
    private FormData fdInclRownumField;
    private FormData fdAdditional;
    private Label wlInclUrl;
    private Button wInclUrl;
    private FormData fdlInclUrl;
    private FormData fdUrl;
    private Label wlInclUrlField;
    private TextVar wInclUrlField;
    private FormData fdInclUrlField;
    private FormData fdlInclUrlField;
    private Label wlLimit;
    private Text wLimit;
    private FormData fdlLimit;
    private FormData fdLimit;
    private Label wlReadFrom;
    private Text wReadFrom;
    private FormData fdlReadFrom;
    private FormData fdReadFrom;
    private Group wAdditional;
    private TableView wFields;
    private FormData fdFields;
    private RssInputMeta input;
    private Group GroupUrlField;
    private FormData fdGroupUrlField;
    private FormData fdUrlField;
    private FormData fdUrlInField;
    private FormData fdlUrlInField;
    private FormData fdlUrlField;
    private Label wlUrlField;
    private Label wlUrlInField;
    private CCombo wUrlField;
    private Button wUrlInField;
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};

    public RssInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (RssInputMeta)in;
    }

    public String open() {
        int x;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RssInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.General.Tab", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)fileLayout);
        this.GroupUrlField = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.GroupUrlField);
        this.GroupUrlField.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.GroupUrlField.Label", (String[])new String[0]));
        FormLayout UrlFieldgroupLayout = new FormLayout();
        UrlFieldgroupLayout.marginWidth = 10;
        UrlFieldgroupLayout.marginHeight = 10;
        this.GroupUrlField.setLayout((Layout)UrlFieldgroupLayout);
        this.wlUrlInField = new Label((Composite)this.GroupUrlField, 131072);
        this.wlUrlInField.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.UrlInField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrlInField);
        this.fdlUrlInField = new FormData();
        this.fdlUrlInField.left = new FormAttachment(0, 0);
        this.fdlUrlInField.top = new FormAttachment(0, margin);
        this.fdlUrlInField.right = new FormAttachment(middle, -margin);
        this.wlUrlInField.setLayoutData((Object)this.fdlUrlInField);
        this.wUrlInField = new Button((Composite)this.GroupUrlField, 32);
        this.props.setLook((Control)this.wUrlInField);
        this.wUrlInField.setToolTipText(BaseMessages.getString(PKG, (String)"RssInputDialog.UrlInField.Tooltip", (String[])new String[0]));
        this.fdUrlInField = new FormData();
        this.fdUrlInField.left = new FormAttachment(middle, margin);
        this.fdUrlInField.top = new FormAttachment(0, margin);
        this.wUrlInField.setLayoutData((Object)this.fdUrlInField);
        SelectionAdapter lsurl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RssInputDialog.this.ActiveUrlInField();
                RssInputDialog.this.input.setChanged();
            }
        };
        this.wUrlInField.addSelectionListener((SelectionListener)lsurl);
        this.wlUrlField = new Label((Composite)this.GroupUrlField, 131072);
        this.wlUrlField.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.UrlField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrlField);
        this.fdlUrlField = new FormData();
        this.fdlUrlField.left = new FormAttachment(0, 0);
        this.fdlUrlField.top = new FormAttachment((Control)this.wUrlInField, margin);
        this.fdlUrlField.right = new FormAttachment(middle, -margin);
        this.wlUrlField.setLayoutData((Object)this.fdlUrlField);
        this.wUrlField = new CCombo((Composite)this.GroupUrlField, 2056);
        this.wUrlField.setEditable(true);
        this.props.setLook((Control)this.wUrlField);
        this.wUrlField.addModifyListener(lsMod);
        this.fdUrlField = new FormData();
        this.fdUrlField.left = new FormAttachment(middle, margin);
        this.fdUrlField.top = new FormAttachment((Control)this.wUrlInField, margin);
        this.fdUrlField.right = new FormAttachment(100, -margin);
        this.wUrlField.setLayoutData((Object)this.fdUrlField);
        this.wUrlField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)RssInputDialog.this.shell.getDisplay(), 1);
                RssInputDialog.this.shell.setCursor(busy);
                RssInputDialog.this.setURLPreviousField();
                RssInputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.fdGroupUrlField = new FormData();
        this.fdGroupUrlField.left = new FormAttachment(0, margin);
        this.fdGroupUrlField.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdGroupUrlField.right = new FormAttachment(100, -margin);
        this.GroupUrlField.setLayoutData((Object)this.fdGroupUrlField);
        this.wlUrlList = new Label(this.wGeneralComp, 131072);
        this.wlUrlList.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.UrlList.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrlList);
        this.fdlUrlList = new FormData();
        this.fdlUrlList.left = new FormAttachment(0, 0);
        this.fdlUrlList.top = new FormAttachment((Control)this.GroupUrlField, margin);
        this.wlUrlList.setLayoutData((Object)this.fdlUrlList);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Url", (String[])new String[0]), 1, false)};
        colinfo[0].setUsingVariables(true);
        colinfo[0].setToolTip(BaseMessages.getString(PKG, (String)"RssInputDialog.Url.Tooltip", (String[])new String[0]));
        this.wUrlList = new TableView((VariableSpace)this.transMeta, this.wGeneralComp, 67588, colinfo, 2, lsMod, this.props);
        this.props.setLook((Control)this.wUrlList);
        this.fdUrlList = new FormData();
        this.fdUrlList.left = new FormAttachment(0, 0);
        this.fdUrlList.right = new FormAttachment(100, -margin);
        this.fdUrlList.top = new FormAttachment((Control)this.wlUrlList, 10);
        this.fdUrlList.bottom = new FormAttachment(100, -margin);
        this.wUrlList.setLayoutData((Object)this.fdUrlList);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment(0, 0);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.wContentTab = new CTabItem(this.wTabFolder, 0);
        this.wContentTab.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.Content.Tab", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        this.wContentComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wContentComp);
        this.wContentComp.setLayout((Layout)contentLayout);
        this.wlReadFrom = new Label(this.wContentComp, 131072);
        this.wlReadFrom.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.ReadFrom.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReadFrom);
        this.fdlReadFrom = new FormData();
        this.fdlReadFrom.left = new FormAttachment(0, 0);
        this.fdlReadFrom.top = new FormAttachment((Control)this.wUrlList, margin);
        this.fdlReadFrom.right = new FormAttachment(middle, -margin);
        this.wlReadFrom.setLayoutData((Object)this.fdlReadFrom);
        this.wReadFrom = new Text(this.wContentComp, 18436);
        this.wReadFrom.setToolTipText(BaseMessages.getString(PKG, (String)"RssInputDialog.ReadFrom.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReadFrom);
        this.wReadFrom.addModifyListener(lsMod);
        this.fdReadFrom = new FormData();
        this.fdReadFrom.left = new FormAttachment(middle, 0);
        this.fdReadFrom.top = new FormAttachment((Control)this.wUrlList, margin);
        this.fdReadFrom.right = new FormAttachment(100, 0);
        this.wReadFrom.setLayoutData((Object)this.fdReadFrom);
        this.wlLimit = new Label(this.wContentComp, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        this.fdlLimit = new FormData();
        this.fdlLimit.left = new FormAttachment(0, 0);
        this.fdlLimit.top = new FormAttachment((Control)this.wReadFrom, margin);
        this.fdlLimit.right = new FormAttachment(middle, -margin);
        this.wlLimit.setLayoutData((Object)this.fdlLimit);
        this.wLimit = new Text(this.wContentComp, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.fdLimit = new FormData();
        this.fdLimit.left = new FormAttachment(middle, 0);
        this.fdLimit.top = new FormAttachment((Control)this.wReadFrom, margin);
        this.fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)this.fdLimit);
        this.wAdditional = new Group(this.wContentComp, 32);
        this.props.setLook((Control)this.wAdditional);
        this.wAdditional.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.Group.AdditionalGroup.Label", (String[])new String[0]));
        FormLayout AdditionalgroupLayout = new FormLayout();
        AdditionalgroupLayout.marginWidth = 10;
        AdditionalgroupLayout.marginHeight = 10;
        this.wAdditional.setLayout((Layout)AdditionalgroupLayout);
        this.wlInclUrl = new Label((Composite)this.wAdditional, 131072);
        this.wlInclUrl.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.InclUrl.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclUrl);
        this.fdlInclUrl = new FormData();
        this.fdlInclUrl.left = new FormAttachment(0, 0);
        this.fdlInclUrl.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdlInclUrl.right = new FormAttachment(middle, -margin);
        this.wlInclUrl.setLayoutData((Object)this.fdlInclUrl);
        this.wInclUrl = new Button((Composite)this.wAdditional, 32);
        this.props.setLook((Control)this.wInclUrl);
        this.wInclUrl.setToolTipText(BaseMessages.getString(PKG, (String)"RssInputDialog.InclUrl.Tooltip", (String[])new String[0]));
        this.fdUrl = new FormData();
        this.fdUrl.left = new FormAttachment(middle, 0);
        this.fdUrl.top = new FormAttachment((Control)this.wLimit, margin);
        this.wInclUrl.setLayoutData((Object)this.fdUrl);
        this.wInclUrl.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseStepMeta)this.input));
        this.wlInclUrlField = new Label((Composite)this.wAdditional, 131072);
        this.wlInclUrlField.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.InclUrlField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclUrlField);
        this.fdlInclUrlField = new FormData();
        this.fdlInclUrlField.left = new FormAttachment((Control)this.wInclUrl, margin);
        this.fdlInclUrlField.top = new FormAttachment((Control)this.wLimit, margin);
        this.wlInclUrlField.setLayoutData((Object)this.fdlInclUrlField);
        this.wInclUrlField = new TextVar((VariableSpace)this.transMeta, (Composite)this.wAdditional, 18436);
        this.props.setLook((Control)this.wInclUrlField);
        this.wInclUrlField.addModifyListener(lsMod);
        this.fdInclUrlField = new FormData();
        this.fdInclUrlField.left = new FormAttachment((Control)this.wlInclUrlField, margin);
        this.fdInclUrlField.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdInclUrlField.right = new FormAttachment(100, 0);
        this.wInclUrlField.setLayoutData((Object)this.fdInclUrlField);
        this.wlInclRownum = new Label((Composite)this.wAdditional, 131072);
        this.wlInclRownum.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.InclRownum.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclRownum);
        this.fdlInclRownum = new FormData();
        this.fdlInclRownum.left = new FormAttachment(0, 0);
        this.fdlInclRownum.top = new FormAttachment((Control)this.wInclUrl, margin);
        this.fdlInclRownum.right = new FormAttachment(middle, -margin);
        this.wlInclRownum.setLayoutData((Object)this.fdlInclRownum);
        this.wInclRownum = new Button((Composite)this.wAdditional, 32);
        this.props.setLook((Control)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"RssInputDialog.InclRownum.Tooltip", (String[])new String[0]));
        this.fdRownum = new FormData();
        this.fdRownum.left = new FormAttachment(middle, 0);
        this.fdRownum.top = new FormAttachment((Control)this.wInclUrl, margin);
        this.wInclRownum.setLayoutData((Object)this.fdRownum);
        this.wInclRownum.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseStepMeta)this.input));
        this.wlInclRownumField = new Label((Composite)this.wAdditional, 131072);
        this.wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.InclRownumField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclRownumField);
        this.fdlInclRownumField = new FormData();
        this.fdlInclRownumField.left = new FormAttachment((Control)this.wInclRownum, margin);
        this.fdlInclRownumField.top = new FormAttachment((Control)this.wInclUrl, margin);
        this.wlInclRownumField.setLayoutData((Object)this.fdlInclRownumField);
        this.wInclRownumField = new TextVar((VariableSpace)this.transMeta, (Composite)this.wAdditional, 18436);
        this.props.setLook((Control)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(lsMod);
        this.fdInclRownumField = new FormData();
        this.fdInclRownumField.left = new FormAttachment((Control)this.wlInclRownumField, margin);
        this.fdInclRownumField.top = new FormAttachment((Control)this.wInclUrl, margin);
        this.fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)this.fdInclRownumField);
        this.fdAdditional = new FormData();
        this.fdAdditional.left = new FormAttachment(0, margin);
        this.fdAdditional.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdAdditional.right = new FormAttachment(100, -margin);
        this.wAdditional.setLayoutData((Object)this.fdAdditional);
        this.fdContentComp = new FormData();
        this.fdContentComp.left = new FormAttachment(0, 0);
        this.fdContentComp.top = new FormAttachment(0, 0);
        this.fdContentComp.right = new FormAttachment(100, 0);
        this.fdContentComp.bottom = new FormAttachment(100, 0);
        this.wContentComp.setLayoutData((Object)this.fdContentComp);
        this.wContentComp.layout();
        this.wContentTab.setControl((Control)this.wContentComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.Fields.Tab", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        this.wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)this.wFieldsComp);
        this.wGet = new Button(this.wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.left = new FormAttachment(50, 0);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        int FieldsRows = this.input.getInputFields().length;
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Column", (String[])new String[0]), 2, RssInputField.ColumnDesc, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Format", (String[])new String[0]), 2, formats), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.TrimType", (String[])new String[0]), 2, RssInputField.trimTypeDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Repeat", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true)};
        colinf[0].setUsingVariables(true);
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Name.Tooltip", (String[])new String[0]));
        colinf[1].setUsingVariables(true);
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"RssInputDialog.Field.Column.Tooltip", (String[])new String[0]));
        this.wFields = new TableView((VariableSpace)this.transMeta, this.wFieldsComp, 65538, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment(0, 0);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)this.fdFields);
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        this.wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        this.wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)this.wFieldsComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"RssInputDialog.Button.PreviewRows", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = e -> this.ok();
        this.lsGet = e -> this.get();
        this.lsPreview = e -> this.preview();
        this.lsCancel = e -> this.cancel();
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wPreview.addListener(13, this.lsPreview);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RssInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wLimit.addSelectionListener((SelectionListener)this.lsDef);
        this.wInclRownumField.addSelectionListener(this.lsDef);
        this.wInclRownum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RssInputDialog.this.setIncludeRownum();
            }
        });
        this.wInclUrl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RssInputDialog.this.setIncludeUrl();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                RssInputDialog.this.cancel();
            }
        });
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData(this.input);
        this.ActiveUrlInField();
        this.input.setChanged(this.changed);
        this.wFields.optWidth(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void ActiveUrlInField() {
        this.wUrlList.setEnabled(!this.wUrlInField.getSelection());
        this.wlUrlList.setEnabled(!this.wUrlInField.getSelection());
        this.wUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wlUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wPreview.setEnabled(!this.wUrlInField.getSelection());
        if (this.wUrlInField.getSelection()) {
            this.wInclUrlField.setText("");
            this.wInclUrl.setSelection(false);
        }
        this.wInclUrlField.setEnabled(!this.wUrlInField.getSelection());
        this.wlInclUrlField.setEnabled(!this.wUrlInField.getSelection());
        this.wInclUrl.setEnabled(!this.wUrlInField.getSelection());
        this.wlInclUrl.setEnabled(!this.wUrlInField.getSelection());
        this.setIncludeUrl();
    }

    private void setURLPreviousField() {
        try {
            this.wUrlField.removeAll();
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                r.getFieldNames();
                for (int i = 0; i < r.getFieldNames().length; ++i) {
                    this.wUrlField.add(r.getFieldNames()[i]);
                }
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RssInputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void get() {
        try {
            RssInputMeta meta = new RssInputMeta();
            this.getInfo(meta);
            if (!this.checkInputURL(meta)) {
                return;
            }
            this.wFields.removeAll();
            this.wFields.add(new String[]{RssInputField.getColumnDesc((int)0), RssInputField.getColumnDesc((int)0), "String", "", "", "", "", "", "", "N"});
            this.wFields.add(new String[]{RssInputField.getColumnDesc((int)1), RssInputField.getColumnDesc((int)1), "String", "", "", "", "", "", "", "N"});
            this.wFields.add(new String[]{RssInputField.getColumnDesc((int)2), RssInputField.getColumnDesc((int)2), "String", "", "", "", "", "", "", "N"});
            this.wFields.add(new String[]{RssInputField.getColumnDesc((int)3), RssInputField.getColumnDesc((int)3), "String", "", "", "", "", "", "", "N"});
            this.wFields.add(new String[]{RssInputField.getColumnDesc((int)4), RssInputField.getColumnDesc((int)4), "String", "", "", "", "", "", "", "N"});
            this.wFields.add(new String[]{RssInputField.getColumnDesc((int)5), RssInputField.getColumnDesc((int)5), "String", "", "", "", "", "", "", "N"});
            this.wFields.add(new String[]{RssInputField.getColumnDesc((int)6), RssInputField.getColumnDesc((int)6), "String", "", "", "", "", "", "", "N"});
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RssInputDialog.ErrorGettingFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"getXMLDataDialog.ErrorGettingFields.DialogMessage", (String[])new String[0]), e);
        }
    }

    public void setIncludeRownum() {
        this.wlInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wInclRownumField.setEnabled(this.wInclRownum.getSelection());
    }

    public void setIncludeUrl() {
        this.wlInclUrlField.setEnabled(this.wInclUrl.getSelection());
        this.wInclUrlField.setEnabled(this.wInclUrl.getSelection());
    }

    public void getData(RssInputMeta in) {
        int i;
        if (in.getReadFrom() != null) {
            this.wReadFrom.setText(in.getReadFrom());
        }
        if (in.getUrl() != null) {
            this.wUrlList.removeAll();
            for (i = 0; i < in.getUrl().length; ++i) {
                this.wUrlList.add(new String[]{in.getUrl()[i]});
            }
            this.wUrlList.removeEmptyRows();
            this.wUrlList.setRowNums();
            this.wUrlList.optWidth(true);
        }
        this.wUrlInField.setSelection(in.urlInField());
        if (in.getUrlFieldname() != null) {
            this.wUrlField.setText(in.getUrlFieldname());
        }
        this.wInclRownum.setSelection(in.includeRowNumber());
        if (in.getRowNumberField() != null) {
            this.wInclRownumField.setText(in.getRowNumberField());
        }
        this.wInclUrl.setSelection(in.includeUrl());
        if (in.geturlField() != null) {
            this.wInclUrlField.setText(in.geturlField());
        }
        this.wLimit.setText("" + in.getRowLimit());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"RssInputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        for (i = 0; i < in.getInputFields().length; ++i) {
            String rep;
            RssInputField field = in.getInputFields()[i];
            if (field == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            String name = field.getName();
            String column = field.getColumnDesc();
            String type = field.getTypeDesc();
            String format = field.getFormat();
            String length = "" + field.getLength();
            String prec = "" + field.getPrecision();
            String curr = field.getCurrencySymbol();
            String group = field.getGroupSymbol();
            String decim = field.getDecimalSymbol();
            String trim = field.getTrimTypeDesc();
            String string = rep = field.isRepeated() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
            if (name != null) {
                item.setText(1, name);
            }
            if (column != null) {
                item.setText(2, column);
            }
            if (type != null) {
                item.setText(3, type);
            }
            if (format != null) {
                item.setText(4, format);
            }
            if (length != null && !"-1".equals(length)) {
                item.setText(5, length);
            }
            if (prec != null && !"-1".equals(prec)) {
                item.setText(6, prec);
            }
            if (curr != null) {
                item.setText(7, curr);
            }
            if (decim != null) {
                item.setText(8, decim);
            }
            if (group != null) {
                item.setText(9, group);
            }
            if (trim != null) {
                item.setText(10, trim);
            }
            if (rep == null) continue;
            item.setText(11, rep);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.setIncludeUrl();
        this.setIncludeRownum();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RssInputDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInputDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(RssInputMeta in) throws KettleException {
        this.stepname = this.wStepname.getText();
        in.setReadFrom(this.wReadFrom.getText());
        in.seturlInField(this.wUrlInField.getSelection());
        in.setUrlFieldname(this.wUrlField.getText());
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        in.setIncludeRowNumber(this.wInclRownum.getSelection());
        in.setRowNumberField(this.wInclRownumField.getText());
        in.setIncludeUrl(this.wInclUrl.getSelection());
        in.seturlField(this.wInclUrlField.getText());
        int nrFields = this.wFields.nrNonEmpty();
        int nrUrls = this.wUrlList.nrNonEmpty();
        in.allocate(nrUrls, nrFields);
        in.setUrl(this.wUrlList.getItems(0));
        for (int i = 0; i < nrFields; ++i) {
            RssInputField field = new RssInputField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setColumn(RssInputField.getColumnByDesc((String)item.getText(2)));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(3)));
            field.setFormat(item.getText(4));
            field.setLength(Const.toInt((String)item.getText(5), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(6), (int)-1));
            field.setCurrencySymbol(item.getText(7));
            field.setDecimalSymbol(item.getText(8));
            field.setGroupSymbol(item.getText(9));
            field.setTrimType(RssInputField.getTrimTypeByDesc((String)item.getText(10)));
            field.setRepeated(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(11)));
            in.getInputFields()[i] = field;
        }
    }

    private boolean checkInputURL(RssInputMeta meta) {
        if (this.wUrlList.nrNonEmpty() < 1) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"RssInput.Log.UrlMissing", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return false;
        }
        return true;
    }

    private void preview() {
        try {
            RssInputMeta oneMeta = new RssInputMeta();
            this.getInfo(oneMeta);
            TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"getXMLDataDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"getXMLDataDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Trans trans = progressDialog.getTrans();
                    String loggingText = progressDialog.getLoggingText();
                    if (trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RssInputDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInputDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

