/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.message.modifier.mac;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.message.modifier.AbstractSyslogMessageModifierConfig;
import org.productivity.java.syslog4j.util.Base64;

public class MacSyslogMessageModifierConfig
extends AbstractSyslogMessageModifierConfig {
    private static final long serialVersionUID = 4524180892377960695L;
    protected String macAlgorithm = null;
    protected String keyAlgorithm = null;
    protected Key key = null;

    public MacSyslogMessageModifierConfig(String string, String string2, Key key) {
        this.macAlgorithm = string;
        this.keyAlgorithm = string2;
        this.key = key;
    }

    public MacSyslogMessageModifierConfig(String string, String string2, byte[] byArray) {
        this.macAlgorithm = string;
        this.keyAlgorithm = string2;
        try {
            this.key = new SecretKeySpec(byArray, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SyslogRuntimeException(illegalArgumentException);
        }
    }

    public MacSyslogMessageModifierConfig(String string, String string2, String string3) {
        this.macAlgorithm = string;
        this.keyAlgorithm = string2;
        byte[] byArray = Base64.decode(string3);
        try {
            this.key = new SecretKeySpec(byArray, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SyslogRuntimeException(illegalArgumentException);
        }
    }

    public static MacSyslogMessageModifierConfig createHmacSHA1(Key key) {
        return new MacSyslogMessageModifierConfig("HmacSHA1", "SHA1", key);
    }

    public static MacSyslogMessageModifierConfig createHmacSHA1(String string) {
        return new MacSyslogMessageModifierConfig("HmacSHA1", "SHA1", string);
    }

    public static MacSyslogMessageModifierConfig createHmacSHA256(Key key) {
        return new MacSyslogMessageModifierConfig("HmacSHA256", "SHA-256", key);
    }

    public static MacSyslogMessageModifierConfig createHmacSHA256(String string) {
        return new MacSyslogMessageModifierConfig("HmacSHA256", "SHA-256", string);
    }

    public static MacSyslogMessageModifierConfig createHmacSHA512(Key key) {
        return new MacSyslogMessageModifierConfig("HmacSHA512", "SHA-512", key);
    }

    public static MacSyslogMessageModifierConfig createHmacSHA512(String string) {
        return new MacSyslogMessageModifierConfig("HmacSHA512", "SHA-512", string);
    }

    public static MacSyslogMessageModifierConfig createHmacMD5(Key key) {
        return new MacSyslogMessageModifierConfig("HmacMD5", "MD5", key);
    }

    public static MacSyslogMessageModifierConfig createHmacMD5(String string) {
        return new MacSyslogMessageModifierConfig("HmacMD5", "MD5", string);
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }
}

