/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.ORU_R01_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.ORU_R01_SPECIMEN;
import ca.uhn.hl7v2.model.v251.group.ORU_R01_TIMING_QTY;
import ca.uhn.hl7v2.model.v251.segment.CTD;
import ca.uhn.hl7v2.model.v251.segment.CTI;
import ca.uhn.hl7v2.model.v251.segment.FT1;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.OBR;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ORU_R01_ORDER_OBSERVATION
extends AbstractGroup {
    public ORU_R01_ORDER_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(ORU_R01_TIMING_QTY.class, false, true);
            this.add(CTD.class, false, false);
            this.add(ORU_R01_OBSERVATION.class, false, true);
            this.add(FT1.class, false, true);
            this.add(CTI.class, false, true);
            this.add(ORU_R01_SPECIMEN.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating ORU_R01_ORDER_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ORU_R01_TIMING_QTY getTIMING_QTY() {
        ORU_R01_TIMING_QTY ret = null;
        try {
            ret = (ORU_R01_TIMING_QTY)this.get("TIMING_QTY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORU_R01_TIMING_QTY getTIMING_QTY(int rep) {
        ORU_R01_TIMING_QTY ret = null;
        try {
            ret = (ORU_R01_TIMING_QTY)this.get("TIMING_QTY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMING_QTYReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING_QTY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING_QTY(ORU_R01_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", (Structure)structure, rep);
    }

    public ORU_R01_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (ORU_R01_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public ORU_R01_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (ORU_R01_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public CTD getCTD() {
        CTD ret = null;
        try {
            ret = (CTD)this.get("CTD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORU_R01_OBSERVATION getOBSERVATION() {
        ORU_R01_OBSERVATION ret = null;
        try {
            ret = (ORU_R01_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORU_R01_OBSERVATION getOBSERVATION(int rep) {
        ORU_R01_OBSERVATION ret = null;
        try {
            ret = (ORU_R01_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(ORU_R01_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public ORU_R01_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R01_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public ORU_R01_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R01_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public FT1 getFT1() {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public FT1 getFT1(int rep) {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFT1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("FT1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", (Structure)structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public CTI getCTI() {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTI getCTI(int rep) {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }

    public ORU_R01_SPECIMEN getSPECIMEN() {
        ORU_R01_SPECIMEN ret = null;
        try {
            ret = (ORU_R01_SPECIMEN)this.get("SPECIMEN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORU_R01_SPECIMEN getSPECIMEN(int rep) {
        ORU_R01_SPECIMEN ret = null;
        try {
            ret = (ORU_R01_SPECIMEN)this.get("SPECIMEN", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSPECIMENReps() {
        int reps = -1;
        try {
            reps = this.getAll("SPECIMEN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSPECIMEN(ORU_R01_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public ORU_R01_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORU_R01_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORU_R01_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORU_R01_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

