/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.engine;

import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IAuditable;
import org.pentaho.platform.api.engine.ILogger;

public interface IPentahoSession
extends ILogger,
IAuditable {
    public static final String TENANT_ID_KEY = "org.pentaho.tenantId";
    public static final String SESSION_ROLES = "roles";
    public static final String ATTRIBUTE_LOCALE_OVERRIDE = "locale_override";

    public String getName();

    @Override
    public String getId();

    public void setActionName(String var1);

    public void setProcessId(String var1);

    public void destroy();

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public Object removeAttribute(String var1);

    public Iterator getAttributeNames();

    public Locale getLocale();

    default public String getAttributeLocaleOverride() {
        return StringUtils.defaultIfEmpty((String)((String)this.getAttribute(ATTRIBUTE_LOCALE_OVERRIDE)), null);
    }

    default public void setAttributeLocaleOverride(String locale) {
        this.setAttribute(ATTRIBUTE_LOCALE_OVERRIDE, StringUtils.defaultIfEmpty((String)locale, null));
    }

    public boolean isAuthenticated();

    public void setAuthenticated(String var1);

    public void setNotAuthenticated();

    public void setBackgroundExecutionAlert();

    public boolean getBackgroundExecutionAlert();

    public void resetBackgroundExecutionAlert();
}

