/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.bitmap.DIBReader;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdStretchDibits
extends MfCmd {
    private static final int POS_ROP = 0;
    private static final int POS_USAGE = 2;
    private static final int POS_SRC_H = 3;
    private static final int POS_SRC_W = 4;
    private static final int POS_SRC_Y = 5;
    private static final int POS_SRC_X = 6;
    private static final int POS_DST_H = 7;
    private static final int POS_DST_W = 8;
    private static final int POS_DST_Y = 9;
    private static final int POS_DST_X = 10;
    private static final int POS_DIB = 11;
    private int rop;
    private int srcX;
    private int srcY;
    private int srcW;
    private int srcH;
    private int destX;
    private int destY;
    private int destW;
    private int destH;
    private int usage;
    private int scaled_srcX;
    private int scaled_srcY;
    private int scaled_srcW;
    private int scaled_srcH;
    private int scaled_destX;
    private int scaled_destY;
    private int scaled_destW;
    private int scaled_destH;
    private BufferedImage image;

    @Override
    public void replay(WmfFile file) {
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdStretchDibits();
    }

    @Override
    public int getFunction() {
        return 3907;
    }

    public int getROP() {
        return this.rop;
    }

    public void setROP(int rop) {
        this.rop = rop;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public int getUsage() {
        return this.usage;
    }

    public void setUsage(int usage) {
        this.usage = usage;
    }

    @Override
    public void setRecord(MfRecord record) {
        int rop = record.getLongParam(0);
        int usage = record.getParam(2);
        int srcH = record.getParam(3);
        int srcW = record.getParam(4);
        int ySrc = record.getParam(5);
        int xSrc = record.getParam(6);
        int destH = record.getParam(7);
        int destW = record.getParam(8);
        int yDest = record.getParam(9);
        int xDest = record.getParam(10);
        try {
            DIBReader reader = new DIBReader();
            this.setImage(reader.setRecord(record, 11));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setROP(rop);
        this.setUsage(usage);
        this.setSrcRect(xSrc, ySrc, srcH, srcW);
        this.setDestRect(xDest, yDest, destH, destW);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        throw new RecordCreationException("StretchDIBits is not implemented");
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[STRETCH_DIBITS] rop=");
        b.append(this.getROP());
        b.append(" srcRect=");
        b.append(this.getSrcRect());
        b.append(" destRect=");
        b.append(this.getDestRect());
        b.append(" usage=");
        b.append(this.getUsage());
        return b.toString();
    }

    public void setSrcRect(int x, int y, int w, int h) {
        this.srcX = x;
        this.srcY = y;
        this.srcW = w;
        this.srcH = h;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDestRect(int x, int y, int w, int h) {
        this.destX = x;
        this.destY = y;
        this.destW = w;
        this.destH = h;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Rectangle getSrcRect() {
        return new Rectangle(this.srcX, this.srcY, this.srcW, this.srcH);
    }

    public Rectangle getDestRect() {
        return new Rectangle(this.destX, this.destY, this.destW, this.destH);
    }

    public Rectangle getScaledSrcRect() {
        return new Rectangle(this.scaled_srcX, this.scaled_srcY, this.scaled_srcW, this.scaled_srcH);
    }

    public Rectangle getScaledDestRect() {
        return new Rectangle(this.scaled_destX, this.scaled_destY, this.scaled_destW, this.scaled_destH);
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_srcX = this.getScaledX(this.srcX);
        this.scaled_srcW = this.getScaledX(this.srcW);
        this.scaled_destX = this.getScaledX(this.destX);
        this.scaled_destW = this.getScaledX(this.destW);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_srcY = this.getScaledY(this.srcY);
        this.scaled_srcH = this.getScaledY(this.srcH);
        this.scaled_destY = this.getScaledY(this.destY);
        this.scaled_destH = this.getScaledY(this.destH);
    }
}

