/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ColorConverter;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class StrokeStyleDefinitionReadHandler
extends AbstractXmlReadHandler {
    private Color color;
    private Stroke stroke;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.color = ColorConverter.getObject(attrs.getValue(this.getUri(), "color"));
        float width = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), "width"), (String)"Failed to parse numeric value", (Locator)this.getLocator());
        float miterLimit = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), "miterlimit"), (String)"Failed to parse numeric value", (Locator)this.getLocator());
        float dashPhase = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), "dashPhase"), (String)"Failed to parse numeric value", (Locator)this.getLocator());
        int cap = ParserUtil.parseInt((String)attrs.getValue(this.getUri(), "cap"), (String)"Failed to parse numeric value", (Locator)this.getLocator());
        int join = ParserUtil.parseInt((String)attrs.getValue(this.getUri(), "join"), (String)"Failed to parse numeric value", (Locator)this.getLocator());
        String dashType = attrs.getValue(this.getUri(), "dash");
        Object dash = "DOTTED".equals(dashType) ? StrokeStyleDefinitionReadHandler.getDotted(width) : ("DASHED".equals(dashType) ? StrokeStyleDefinitionReadHandler.getDashed(width) : ("DOT_DASH".equals(dashType) ? StrokeStyleDefinitionReadHandler.getDotDash(width) : (Object)("DOT_DOT_DASH".equals(dashType) ? StrokeStyleDefinitionReadHandler.getDotDotDash(width) : null)));
        this.stroke = new BasicStroke(width, cap, join, miterLimit, (float[])dash, dashPhase);
    }

    private static float[] getDotted(float lineWidth) {
        return new float[]{0.0f, 2.0f * lineWidth};
    }

    private static float[] getDashed(float lineWidth) {
        return new float[]{6.0f * lineWidth, 6.0f * lineWidth};
    }

    private static float[] getDotDash(float lineWidth) {
        return new float[]{0.0f, 2.0f * lineWidth, 6.0f * lineWidth, 2.0f * lineWidth};
    }

    private static float[] getDotDotDash(float lineWidth) {
        return new float[]{0.0f, 2.0f * lineWidth, 0.0f, 2.0f * lineWidth, 6.0f * lineWidth, 2.0f * lineWidth};
    }

    public Object getObject() throws SAXException {
        return null;
    }

    public Color getColor() {
        return this.color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }
}

